/*
 * Decompiled with CFR 0.152.
 */
package antiqueatlasautomarker.config.folders;

import antiqueatlasautomarker.AntiqueAtlasAutoMarker;
import antiqueatlasautomarker.config.AutoMarkSetting;
import antiqueatlasautomarker.mixin.vanilla.MapGenStructureIOAccessor;
import fermiumbooter.annotations.MixinConfig;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraftforge.common.config.Config;

@MixinConfig(name="antiqueatlasautomarker")
public class StructuresConfig {
    @Config.Comment(value={"Set to false to fully disable vanilla structure marker system"})
    @Config.Name(value="Structures Enabled")
    @MixinConfig.MixinToggle(earlyMixin="mixins.aaam.vanilla.structures.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="antiqueatlas", desired=true)
    @Config.RequiresMcRestart
    public boolean enabled = false;
    @Config.Comment(value={"Pattern: structureName; enabled; marker label; marker type. Automatically fills with entries after restart."})
    @Config.Name(value="Structure Markers")
    public String[] structureOptions = new String[0];

    public void postInit() {
        if (!this.enabled) {
            return;
        }
        int nStructs = this.structureOptions.length;
        ArrayList<String> toAdd = new ArrayList<String>(Arrays.asList(this.structureOptions));
        for (String s : MapGenStructureIOAccessor.getMap().keySet()) {
            if (AutoMarkSetting.get(s) != null) continue;
            toAdd.add(s + "; false; your label here; your marker type here");
        }
        AntiqueAtlasAutoMarker.CONFIG.get("general.Structures", "Structure Markers", this.structureOptions, "Pattern: structureName; enabled; marker label; marker type. Automatically fills with entries after restart.").set(toAdd.toArray(new String[0]));
        this.structureOptions = toAdd.toArray(new String[0]);
        if (this.structureOptions.length - nStructs > 0) {
            AntiqueAtlasAutoMarker.CONFIG.save();
        }
    }
}

