/*
 * Decompiled with CFR 0.152.
 */
package antiqueatlasautomarker.config.folders;

import antiqueatlasautomarker.AntiqueAtlasAutoMarker;
import antiqueatlasautomarker.config.ConfigHandler;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import hunternif.mc.atlas.client.BiomeTextureMap;
import hunternif.mc.atlas.client.TextureSet;
import hunternif.mc.atlas.client.TextureSetMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Config;

public class BiomeTileConfig {
    @Config.Comment(value={"If a biome doesn't have BiomeTextureSets registered, its biome dictionary types will be used to assign it a textureset. \nThe rules provided here are matched against the given types in order. The first rule that matches will be used.This order means that rules with more rare sets of biometypes need to be defined farther up, it gets more generic farther down.\nPattern: type1, type2, type3 = textureset\nWhere \"|\" denotes \"OR\" and \",\" is used as \"AND\".\nAvailable biomedict types: HOT, COLD, SPARSE, DENSE, WET, DRY, SAVANNA, CONIFEROUS, JUNGLE, SPOOKY, DEAD, LUSH, NETHER, END, MUSHROOM, MAGICAL, RARE, OCEAN, RIVER, WATER, MESA, FOREST, PLAINS, MOUNTAIN, HILLS, SWAMP, SANDY, SNOWY, WASTELAND, BEACH, VOID\nAvailable biome texturesets: ICE, SHORE, ROCK_SHORE, DESERT, PLAINS, SUNFLOWERS, HILLS, DESERT_HILLS, ICE_SPIKES, SNOW_PINES, SNOW_PINES_HILLS, SNOW_HILLS, SNOW, MOUNTAINS_NAKED, MOUNTAINS, MOUNTAINS_SNOW_CAPS, MOUNTAINS_ALL, FOREST, FOREST_HILLS, FOREST_FLOWERS, DENSE_FOREST, DENSE_FOREST_HILLS, BIRCH, BIRCH_HILLS, TALL_BIRCH, TALL_BIRCH_HILLS, DENSE_BIRCH, JUNGLE, JUNGLE_HILLS, JUNGLE_CLIFFS, JUNGLE_EDGE, JUNGLE_EDGE_HILLS, PINES, PINES_HILLS, SAVANNA, SAVANNA_CLIFFS, PLATEAU_SAVANNA_M, MESA, BRYCE, PLATEAU_MESA, PLATEAU_MESA_LOW, PLATEAU_MESA_TREES, PLATEAU_MESA_TREES_LOW, PLATEAU_SAVANNA, MEGA_SPRUCE, MEGA_SPRUCE_HILLS, MEGA_TAIGA, MEGA_TAIGA_HILLS, SWAMP, SWAMP_HILLS, MUSHROOM, WATER, LAVA, LAVA_SHORE, CAVE_WALLS, RAVINE, END_ISLAND, END_ISLAND_PLANTS, END_VOID\nNOTE: by default, this is using the same rules that Antique Atlas is using."})
    @Config.Name(value="Automatic Biometype Rules")
    @Config.RequiresMcRestart
    public String[] automaticTypeRules = new String[]{"SWAMP, HILLS = SWAMP_HILLS", "SWAMP = SWAMP", "WATER|RIVER, FOREST|JUNGLE, HILLS = SWAMP_HILLS", "WATER|RIVER, FOREST|JUNGLE = SWAMP", "WATER|RIVER, SNOWY = ICE", "WATER|RIVER = WATER", "BEACH, MOUNTAIN = ROCK_SHORE", "BEACH = SHORE", "JUNGLE, MOUNTAIN = JUNGLE_CLIFFS", "JUNGLE, HILLS = JUNGLE_HILLS", "JUNGLE = JUNGLE", "SAVANNA, MOUNTAIN|HILLS = SAVANNA_CLIFFS", "SAVANNA = SAVANNA", "CONIFEROUS, MOUNTAIN|HILLS = PINES_HILLS", "CONIFEROUS = PINES", "MESA, FOREST = PLATEAU_MESA_TREES", "MESA = PLATEAU_MESA", "FOREST, SNOWY, HILLS = SNOW_PINES_HILLS", "FOREST, SNOWY = SNOW_PINES", "FOREST, SPARSE, HILLS = SPARSE_FOREST_HILLS", "FOREST, SPARSE = SPARSE_FOREST", "FOREST, DENSE, HILLS = DENSE_FOREST_HILLS", "FOREST, DENSE = DENSE_FOREST", "FOREST, HILLS = FOREST_HILLS", "FOREST = FOREST", "PLAINS|WASTELAND, SNOWY|COLD, MOUNTAIN = MOUNTAINS_SNOW_CAPS", "PLAINS|WASTELAND, SNOWY|COLD, HILLS = SNOW_HILLS", "PLAINS|WASTELAND, SNOWY|COLD = SNOW", "PLAINS|WASTELAND, HOT, MOUNTAIN|HILLS = DESERT_HILLS", "PLAINS|WASTELAND, HOT = DESERT", "PLAINS|WASTELAND, MOUNTAIN|HILLS = HILLS", "PLAINS|WASTELAND = PLAINS", "MOUNTAIN = MOUNTAINS_NAKED", "HILLS, SNOWY|COLD = SNOW_HILLS", "HILLS, SANDY = DESERT_HILLS", "HILLS = HILLS"};
    @Config.Comment(value={"Define custom village tiles for custom village components here. \nPattern: componentName, textureSetName, priority\nComponent Names can be found in saves/yourworld/data/Village.dat in entries called \"id\"\nThis also allows Recurrent Complex village components, use their \"RcSId\"\nWaystone Id is \"waystones:village_waystone\""})
    @Config.Name(value="Custom Village Tiles")
    @Config.RequiresMcRestart
    public String[] customVillageTiles = new String[0];
    @Config.Comment(value={"Will only apply if BetterEnd Backport and NetherAPI are present. By Artsy (2025), slightly modified by Nischhelm."})
    @Config.Name(value="Use Colorised BetterEnd Tiles")
    @Config.RequiresMcRestart
    public boolean useColorisedBetterEndTiles = true;
    public boolean useColorisedBetterNetherTiles = true;
    public boolean useColorisedDregoraTiles = true;
    @Config.Comment(value={"Will only apply if DefiledLands is present. By Artsy (2021), modified original tiles by AA."})
    @Config.Name(value="Use Colorised DefiledLands Tiles")
    @Config.RequiresMcRestart
    public boolean useColorisedDefiledLandsTiles = true;
    @Config.Comment(value={"Will only apply if Traverse is present. By Artsy (2021), modified original tiles by AA."})
    @Config.Name(value="Use Colorised Traverse Tiles")
    @Config.RequiresMcRestart
    public boolean useColorisedTraverseTiles = true;
    @Config.Comment(value={"Will only apply if Biomes'O'Plenty is present. Mostly by Golrith (2015), currently being edited by Nischhelm."})
    @Config.Name(value="Use Colorised BOP Tiles")
    @Config.RequiresMcRestart
    public boolean useColorisedBOPTiles = true;
    @Config.Comment(value={"Will only apply if Thaumcraft is present. By Golrith (2015)."})
    @Config.Name(value="Use Colorised Thaumcraft Tiles")
    @Config.RequiresMcRestart
    public boolean useColorisedThaumcraftTiles = true;
    @Config.Comment(value={"Will apply colorised vanilla tiles by either Artsy, Golrith or both, where Golrith is prioritised as that set has missing tiles for various biomes for which Artsy textures are used. By Golrith (2015) and Artsy (2021)."})
    @Config.Name(value="Use Colorised Vanilla Tiles")
    @Config.RequiresMcRestart
    public EnumTextureSetArtist useColorisedVanillaTiles = EnumTextureSetArtist.ARTSY;
    @Config.Comment(value={"Stitching to null (undiscovered chunks) was meant to exist in Antique Atlas but never correctly implemented. AAAM fixes it. \nAdd texture set names here to make them stitch to null.\nBy default, AA has ROCK_SHORE and LAVA_SHORE stitch to null (without that doing anything)."})
    @Config.Name(value="TextureSets stitch to null")
    @Config.RequiresMcRestart
    public String[] stitchToNullSets = new String[]{"END_VOID", "LAVA_SHORE", "LAVA"};
    private static final List<TextureSetRule> allRules = new ArrayList<TextureSetRule>();

    public static void init() {
        for (String configLine : ConfigHandler.overhaul.tileConfig.automaticTypeRules) {
            new TextureSetRule(configLine);
        }
    }

    public static TextureSet getTextureSet(Set<BiomeDictionary.Type> types) {
        for (TextureSetRule rule : allRules) {
            if (!rule.matcher.apply(types)) continue;
            return rule.textureSet;
        }
        return BiomeTextureMap.defaultTexture;
    }

    public static class TextureSetRule {
        private final Predicate<Set<BiomeDictionary.Type>> matcher;
        private final TextureSet textureSet;

        public TextureSetRule(String configLine) {
            if (!configLine.matches("^[\\w,|\\s_]+\\s*=\\s*[\\w_]+$")) {
                this.matcher = types -> false;
                this.textureSet = BiomeTextureMap.defaultTexture;
                AntiqueAtlasAutoMarker.LOGGER.warn("AAAM: Automatic TextureSet rule doesn't match expected pattern, ignoring {}", (Object)configLine);
            } else {
                String[] split = configLine.split("=");
                this.textureSet = TextureSetMap.instance().getByName(split[1].trim());
                configLine = split[0].trim();
                split = configLine.split(",");
                Predicate hasToMatchAllGivenTypes = types -> true;
                for (String entry : split) {
                    if (entry.contains("|")) {
                        String[] split2 = entry.split("\\|");
                        Predicate matchesMultipleTypes = types -> false;
                        for (String inner : split2) {
                            BiomeDictionary.Type typeToCheckFor = BiomeDictionary.Type.getType((String)inner.trim(), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                            matchesMultipleTypes = Predicates.or((Predicate)matchesMultipleTypes, types -> types.contains(typeToCheckFor));
                        }
                        hasToMatchAllGivenTypes = Predicates.and((Predicate)hasToMatchAllGivenTypes, (Predicate)matchesMultipleTypes);
                        continue;
                    }
                    BiomeDictionary.Type typeToCheckFor = BiomeDictionary.Type.getType((String)entry.trim(), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                    hasToMatchAllGivenTypes = Predicates.and((Predicate)hasToMatchAllGivenTypes, types -> types.contains(typeToCheckFor));
                }
                this.matcher = hasToMatchAllGivenTypes;
                allRules.add(this);
            }
        }
    }

    public static enum EnumTextureSetArtist {
        ARTSY,
        GOLRITH,
        BOTH,
        NONE;

    }
}

