/*
 * Decompiled with CFR 0.152.
 */
package antiqueatlasautomarker.config;

import antiqueatlasautomarker.AntiqueAtlasAutoMarker;
import antiqueatlasautomarker.config.ConfigHandler;
import java.util.HashMap;
import java.util.Map;

public class EnchMarkSetting {
    public final String enchId;
    public final int minLvl;
    public final String abbreviation;
    public static boolean acceptAll = false;
    private static final Map<String, EnchMarkSetting> enchMarkSettings = new HashMap<String, EnchMarkSetting>();

    public EnchMarkSetting(String enchId, int minLvl, String abbreviation) {
        this.enchId = enchId;
        this.minLvl = minLvl;
        this.abbreviation = abbreviation;
    }

    public static EnchMarkSetting get(String enchId) {
        return enchMarkSettings.get(enchId);
    }

    public static boolean contains(String enchId) {
        return enchMarkSettings.containsKey(enchId);
    }

    public static void init() {
        if (ConfigHandler.enchantments.enchantmentsToMark.length == 1 && ConfigHandler.enchantments.enchantmentsToMark[0].equals("ALL")) {
            acceptAll = true;
        } else {
            for (String s : ConfigHandler.enchantments.enchantmentsToMark) {
                String[] split = s.split(";");
                if (split.length < 1 || split.length > 3) continue;
                try {
                    enchMarkSettings.put(split[0].trim(), new EnchMarkSetting(split[0].trim(), split.length > 1 && !split[1].isEmpty() ? Integer.parseInt(split[1].trim()) : 0, split.length == 3 ? split[2].trim() : ""));
                }
                catch (Exception e) {
                    AntiqueAtlasAutoMarker.LOGGER.warn("Could not parse AAAM line for enchantment, skipping {}", (Object)s);
                }
            }
        }
    }

    public static void reset() {
        enchMarkSettings.clear();
        acceptAll = false;
        EnchMarkSetting.init();
    }
}

