/*
 * Decompiled with CFR 0.152.
 */
package antiqueatlasautomarker.config;

import antiqueatlasautomarker.AntiqueAtlasAutoMarker;
import antiqueatlasautomarker.config.ConfigHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class AutoMarkSetting {
    public final String label;
    public final boolean enabled;
    public final String type;
    public final String context;
    private static final Map<String, AutoMarkSetting> autoMarkSettings = new HashMap<String, AutoMarkSetting>();

    public AutoMarkSetting(boolean enabled, String label, String type, String context) {
        this.enabled = enabled;
        this.label = label;
        this.type = type;
        this.context = context;
    }

    @Nullable
    public static AutoMarkSetting get(String name) {
        return autoMarkSettings.get(name);
    }

    public static void init() {
        List stringConfigs = Arrays.stream(ConfigHandler.ruins.ruinsMarkers).map(s -> "ruins_" + s).collect(Collectors.toList());
        stringConfigs.addAll(Arrays.asList(ConfigHandler.vanillaStructs.structureOptions));
        for (String s2 : stringConfigs) {
            String[] split = s2.split(";");
            if (split.length != 4) continue;
            try {
                AutoMarkSetting.registerAutoMarkSetting(split[0].trim(), Boolean.parseBoolean(split[1].trim()), split[2].trim(), split[3].trim());
            }
            catch (Exception e) {
                AntiqueAtlasAutoMarker.LOGGER.warn("Could not parse AAAM config line, skipping {}", (Object)s2);
            }
        }
    }

    public static void reset() {
        autoMarkSettings.clear();
        AutoMarkSetting.init();
    }

    public static void registerAutoMarkSetting(String context, boolean enabled, String label, String type) {
        autoMarkSettings.put(context, new AutoMarkSetting(enabled, label, type, context));
    }
}

