/*
 * Decompiled with CFR 0.152.
 */
package antiqueatlasautomarker.compat.crafttweaker;

import antiqueatlasautomarker.compat.crafttweaker.CT_BiomeDetectorExpansion;
import antiqueatlasautomarker.event.BiomeDetectorEvent;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.event.IWorldEvent;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IBiome;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.world.MCBiome;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenRegister
@ZenClass(value="mods.antiqueatlasautomarker.BiomeDetectorEvent")
public class CT_BiomeDetectorEvent
implements IWorldEvent {
    private final BiomeDetectorEvent internal;
    private static final Map<String, ResourceLocation> locs = new HashMap<String, ResourceLocation>();

    public CT_BiomeDetectorEvent(BiomeDetectorEvent internal) {
        this.internal = internal;
    }

    @ZenMethod
    @ZenGetter(value="x")
    public int getX() {
        return this.internal.getChunk().field_76635_g;
    }

    @ZenMethod
    @ZenGetter(value="z")
    public int getZ() {
        return this.internal.getChunk().field_76647_h;
    }

    @ZenMethod
    public IBlock getTopBlock(int x, int z) {
        return CraftTweakerMC.getBlock((IBlockAccess)this.internal.getWorld(), (int)x, (int)this.internal.getChunk().func_76611_b(x, z), (int)z);
    }

    @ZenMethod
    public int getIdFor(String type) {
        return this.internal.getIdFor(type);
    }

    @ZenMethod
    @ZenGetter(value="types")
    public String[] getCountTypes() {
        return this.internal.getCountTypes().toArray(new String[0]);
    }

    @ZenMethod
    @ZenGetter(value="world")
    public IWorld getWorld() {
        return CraftTweakerMC.getIWorld((World)this.internal.getWorld());
    }

    @ZenMethod
    @ZenGetter(value="mainBiome")
    public IBiome getMainBiome() {
        return new MCBiome(this.internal.getMainBiome());
    }

    @ZenMethod
    public int getCountFor(String type) {
        return this.internal.getCountFor(type);
    }

    @ZenMethod
    @ZenGetter(value="chosenType")
    public String getChosenType() {
        return this.internal.getChosenType();
    }

    @ZenMethod
    @ZenSetter(value="chosenType")
    public void setChosenType(String type) {
        if (!this.internal.setChosenType(type)) {
            CraftTweakerAPI.logWarning((String)("AAAM BiomeDetectorEvent setting type to " + type + ", not valid, ignoring"));
        }
    }

    @ZenMethod
    @ZenGetter(value="chosenId")
    public int getChosenId() {
        return this.internal.getChosenBiomeId();
    }

    @ZenMethod
    @ZenSetter(value="chosenId")
    public void setChosenId(int id) {
        this.internal.setChosenBiomeId(id);
    }

    @ZenMethod
    @ZenSetter(value="chosenBiome")
    public void setChosenBiome(String biomeName) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(locs.computeIfAbsent(biomeName, ResourceLocation::new));
        if (biome != null) {
            this.setChosenId(Biome.func_185362_a((Biome)biome));
        } else {
            CraftTweakerAPI.logWarning((String)("AAAM BiomeDetectorEvent didnt find biome named " + biomeName + ", ignoring"));
        }
    }

    @ZenMethod
    @ZenSetter(value="chosenTile")
    public void setChosenTile(String tileName) {
        int id = ExtTileIdMap.instance().getPseudoBiomeID(tileName);
        if (id != -1) {
            this.setChosenId(id);
        } else {
            CraftTweakerAPI.logWarning((String)("AAAM BiomeDetectorEvent didnt find id for tile named " + tileName + ", ignoring"));
        }
    }

    @ZenMethod
    @ZenGetter(value="chosenTile")
    public String getChosenTile() {
        int id = this.getChosenId();
        if (id >= 0) {
            Biome biome = Biome.func_150568_d((int)id);
            if (biome == null || biome.getRegistryName() == null) {
                return "BIOME_NOT_FOUND";
            }
            return biome.getRegistryName().toString();
        }
        if (id == -1) {
            return "NOT_FOUND";
        }
        return ExtTileIdMap.instance().getPseudoBiomeName(id);
    }

    public static class CT_EventForwarder {
        @SubscribeEvent
        public static void onBiomeDetect(BiomeDetectorEvent event) {
            if (CT_BiomeDetectorExpansion.hasBiomeDetectorHandlers()) {
                CT_BiomeDetectorExpansion.publishBiomeDetector(new CT_BiomeDetectorEvent(event));
            }
        }
    }
}

