/*
 * Decompiled with CFR 0.152.
 */
package antiqueatlasautomarker.compat;

import aarcaddon.handlers.ConfigHandler;
import antiqueatlasautomarker.config.AutoMarkSetting;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class AARCCompat {
    private static final Map<String, AutoMarkSetting> cachedAarcSettings = new HashMap<String, AutoMarkSetting>();

    @Nullable
    private static AutoMarkSetting getCachedSetting(String structureName) {
        if (!cachedAarcSettings.containsKey(structureName)) {
            String[] aarcSetting = (String[])ConfigHandler.structureDeclarationList.get(structureName);
            String type = aarcSetting[1];
            if (!type.contains(":")) {
                type = "antiqueatlas:" + type;
            }
            cachedAarcSettings.put(structureName, new AutoMarkSetting(true, aarcSetting[2], type, ""));
        }
        return cachedAarcSettings.get(structureName);
    }

    @Nullable
    public static AutoMarkSetting getAARCSetting(String context) {
        String[] context_structureName = context.split("\\$");
        if (context_structureName.length == 2) {
            String structureName = context_structureName[1];
            AutoMarkSetting clientSetting = AARCCompat.getCachedSetting(structureName);
            if (clientSetting != null) {
                return clientSetting;
            }
            return new AutoMarkSetting(true, "DEFAULT", "DEFAULT", "AARCAddon");
        }
        return null;
    }
}

