/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.block.BlockSink;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.TileSink;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockSinkDarkOak
extends BlockSink {
    public static final String name = "sink_darkoak";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "sink_darkoak");

    public BlockSinkDarkOak(Material material) {
        super(material);
        this.func_149663_c(registryName.toString());
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, FLIPPED});
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        ItemStack resultStack = CookingRegistry.getSinkOutput(heldItem);
        if (!resultStack.func_190926_b()) {
            NBTTagCompound tagCompound = heldItem.func_77978_p();
            ItemStack newItem = resultStack.func_77946_l();
            if (tagCompound != null) {
                newItem.func_77982_d(tagCompound);
            }
            if (heldItem.func_190916_E() <= 1) {
                player.func_184611_a(hand, newItem);
            } else if (player.field_71071_by.func_70441_a(newItem)) {
                heldItem.func_190918_g(1);
            }
            this.spawnParticles(world, pos, state);
            world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() + 0.5f);
            return true;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            IFluidHandler fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
            if (fluidHandler == null) {
                this.spawnParticles(world, pos, state);
            } else if (!FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)fluidHandler)) {
                if (heldItem.func_77973_b() == Items.field_151069_bo) {
                    FluidStack simulated = fluidHandler.drain(333, false);
                    if (simulated != null && simulated.amount == 333) {
                        fluidHandler.drain(333, true);
                        if (player.func_191521_c(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b))) {
                            heldItem.func_190918_g(1);
                        }
                    } else {
                        this.spawnParticles(world, pos, state);
                    }
                } else {
                    this.spawnParticles(world, pos, state);
                }
            }
            return !heldItem.func_190926_b() && !(heldItem.func_77973_b() instanceof ItemBlock);
        }
        return true;
    }

    private void spawnParticles(World world, BlockPos pos, IBlockState state) {
        float dripWaterX = 0.0f;
        float dripWaterZ = 0.0f;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                dripWaterZ = 0.25f;
                dripWaterX = -0.05f;
                break;
            }
            case SOUTH: {
                dripWaterX = 0.25f;
                break;
            }
            case WEST: {
                dripWaterX = 0.25f;
                dripWaterZ = 0.25f;
                break;
            }
            case EAST: {
                dripWaterZ = -0.05f;
            }
        }
        float particleX = (float)pos.func_177958_n() + 0.5f;
        float particleY = (float)pos.func_177956_o() + 1.25f;
        float particleZ = (float)pos.func_177952_p() + 0.5f;
        world.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)particleX + (double)dripWaterX, (double)particleY - (double)0.45f, (double)particleZ + (double)dripWaterZ, 0.0, 0.0, 0.0, new int[0]);
        for (int i = 0; i < 5; ++i) {
            world.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)particleX + Math.random() - 0.5, (double)particleY + Math.random() - 0.5, (double)particleZ + Math.random() - 0.5, 0.0, 0.0, 0.0, new int[0]);
        }
        world.func_184133_a(null, pos, SoundEvents.field_187917_gq, SoundCategory.BLOCKS, 0.1f, world.field_73012_v.nextFloat() + 0.5f);
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TileSink();
    }

    @Override
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.cookingforblockheads:multiblock_kitchen", (Object[])new Object[0]));
        for (String s : I18n.func_135052_a((String)("tooltip." + BlockSink.registryName + ".description"), (Object[])new Object[0]).split("\\\\n")) {
            tooltip.add(TextFormatting.GRAY + s);
        }
    }
}

