/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.eventhandlers;

import com.mujmajnkraft.bettersurvival.BetterSurvival;
import com.mujmajnkraft.bettersurvival.capabilities.extendedarrowproperties.ArrowPropertiesProvider;
import com.mujmajnkraft.bettersurvival.capabilities.extendedarrowproperties.IArrowProperties;
import com.mujmajnkraft.bettersurvival.capabilities.nunchakucombo.INunchakuCombo;
import com.mujmajnkraft.bettersurvival.capabilities.nunchakucombo.NunchakuComboProvider;
import com.mujmajnkraft.bettersurvival.capabilities.spearsinentity.ISpearsIn;
import com.mujmajnkraft.bettersurvival.capabilities.spearsinentity.SpearsInProvider;
import com.mujmajnkraft.bettersurvival.config.ForgeConfigHandler;
import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentAgility;
import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentArrowRecovery;
import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentBlast;
import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentDiamonds;
import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentEducation;
import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentHighJump;
import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentMultishot;
import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentPenetration;
import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentRange;
import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentRapidFire;
import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentSmelting;
import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentTunneling;
import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentVersatility;
import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentVitality;
import com.mujmajnkraft.bettersurvival.init.ModBlocks;
import com.mujmajnkraft.bettersurvival.init.ModEnchantments;
import com.mujmajnkraft.bettersurvival.init.ModPotions;
import com.mujmajnkraft.bettersurvival.integration.InFCompat;
import com.mujmajnkraft.bettersurvival.items.ItemBattleAxe;
import com.mujmajnkraft.bettersurvival.items.ItemCustomShield;
import com.mujmajnkraft.bettersurvival.items.ItemCustomWeapon;
import com.mujmajnkraft.bettersurvival.items.ItemDagger;
import com.mujmajnkraft.bettersurvival.items.ItemHammer;
import com.mujmajnkraft.bettersurvival.items.ItemNunchaku;
import com.mujmajnkraft.bettersurvival.items.ItemSpear;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class CommonEventHandler {
    public static final ResourceLocation ARROWPROPERTIES_CAP = new ResourceLocation("mujmajnkraftsbettersurvival", "ArrowProperties");
    public static final ResourceLocation SPEARSIN_CAP = new ResourceLocation("mujmajnkraftsbettersurvival", "spearsin");
    public static final ResourceLocation NUNCHAKU_CAP = new ResourceLocation("mujmajnkraftsbettersurvival", "nunchakucombo");
    boolean isTunneling;

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityArrow && !((Entity)event.getObject()).hasCapability(ArrowPropertiesProvider.ARROWPROPERTIES_CAP, null)) {
            event.addCapability(ARROWPROPERTIES_CAP, (ICapabilityProvider)new ArrowPropertiesProvider());
        }
        if (event.getObject() instanceof EntityLivingBase) {
            if (!((Entity)event.getObject()).hasCapability(SpearsInProvider.SPEARSIN_CAP, null)) {
                event.addCapability(SPEARSIN_CAP, (ICapabilityProvider)new SpearsInProvider());
            }
            if (!((Entity)event.getObject()).hasCapability(NunchakuComboProvider.NUNCHAKUCOMBO_CAP, null)) {
                event.addCapability(NUNCHAKU_CAP, (ICapabilityProvider)new NunchakuComboProvider());
            }
        }
    }

    @SubscribeEvent
    public void onArrowLoose(ArrowLooseEvent event) {
        if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.multishot, (ItemStack)event.getBow()) != 0) {
            EnchantmentMultishot.shootMoreArrows(event.getEntity().func_130014_f_(), event.getEntityPlayer(), event.getBow(), event.getCharge());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (this.isTunneling) {
            return;
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.tunneling, (ItemStack)event.getPlayer().func_184614_ca()) != 0) {
            this.isTunneling = true;
            EnchantmentTunneling.mineManyBlocks(event.getPlayer(), event.getState(), event.getPos());
            this.isTunneling = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBreakingStart(PlayerEvent.BreakSpeed event) {
        if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.versatility, (ItemStack)event.getEntityPlayer().func_184614_ca()) != 0) {
            event.setNewSpeed(event.getOriginalSpeed() * EnchantmentVersatility.getSpeedModifier(event.getEntityPlayer(), event.getState()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEvent(EnderTeleportEvent event) {
        if (event.getEntityLiving().func_70660_b(ModPotions.antiwarp) != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityArrow && !event.getWorld().field_72995_K) {
            EntityArrow arrow = (EntityArrow)event.getEntity();
            if (arrow.field_70250_c instanceof EntityLivingBase) {
                EntityLivingBase shooter = (EntityLivingBase)arrow.field_70250_c;
                if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.arrowrecovery, (ItemStack)shooter.func_184614_ca()) > 0) {
                    EnchantmentArrowRecovery.modifyArrow(shooter, arrow);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.blast, (ItemStack)shooter.func_184614_ca()) > 0) {
                    EnchantmentBlast.modifyArrow(arrow, shooter);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.range, (ItemStack)shooter.func_184614_ca()) > 0) {
                    EnchantmentRange.modifyArrow(arrow);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onAttack(LivingAttackEvent event) {
        Entity source = event.getSource().func_76364_f();
        EntityLivingBase target = event.getEntityLiving();
        if (source instanceof EntityArrow) {
            if (target.func_184607_cu().func_77973_b() instanceof ItemCustomShield && ItemCustomShield.blockArrow(event.getSource(), target)) {
                event.setCanceled(true);
                return;
            }
            IArrowProperties cap = (IArrowProperties)source.getCapability(ArrowPropertiesProvider.ARROWPROPERTIES_CAP, null);
            if (cap != null) {
                cap.hitEntity((EntityArrow)source);
            }
        }
        if (source instanceof EntityLivingBase && !source.field_70170_p.field_72995_K && EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.penetration, (EntityLivingBase)((EntityLivingBase)source)) > 0 && !event.getSource().func_82725_o()) {
            EnchantmentPenetration.dealPiercingDamage((EntityLivingBase)source, target, event.getAmount());
        }
        if (!(BetterSurvival.isRLCombatLoaded && event.getSource().func_76364_f() instanceof EntityPlayer || !(event.getSource().func_76364_f() instanceof EntityLivingBase))) {
            NBTTagCompound compound;
            int h;
            EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76364_f();
            if (attacker.func_184614_ca().func_77973_b() instanceof ItemSpear && attacker instanceof EntityPlayer && !((EntityPlayer)attacker).field_71075_bZ.field_75098_d && ((ItemSpear)attacker.func_184614_ca().func_77973_b()).breakChance() >= attacker.field_70170_p.field_73012_v.nextFloat()) {
                attacker.func_184614_ca().func_190918_g(1);
            }
            if (!attacker.field_70170_p.field_72995_K && attacker.func_184614_ca().func_77942_o() && (h = (compound = attacker.func_184614_ca().func_77978_p()).func_74762_e("remainingPotionHits")) > 0 && event.getEntityLiving().field_70172_ad < 10) {
                for (PotionEffect effect : PotionUtils.func_185189_a((ItemStack)attacker.func_184614_ca())) {
                    if (effect.func_188419_a().func_76403_b()) {
                        event.getEntityLiving().field_70172_ad = 0;
                        effect.func_188419_a().func_180793_a(null, event.getSource().func_76364_f(), event.getEntityLiving(), effect.func_76458_c(), 0.16666666666666666);
                        continue;
                    }
                    event.getEntityLiving().func_70690_d(new PotionEffect(effect.func_188419_a(), Math.max(effect.func_76459_b() / ForgeConfigHandler.potions.potionDivisor, 1), effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
                }
                if (attacker instanceof EntityPlayer && !((EntityPlayer)attacker).field_71075_bZ.field_75098_d) {
                    compound.func_74768_a("remainingPotionHits", h - 1);
                }
                if (h - 1 <= 0) {
                    compound.func_82580_o("Potion");
                    compound.func_82580_o("CustomPotionEffects");
                }
            }
        }
    }

    @SubscribeEvent
    public void onDamage(LivingHurtEvent event) {
        EntityLivingBase target = event.getEntityLiving();
        if (target.func_184607_cu().func_77973_b() instanceof ItemCustomShield) {
            event.setAmount(((ItemCustomShield)target.func_184607_cu().func_77973_b()).getDamageBlocked(target, event.getSource(), event.getAmount()));
        }
        Entity entitysource = event.getSource().func_76364_f();
        if (!BetterSurvival.isRLCombatLoaded && entitysource instanceof EntityPlayer && !entitysource.field_70170_p.field_72995_K) {
            EntityPlayer player = (EntityPlayer)entitysource;
            if (player.func_184614_ca().func_77973_b() instanceof ItemDagger) {
                event.setAmount(event.getAmount() * ((ItemDagger)player.func_184614_ca().func_77973_b()).getBackstabMultiplier((EntityLivingBase)player, (Entity)target, false));
            } else if (player.func_184614_ca().func_77973_b() instanceof ItemNunchaku) {
                INunchakuCombo combo = (INunchakuCombo)player.getCapability(NunchakuComboProvider.NUNCHAKUCOMBO_CAP, null);
                if (combo != null) {
                    event.setAmount(event.getAmount() * (combo.getComboPower() + 1.0f));
                }
            } else if (player.func_184614_ca().func_77973_b() instanceof ItemHammer) {
                if ((double)player.func_184825_o(0.5f) > 0.9) {
                    int l = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.bash, (ItemStack)player.func_184614_ca());
                    if (player.field_70170_p.field_73012_v.nextFloat() < ForgeConfigHandler.weapons.stunBaseChance + (float)l * ForgeConfigHandler.weapons.bashModifier && !target.func_190530_aW()) {
                        PotionEffect potioneffectIn = new PotionEffect(ModPotions.stun, ((ItemHammer)player.func_184614_ca().func_77973_b()).stunduration);
                        target.func_70690_d(potioneffectIn);
                    }
                }
            } else if (player.func_184614_ca().func_77973_b() instanceof ItemBattleAxe && (double)player.func_184825_o(0.5f) > 0.9) {
                int l = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.disarm, (ItemStack)player.func_184614_ca());
                if (player.field_70170_p.field_73012_v.nextFloat() < ForgeConfigHandler.weapons.disarmBaseChance + (float)l * ForgeConfigHandler.weapons.disarmModifier && !target.func_190530_aW()) {
                    if (target instanceof EntityPlayer) {
                        EntityItem drop = ((EntityPlayer)target).func_71019_a(((EntityPlayer)target).field_71071_by.func_70298_a(((EntityPlayer)target).field_71071_by.field_70461_c, 1), false);
                        if (drop != null) {
                            drop.func_174867_a(40);
                        }
                    } else if (!target.func_184614_ca().func_190926_b()) {
                        ItemStack item = target.func_184614_ca();
                        NBTTagCompound nbttagcompound = target.func_189511_e(new NBTTagCompound());
                        if (nbttagcompound.func_150297_b("HandDropChances", 9)) {
                            NBTTagList nbttaglist = nbttagcompound.func_150295_c("HandDropChances", 5);
                            float chance = nbttaglist.func_150308_e(0);
                            target.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                            int rnd = target.field_70170_p.field_73012_v.nextInt(100);
                            if (chance * 100.0f + (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)player.func_184614_ca()) > (float)(rnd + 1)) {
                                target.func_70099_a(item, 1.0f);
                            }
                        }
                    }
                }
            }
            if (player.func_184614_ca().func_77973_b() instanceof ItemCustomWeapon && BetterSurvival.isIafLoaded) {
                event.setAmount(event.getAmount() + InFCompat.getMaterialModifier(player.func_184614_ca(), target, player));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDeath(LivingDeathEvent event) {
        ArrayList<ItemStack> spears;
        ISpearsIn spearsIn = (ISpearsIn)event.getEntity().getCapability(SpearsInProvider.SPEARSIN_CAP, null);
        if (spearsIn != null && !(spears = spearsIn.getSpearsIn()).isEmpty()) {
            for (ItemStack spear : spears) {
                event.getEntity().func_70099_a(spear, 0.0f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onExpReward(LivingExperienceDropEvent event) {
        EntityPlayer player = event.getAttackingPlayer();
        if (player != null && EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.education, (EntityLivingBase)player) > 0) {
            event.setDroppedExperience((int)((float)event.getDroppedExperience() * EnchantmentEducation.getExpMultiplyer(player, event.getEntityLiving())));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onJumpHigh(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        int j = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.highjump, (EntityLivingBase)entity);
        if (j > 0) {
            EnchantmentHighJump.boostJump(entity, j);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onJumpLowest(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        if (entity.func_70660_b(ModPotions.stun) != null && entity.field_70181_x > 0.0) {
            entity.field_70181_x = 0.0;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onItemUsing(LivingEntityUseItemEvent.Tick event) {
        EntityLivingBase entity = event.getEntityLiving();
        Item item = event.getItem().func_77973_b();
        if (item instanceof ItemBow && EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.rapidfire, (ItemStack)entity.func_184614_ca()) > 0) {
            event.setDuration(event.getDuration() - EnchantmentRapidFire.getChargeTimeReduction(entity, event.getDuration()));
        }
    }

    @SubscribeEvent
    public void onEvent(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() != null && !event.getDrops().isEmpty()) {
            EntityPlayer player = event.getHarvester();
            if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.smelting, (ItemStack)player.func_184614_ca()) > 0) {
                EnchantmentSmelting.smeltDrops(event.getDrops(), event.getFortuneLevel(), player);
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.diamonds, (ItemStack)player.func_184614_ca()) > 0) {
                EnchantmentDiamonds.conjureDiamonds(event.getDrops(), event.getState().func_177230_c(), player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        int speedLvl;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer) {
            int vitLvl;
            INunchakuCombo combo;
            if (entity.func_184614_ca().func_77973_b() instanceof ItemNunchaku && (combo = (INunchakuCombo)entity.getCapability(NunchakuComboProvider.NUNCHAKUCOMBO_CAP, null)) != null && (combo.getComboTime() > 0 || combo.getComboPower() > 0.0f)) {
                combo.countDown();
            }
            if ((vitLvl = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.vitality, (EntityLivingBase)entity)) > 0) {
                EnchantmentVitality.healPlayer((EntityPlayer)entity, vitLvl);
            }
            if (entity.func_184607_cu().func_77973_b() instanceof ItemCustomShield) {
                ((ItemCustomShield)entity.func_184607_cu().func_77973_b()).applyModifiers(entity);
            } else if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(new AttributeModifier(ItemCustomShield.knockbackModifierUUID, "shield_knockback_adjustment", 0.0, 0)) || entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(new AttributeModifier(ItemCustomShield.weightModifierUUID, "shield_speed_adjustment", 0.0, 0))) {
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(ItemCustomShield.knockbackModifierUUID);
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(ItemCustomShield.weightModifierUUID);
            }
        }
        if ((speedLvl = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.agility, (EntityLivingBase)entity)) > 0) {
            EnchantmentAgility.applySpeedModifier(entity, speedLvl);
        } else if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(new AttributeModifier(EnchantmentAgility.speedModifier, "agility", 0.0, 0))) {
            entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(EnchantmentAgility.speedModifier);
        }
        if (entity.func_70660_b(ModPotions.stun) != null) {
            entity.field_70159_w = 0.0;
            if (entity.field_70181_x > 0.0) {
                entity.field_70181_x = 0.0;
            }
            entity.field_70179_y = 0.0;
            if (entity instanceof EntityCreeper) {
                ((EntityCreeper)entity).func_70829_a(-1);
            }
        }
        if (entity instanceof EntityLiving) {
            double strength;
            EntityEntry entry;
            if (entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_180374_a(new AttributeModifier(UUID.fromString("a6107045-134f-4c14-a645-75c3ae5c7a27"), "blind", 0.0, 1))) {
                entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_188479_b(UUID.fromString("a6107045-134f-4c14-a645-75c3ae5c7a27"));
            }
            if (entity.func_70660_b(MobEffects.field_76440_q) != null && (entry = EntityRegistry.getEntry(entity.getClass())) != null && !Arrays.asList(ForgeConfigHandler.potions.blindnessBlacklist).contains(entry.getRegistryName().toString()) && (strength = -0.01 * ForgeConfigHandler.potions.blindnessStrength) < 0.0) {
                AttributeModifier modifier = new AttributeModifier(UUID.fromString("a6107045-134f-4c14-a645-75c3ae5c7a27"), "blind", strength, 1);
                entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(modifier);
            }
        }
    }

    @SubscribeEvent
    public void onEvent(PlayerInteractEvent.RightClickBlock event) {
        if (BetterSurvival.isInspirationsLoaded) {
            return;
        }
        if (event.getItemStack() != ItemStack.field_190927_a) {
            Item item = event.getItemStack().func_77973_b();
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            if (!(state.func_177230_c() != Blocks.field_150383_bp || event.getWorld().field_72995_K || (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) != 0 || item != Items.field_151117_aB && (item != Items.field_151068_bn || PotionUtils.func_185189_a((ItemStack)event.getItemStack()).isEmpty() && PotionUtils.func_185191_c((ItemStack)event.getItemStack()) == PotionTypes.field_185230_b))) {
                event.getWorld().func_175656_a(event.getPos(), ModBlocks.customcauldron.func_176223_P());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLootLoad(LootTableLoadEvent event) {
        if (event.getName().toString().equals("minecraft:chests/end_city_treasure")) {
            RandomChance chance = new RandomChance(1.0f);
            LootEntryTable entry = new LootEntryTable(new ResourceLocation("mujmajnkraftsbettersurvival:chests/end_city_treasure_inject"), 1, 0, null, "Custom Weapons");
            LootPool pool = new LootPool(new LootEntry[]{entry}, new LootCondition[]{chance}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), "Custom Weapons");
            event.getTable().addPool(pool);
        } else if (event.getName().toString().equals("minecraft:chests/stronghold_corridor")) {
            RandomChance chance = new RandomChance(1.0f);
            LootEntryTable entry = new LootEntryTable(new ResourceLocation("mujmajnkraftsbettersurvival:chests/stronghold_corridor_inject"), 1, 0, null, "Custom Weapons");
            LootPool pool = new LootPool(new LootEntry[]{entry}, new LootCondition[]{chance}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), "Custom Weapons");
            event.getTable().addPool(pool);
        } else if (event.getName().toString().equals("minecraft:chests/village_blacksmith")) {
            RandomChance chance = new RandomChance(1.0f);
            LootEntryTable entry = new LootEntryTable(new ResourceLocation("mujmajnkraftsbettersurvival:chests/village_blacksmith_inject"), 1, 0, null, "Custom Weapons");
            LootPool pool = new LootPool(new LootEntry[]{entry}, new LootCondition[]{chance}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), "Custom Weapons");
            event.getTable().addPool(pool);
        } else if (event.getName().toString().equals("minecraft:chests/nether_bridge")) {
            RandomChance chance = new RandomChance(1.0f);
            LootEntryTable entry = new LootEntryTable(new ResourceLocation("mujmajnkraftsbettersurvival:chests/nether_bridge_inject"), 1, 0, null, "Custom Weapons");
            LootPool pool = new LootPool(new LootEntry[]{entry}, new LootCondition[]{chance}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), "Custom Weapons");
            event.getTable().addPool(pool);
        } else if (event.getName().toString().equals("minecraft:chests/spawn_bonus_chest")) {
            RandomChance chance = new RandomChance(1.0f);
            LootEntryTable entry = new LootEntryTable(new ResourceLocation("mujmajnkraftsbettersurvival:chests/spawn_bonus_inject"), 1, 0, null, "Custom Weapons");
            LootPool pool = new LootPool(new LootEntry[]{entry}, new LootCondition[]{chance}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), "Custom Weapons");
            event.getTable().addPool(pool);
        }
    }
}

