/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.capabilities.extendedarrowproperties;

import com.mujmajnkraft.bettersurvival.capabilities.extendedarrowproperties.IArrowProperties;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class ArrowProperties
implements IArrowProperties {
    private float ExplosionPower;
    private boolean CanDestroyBLocks;
    private boolean NoDrag;
    private boolean CanRecover;

    @Override
    public void setExplosion(float power, boolean canDestroyBlocks) {
        this.ExplosionPower = power;
        this.CanDestroyBLocks = canDestroyBlocks;
    }

    @Override
    public void setNoDrag(boolean noDrag) {
        this.NoDrag = noDrag;
    }

    @Override
    public float getExplosionPower() {
        return this.ExplosionPower;
    }

    @Override
    public boolean getCanDestroyBlocks() {
        return this.CanDestroyBLocks;
    }

    @Override
    public boolean getNoDrag() {
        return this.NoDrag;
    }

    @Override
    public void setCanRecover(boolean canRecover) {
        this.CanRecover = canRecover;
    }

    @Override
    public boolean getCanRecover() {
        return this.CanRecover;
    }

    public static void Register() {
        CapabilityManager.INSTANCE.register(IArrowProperties.class, (Capability.IStorage)new Storage(), (Callable)new Factory());
    }

    @Override
    public void hitEntity(EntityArrow arrow) {
        if (this.getCanRecover() && arrow.field_70250_c != null && arrow.field_70251_a == EntityArrow.PickupStatus.ALLOWED && !arrow.field_70250_c.field_70128_L && arrow.field_70250_c instanceof EntityPlayer) {
            EntityPlayer shooter = (EntityPlayer)arrow.field_70250_c;
            ItemStack stack = new ItemStack(Items.field_151032_g);
            boolean flag = shooter.field_71071_by.func_70441_a(stack);
            if (flag) {
                shooter.field_71069_bz.func_75142_b();
            } else {
                EntityItem entityitem = shooter.func_71019_a(stack, false);
                entityitem.func_174868_q();
                entityitem.func_145797_a(shooter.func_70005_c_());
            }
            arrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
        }
        if (this.getExplosionPower() > 0.0f) {
            arrow.field_70170_p.func_72885_a(arrow.field_70250_c, arrow.field_70165_t, arrow.field_70163_u, arrow.field_70161_v, this.getExplosionPower(), arrow.func_70027_ad(), false);
            arrow.func_70106_y();
            if (arrow instanceof EntityTippedArrow) {
                NBTTagCompound compound = arrow.func_189511_e(new NBTTagCompound());
                ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
                if (compound.func_150297_b("Potion", 8)) {
                    PotionType potion = PotionUtils.func_185187_c((NBTTagCompound)compound);
                    for (PotionEffect potioneffect : potion.func_185170_a()) {
                        effects.add(new PotionEffect(potioneffect.func_188419_a(), potioneffect.func_76459_b() / 8, potioneffect.func_76458_c(), potioneffect.func_82720_e(), potioneffect.func_188418_e()));
                    }
                }
                for (PotionEffect potioneffect : PotionUtils.func_185192_b((NBTTagCompound)compound)) {
                    effects.add(potioneffect);
                }
                if (!effects.isEmpty()) {
                    EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(arrow.field_70170_p, arrow.field_70165_t, arrow.field_70163_u, arrow.field_70161_v);
                    entityareaeffectcloud.func_184483_a(2.5f * this.getExplosionPower());
                    entityareaeffectcloud.func_184495_b(-0.5f);
                    entityareaeffectcloud.func_184485_d(10);
                    entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() / 2);
                    entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
                    for (PotionEffect potioneffect : effects) {
                        entityareaeffectcloud.func_184496_a(new PotionEffect(potioneffect));
                    }
                    arrow.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
                }
            }
        }
    }

    private static class Factory
    implements Callable<IArrowProperties> {
        private Factory() {
        }

        @Override
        public IArrowProperties call() throws Exception {
            return new ArrowProperties();
        }
    }

    private static class Storage
    implements Capability.IStorage<IArrowProperties> {
        private Storage() {
        }

        public NBTBase writeNBT(Capability<IArrowProperties> capability, IArrowProperties instance, EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74776_a("ExplosionPower", instance.getExplosionPower());
            compound.func_74757_a("CanDestroyBlocks", instance.getCanDestroyBlocks());
            compound.func_74757_a("NoDrag", instance.getNoDrag());
            compound.func_74757_a("CanRecover", instance.getCanRecover());
            return compound;
        }

        public void readNBT(Capability<IArrowProperties> capability, IArrowProperties instance, EnumFacing side, NBTBase nbt) {
            instance.setExplosion(((NBTTagCompound)nbt).func_74760_g("ExplosionPower"), ((NBTTagCompound)nbt).func_74767_n("CanDestroyBlocks"));
            instance.setNoDrag(((NBTTagCompound)nbt).func_74767_n("NoDrag"));
            instance.setCanRecover(((NBTTagCompound)nbt).func_74767_n("CanRecover"));
        }
    }
}

