/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ModListGetter {
    public static List<String> getModList() {
        ArrayList<String> modList = new ArrayList<String>();
        File modsFolder = new File("mods");
        if (modsFolder.exists() && modsFolder.isDirectory()) {
            File[] modFiles = modsFolder.listFiles();
            if (modFiles != null) {
                for (File modFile : modFiles) {
                    String modId;
                    if (!modFile.isFile() || !modFile.getName().endsWith(".jar") || modFile.getName().contains("Localizator") || (modId = ModListGetter.getModIdFromJar(modFile)) == null) continue;
                    modList.add(modId);
                }
            } else {
                System.out.println("No mods found in the mods folder.");
            }
        } else {
            System.out.println("Mods folder does not exist or is not a directory.");
        }
        return modList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getModIdFromJar(File modFile) {
        try (JarFile jarFile = new JarFile(modFile);){
            JarEntry entry = jarFile.getJarEntry("mcmod.info");
            if (entry == null) return null;
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse(ModListGetter.readInputStream(jarFile.getInputStream(entry)));
            if (!element.isJsonArray()) return null;
            JsonArray modsArray = element.getAsJsonArray();
            if (modsArray.size() <= 0) return null;
            JsonObject modInfo = modsArray.get(0).getAsJsonObject();
            if (!modInfo.has("modid")) return null;
            String string = modInfo.get("modid").getAsString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String readInputStream(InputStream inputStream) throws IOException {
        int length;
        StringBuilder resultStringBuilder = new StringBuilder();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            resultStringBuilder.append(new String(buffer, 0, length));
        }
        return resultStringBuilder.toString();
    }
}

