/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import kameib.localizator.handlers.ForgeConfigHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.TextFormatting;

public class LocLoreUtil {
    public static final List<String> validConfigColors = Arrays.asList("white", "black", "dark_blue", "dark_green", "dark_aqua", "dark_red", "dark_purple", "gold", "gray", "dark_gray", "blue", "green", "aqua", "red", "light_purple", "yellow");
    public static final List<String> validConfigFormats = Arrays.asList("none", "obfuscated", "bold", "strikethrough", "underline", "italic");

    public static ItemStack appendLocLore(ItemStack stack, List<String> locLoreList, @Nullable List<String> locLoreArgList) {
        NBTTagCompound tag1;
        if (locLoreArgList != null) {
            for (int i = locLoreArgList.size(); i < locLoreList.size(); ++i) {
                locLoreArgList.add("");
            }
        }
        NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        boolean needAppend1 = false;
        boolean needAppend2 = false;
        if (tag.func_150297_b("display", 10)) {
            tag1 = tag.func_74775_l("display");
            if (tag.func_150297_b("LocLore", 9)) {
                needAppend1 = true;
            }
            if (tag.func_150297_b("LocLoreArg", 9) && locLoreArgList != null) {
                needAppend2 = true;
            }
        } else {
            tag.func_74782_a("display", (NBTBase)new NBTTagCompound());
            tag1 = tag.func_74775_l("display");
        }
        if (!needAppend1) {
            tag1.func_74782_a("LocLore", (NBTBase)new NBTTagList());
        }
        for (String s : locLoreList) {
            tag1.func_150295_c("LocLore", 8).func_74742_a((NBTBase)new NBTTagString(s));
        }
        if (!needAppend2 && locLoreArgList != null) {
            tag1.func_74782_a("LocLoreArg", (NBTBase)new NBTTagList());
        }
        if (tag1.func_150297_b("LocLoreArg", 9) && locLoreArgList != null) {
            for (String s : locLoreArgList) {
                tag1.func_150295_c("LocLoreArg", 8).func_74742_a((NBTBase)new NBTTagString(s));
            }
        }
        tag.func_74782_a("display", (NBTBase)tag1);
        ItemStack output = stack.func_77946_l();
        output.func_77982_d(tag);
        return output;
    }

    public static List<String> getLocLore(ItemStack stack) {
        ArrayList<String> locLoreList = new ArrayList<String>();
        if (!stack.func_77942_o()) {
            return locLoreList;
        }
        NBTTagCompound mainTag = stack.func_77978_p();
        if (!mainTag.func_150297_b("display", 10)) {
            return locLoreList;
        }
        NBTTagCompound displayTag = mainTag.func_74775_l("display");
        if (!displayTag.func_150297_b("LocLore", 9)) {
            return locLoreList;
        }
        NBTTagList locLoreTagList = displayTag.func_150295_c("LocLore", 8);
        for (int i = 0; i < locLoreTagList.func_74745_c(); ++i) {
            locLoreList.add(locLoreTagList.func_150307_f(i));
        }
        return locLoreList;
    }

    public static List<String> getLocLoreArg(ItemStack stack) {
        ArrayList<String> locLoreArgList = new ArrayList<String>();
        if (!stack.func_77942_o()) {
            return locLoreArgList;
        }
        NBTTagCompound mainTag = stack.func_77978_p();
        if (!mainTag.func_150297_b("display", 10)) {
            return locLoreArgList;
        }
        NBTTagCompound displayTag = mainTag.func_74775_l("display");
        if (!displayTag.func_150297_b("LocLoreArg", 9)) {
            return locLoreArgList;
        }
        NBTTagList locLoreArgTagList = displayTag.func_150295_c("LocLoreArg", 8);
        for (int i = 0; i < locLoreArgTagList.func_74745_c(); ++i) {
            locLoreArgList.add(locLoreArgTagList.func_150307_f(i));
        }
        return locLoreArgList;
    }

    public static TextFormatting getCustomColor() {
        switch (ForgeConfigHandler.clientConfig.minecraftDefaultLocLoreColor) {
            case "white": {
                return TextFormatting.WHITE;
            }
            case "black": {
                return TextFormatting.BLACK;
            }
            case "dark_blue": {
                return TextFormatting.DARK_BLUE;
            }
            case "dark_green": {
                return TextFormatting.DARK_GREEN;
            }
            case "dark_aqua": {
                return TextFormatting.DARK_AQUA;
            }
            case "dark_red": {
                return TextFormatting.DARK_RED;
            }
            case "dark_purple": {
                return TextFormatting.DARK_PURPLE;
            }
            case "gold": {
                return TextFormatting.GOLD;
            }
            case "gray": {
                return TextFormatting.GRAY;
            }
            case "dark_gray": {
                return TextFormatting.DARK_GRAY;
            }
            case "blue": {
                return TextFormatting.BLUE;
            }
            case "green": {
                return TextFormatting.GREEN;
            }
            case "aqua": {
                return TextFormatting.AQUA;
            }
            case "red": {
                return TextFormatting.RED;
            }
            case "light_purple": {
                return TextFormatting.LIGHT_PURPLE;
            }
            case "yellow": {
                return TextFormatting.YELLOW;
            }
        }
        return TextFormatting.WHITE;
    }

    public static String getCustomFormat() {
        switch (ForgeConfigHandler.clientConfig.minecraftDefaultLocLoreFormat) {
            case "none": {
                return "";
            }
            case "obfuscated": {
                return TextFormatting.OBFUSCATED.toString();
            }
            case "bold": {
                return TextFormatting.BOLD.toString();
            }
            case "strikethrough": {
                return TextFormatting.STRIKETHROUGH.toString();
            }
            case "underline": {
                return TextFormatting.UNDERLINE.toString();
            }
            case "italic": {
                return TextFormatting.ITALIC.toString();
            }
        }
        return "";
    }
}

