/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.mixin.roguelike;

import com.github.fnar.minecraft.entity.Slot;
import com.github.fnar.minecraft.item.ArmourType;
import com.github.fnar.minecraft.item.Enchantment;
import com.github.fnar.minecraft.item.RldItemStack;
import greymerk.roguelike.monster.Mob;
import greymerk.roguelike.monster.profiles.ProfileJohnny;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import java.util.Random;
import kameib.localizator.handlers.ForgeConfigHandler;
import kameib.localizator.util.RLD_MobUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ProfileJohnny.class})
public abstract class ProfileJohnnyMixin {
    @Unique
    private boolean localizator$ourJohnny;
    @Unique
    private Random localizator$myRandom;

    @Inject(method={"apply(Lgreymerk/roguelike/monster/Mob;IILjava/util/Random;)Lgreymerk/roguelike/monster/Mob;"}, at={@At(value="HEAD")}, remap=false)
    private void RLD_ProfileJohnny_apply_getRandom(Mob mob, int level, int difficulty, Random random, CallbackInfoReturnable<Mob> cir) {
        this.localizator$myRandom = random;
    }

    @ModifyArg(method={"apply(Lgreymerk/roguelike/monster/Mob;IILjava/util/Random;)Lgreymerk/roguelike/monster/Mob;"}, at=@At(value="INVOKE", target="Lgreymerk/roguelike/monster/Mob;equipMainhand(Lcom/github/fnar/minecraft/item/RldItemStack;)V", remap=false), remap=false)
    private RldItemStack RLD_ProfileJohnny_apply_equipMainHand_equipNovelty(RldItemStack itemStack) {
        this.localizator$ourJohnny = true;
        if (ForgeConfigHandler.miscelaneousMixinsConfig.rldSpawnJohnny) {
            if (this.localizator$myRandom.nextDouble() <= 0.005 / Math.max(0.005, ForgeConfigHandler.serverConfig.rldJohnnySpawnChance)) {
                return ItemNovelty.greymerksHatchet();
            }
            this.localizator$ourJohnny = false;
            return itemStack;
        }
        return ItemNovelty.greymerksHatchet();
    }

    @Inject(method={"apply(Lgreymerk/roguelike/monster/Mob;IILjava/util/Random;)Lgreymerk/roguelike/monster/Mob;"}, at={@At(value="TAIL")}, remap=false)
    private void RLD_ProfileJohnny_apply_equipBetterArmor(Mob mob, int level, int difficulty, Random random, CallbackInfoReturnable<Mob> cir) {
        if (!this.localizator$ourJohnny) {
            return;
        }
        int protLevel = 4;
        int unbrLevel = 2;
        RLD_MobUtil.supponpon(mob);
        RldItemStack helmet = ArmourType.HELMET.asItem().withQuality(Quality.DIAMOND).withEnchantment(Enchantment.Effect.PROTECTION.atLevel(Math.max(protLevel - 1, 1))).withEnchantment(Enchantment.Effect.VANISHING_CURSE).asStack();
        mob.equip(Slot.HEAD, helmet);
        RldItemStack chestplate = ArmourType.CHESTPLATE.asItem().withQuality(Quality.IRON).withEnchantment(Enchantment.Effect.PROTECTION.atLevel(protLevel)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(unbrLevel)).withEnchantment(Enchantment.Effect.VANISHING_CURSE).asStack();
        mob.equip(Slot.CHEST, chestplate);
        RldItemStack leggings = ArmourType.LEGGINGS.asItem().withQuality(Quality.IRON).withEnchantment(Enchantment.Effect.PROTECTION.atLevel(protLevel)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(unbrLevel)).withEnchantment(Enchantment.Effect.VANISHING_CURSE).asStack();
        mob.equip(Slot.LEGS, leggings);
        RldItemStack boots = ArmourType.BOOTS.asItem().withQuality(Quality.IRON).withEnchantment(Enchantment.Effect.PROTECTION.atLevel(protLevel)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(unbrLevel)).withEnchantment(Enchantment.Effect.VANISHING_CURSE).asStack();
        mob.equip(Slot.FEET, boots);
    }
}

