/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.mixin.roguelike;

import com.github.fnar.minecraft.Difficulty;
import com.github.fnar.minecraft.entity.Slot;
import com.github.fnar.minecraft.item.ArmourType;
import com.github.fnar.minecraft.item.RldItemStack;
import greymerk.roguelike.monster.Mob;
import greymerk.roguelike.monster.profiles.ProfileHusk;
import greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import java.util.Random;
import kameib.localizator.handlers.ForgeConfigHandler;
import kameib.localizator.util.RLD_ExtraColor;
import kameib.localizator.util.RLD_MobUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ProfileHusk.class})
public abstract class ProfileHuskMixin {
    @Unique
    private boolean localizator$specialChild;

    @Inject(method={"apply(Lgreymerk/roguelike/monster/Mob;IILjava/util/Random;)Lgreymerk/roguelike/monster/Mob;"}, at={@At(value="INVOKE", target="Lgreymerk/roguelike/monster/Mob;setMobType(Lcom/github/fnar/minecraft/block/spawner/MobType;)V", shift=At.Shift.AFTER, remap=false)}, remap=false)
    private void RLD_ProfileHusk_apply_setMobType_rollBaby(Mob mob, int level, int difficulty, Random random, CallbackInfoReturnable<Mob> cir) {
        this.localizator$specialChild = false;
        double d = random.nextDouble();
        double d2 = ForgeConfigHandler.serverConfig.rldCustomSpawnerHusk ? 0.0025 : 0.05;
        if (d < d2 && !mob.isChild()) {
            mob.setChild(true);
            this.localizator$specialChild = true;
        }
    }

    @Inject(method={"apply(Lgreymerk/roguelike/monster/Mob;IILjava/util/Random;)Lgreymerk/roguelike/monster/Mob;"}, at={@At(value="TAIL")}, remap=false)
    private void RLD_ProfileHusk_apply_equipNovelty(Mob mob, int level, int difficulty, Random random, CallbackInfoReturnable<Mob> cir) {
        if (mob.isChild()) {
            if (this.localizator$specialChild) {
                this.localizator$profileNebris(mob, level, difficulty, random);
            }
        } else {
            double d = random.nextDouble();
            double d2 = ForgeConfigHandler.serverConfig.rldCustomSpawnerHusk ? 0.0025 : 0.05;
            if (d < d2) {
                this.localizator$profileBaj(mob, level, difficulty, random);
            }
        }
    }

    @Unique
    private void localizator$profileNebris(Mob mob, int level, int difficulty, Random random) {
        RLD_MobUtil.supponpon(mob).equipSword(random, level, Difficulty.fromInt((int)difficulty));
        RldItemStack boots = ArmourType.BOOTS.asItem().leather().withColor(RLD_ExtraColor.ALTO).asStack();
        mob.equip(Slot.FEET, boots);
        RldItemStack leggings = ArmourType.LEGGINGS.asItem().leather().withColor(RLD_ExtraColor.COD_GRAY_2).asStack();
        mob.equip(Slot.LEGS, leggings);
        RldItemStack chestplate = ArmourType.CHESTPLATE.asItem().leather().withColor(RLD_ExtraColor.MINE_SHAFT).asStack();
        mob.equip(Slot.CHEST, chestplate);
        mob.equip(Slot.HEAD, ItemNovelty.nebrisCrown());
    }

    @Unique
    private void localizator$profileBaj(Mob mob, int level, int difficulty, Random random) {
        RLD_MobUtil.supponpon(mob).equipMainhand(ItemNovelty.bajsLastResort());
        RldItemStack boots = ArmourType.BOOTS.asItem().leather().withColor(RLD_ExtraColor.BLACK).asStack();
        mob.equip(Slot.FEET, boots);
        RldItemStack leggings = ArmourType.LEGGINGS.asItem().leather().withColor(RLD_ExtraColor.VERDUN_GREEN).asStack();
        mob.equip(Slot.LEGS, leggings);
        RldItemStack chestplate = ArmourType.CHESTPLATE.asItem().leather().withColor(RLD_ExtraColor.VERDUN_GREEN).asStack();
        mob.equip(Slot.CHEST, chestplate);
        RldItemStack helmet = ArmourType.HELMET.asItem().leather().withColor(RLD_ExtraColor.TAWNY_PORT).asStack();
        mob.equip(Slot.HEAD, helmet);
    }
}

