/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.mixin.roguelike;

import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.item.Material;
import com.github.fnar.minecraft.item.Tool;
import com.github.fnar.minecraft.item.ToolType;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsSmithy;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.Optional;
import java.util.Random;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DungeonsSmithy.class})
public abstract class DungeonsSmithyMixin {
    @Unique
    private boolean localizator$addEtho = false;

    @Inject(method={"smelterSide(Lgreymerk/roguelike/worldgen/Direction;Lgreymerk/roguelike/worldgen/Coord;)V"}, at={@At(value="HEAD")}, remap=false)
    private void RLD_DungeonsSmithy_smelterSide_initFlag(Direction entranceDirection, Coord origin, CallbackInfo ci) {
        this.localizator$addEtho = false;
    }

    @Redirect(method={"smelter(Lgreymerk/roguelike/worldgen/Direction;Lgreymerk/roguelike/worldgen/Coord;)V"}, at=@At(value="INVOKE", target="Lgreymerk/roguelike/treasure/TreasureChest;stroke(Lgreymerk/roguelike/worldgen/WorldEditor;Lgreymerk/roguelike/worldgen/Coord;)Ljava/util/Optional;", ordinal=1, remap=false), remap=false)
    private Optional<TreasureChest> RLD_DungeonsSmithy_smelter_stroke_fuelChest(TreasureChest instance, WorldEditor worldEditor, Coord coord) {
        Optional myChest = instance.stroke(worldEditor, coord);
        if (this.localizator$addEtho) {
            myChest.ifPresent(etho -> {
                Random random = worldEditor.getRandom();
                short slot = 0;
                etho.setSlot((int)slot, BlockType.COAL_BLOCK.asItem().asStack().withCount(1));
                slot = (short)(slot + 1);
                short dummies = (short)random.nextInt(10);
                if (dummies > 0) {
                    etho.setSlot((int)slot, Material.Type.COAL.asItem().asStack().withCount((int)dummies));
                    slot = (short)(slot + 1);
                }
                dummies = (short)(1 + random.nextInt(7));
                while (slot < dummies) {
                    etho.setSlot((int)slot, new Tool(ToolType.PICKAXE).wooden().asStack());
                    slot = (short)(slot + 1);
                }
                etho.setSlot((int)slot, ItemNovelty.ethosYourMomJoke());
            });
        }
        return myChest;
    }

    @Redirect(method={"smelter(Lgreymerk/roguelike/worldgen/Direction;Lgreymerk/roguelike/worldgen/Coord;)V"}, at=@At(value="INVOKE", target="Lgreymerk/roguelike/treasure/TreasureChest;stroke(Lgreymerk/roguelike/worldgen/WorldEditor;Lgreymerk/roguelike/worldgen/Coord;)Ljava/util/Optional;", ordinal=2, remap=false), remap=false)
    private Optional<TreasureChest> RLD_DungeonsSmithy_smelter_stroke_smeltChest(TreasureChest instance, WorldEditor worldEditor, Coord coord) {
        Optional myChest = instance.stroke(worldEditor, coord);
        if (!this.localizator$addEtho) {
            this.localizator$addEtho = true;
        } else {
            myChest.ifPresent(logs -> {
                logs.setSlot(0, BlockType.OAK_LOG.asItem().asStack().withCount(64));
                logs.setSlot(1, BlockType.OAK_LOG.asItem().asStack().withCount(64));
                logs.setSlot(2, BlockType.OAK_LOG.asItem().asStack().withCount(32));
            });
            this.localizator$addEtho = false;
        }
        return myChest;
    }
}

