/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.mixin.morpheus;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.quetzi.morpheus.Morpheus;
import net.quetzi.morpheus.helpers.DateHandler;
import net.quetzi.morpheus.helpers.SleepChecker;
import net.quetzi.morpheus.world.WorldSleepState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={SleepChecker.class})
public abstract class SleepCheckerMixin {
    @Unique
    private EntityPlayer localizator$myPlayer;

    @ModifyVariable(method={"updatePlayerStates(Lnet/minecraft/world/World;)V"}, name={"player"}, at=@At(value="STORE", ordinal=0), remap=false)
    private EntityPlayer Morpheus_SleepChecker_updatePlayerStates_catchPlayer(EntityPlayer value) {
        this.localizator$myPlayer = value;
        return value;
    }

    @Redirect(method={"updatePlayerStates(Lnet/minecraft/world/World;)V"}, at=@At(value="INVOKE", target="Lnet/quetzi/morpheus/helpers/SleepChecker;alertPlayers(Lnet/minecraft/util/text/TextComponentString;Lnet/minecraft/world/World;)V", ordinal=0, remap=false), remap=false)
    private void Morpheus_SleepChecker_updatePlayerStates_alertPlayers_redirect0(SleepChecker instance, TextComponentString iTextComponents, World world) {
        this.localizator$locAlertPlayers(this.localizator$createLocAlert(this.localizator$myPlayer.field_71093_bK, this.localizator$myPlayer.getDisplayNameString(), "notif.morpheus.OnSleepText", iTextComponents), world);
    }

    @Redirect(method={"updatePlayerStates(Lnet/minecraft/world/World;)V"}, at=@At(value="INVOKE", target="Lnet/quetzi/morpheus/helpers/SleepChecker;alertPlayers(Lnet/minecraft/util/text/TextComponentString;Lnet/minecraft/world/World;)V", ordinal=1, remap=false), remap=false)
    private void Morpheus_SleepChecker_updatePlayerStates_alertPlayers_redirect1(SleepChecker instance, TextComponentString iTextComponents, World world) {
        this.localizator$locAlertPlayers(this.localizator$createLocAlert(this.localizator$myPlayer.field_71093_bK, this.localizator$myPlayer.getDisplayNameString(), "notif.morpheus.OnWakeText", iTextComponents), world);
    }

    @Redirect(method={"advanceToMorning(Lnet/minecraft/world/World;)V"}, at=@At(value="INVOKE", target="Lnet/quetzi/morpheus/helpers/SleepChecker;alertPlayers(Lnet/minecraft/util/text/TextComponentString;Lnet/minecraft/world/World;)V", remap=false), remap=false)
    private void Morpheus_SleepChecker_advanceToMorning_alertPlayers_redirect(SleepChecker instance, TextComponentString iTextComponents, World world) {
        this.localizator$locAlertPlayers((ITextComponent)new TextComponentTranslation(DateHandler.getMorningText(), new Object[0]), world);
    }

    @Unique
    private ITextComponent localizator$createLocAlert(int dimension, String username, String langKey, TextComponentString logMessage) {
        String toLog = logMessage.func_150261_e();
        Morpheus.mLog.info(toLog);
        return new TextComponentTranslation(langKey, new Object[]{username, ((WorldSleepState)Morpheus.playerSleepStatus.get(dimension)).toString()});
    }

    @Unique
    private void localizator$locAlertPlayers(ITextComponent alert, World world) {
        if (alert != null && Morpheus.isAlertEnabled()) {
            for (EntityPlayer player : world.field_73010_i) {
                player.func_145747_a(alert);
            }
        }
    }

    @Overwrite(remap=false)
    private TextComponentString createAlert(int dimension, String username, String text) {
        return new TextComponentString("[Test] " + username + " " + text + " " + ((WorldSleepState)Morpheus.playerSleepStatus.get(dimension)).toString());
    }
}

