/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.mixin.mca;

import mca.client.gui.GuiInteract;
import mca.entity.EntityVillagerMCA;
import mca.entity.data.ParentData;
import mca.enums.EnumMarriageState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@SideOnly(value=Side.CLIENT)
@Mixin(value={GuiInteract.class})
public abstract class GuiInteractMixin
extends GuiScreen {
    @Mutable
    @Final
    @Shadow(remap=false)
    private final EntityVillagerMCA villager;
    @Mutable
    @Final
    @Shadow(remap=false)
    private final EntityPlayer player;

    @Overwrite(remap=false)
    private void drawTextPopups() {
        EnumMarriageState marriageState = EnumMarriageState.byId((int)((Integer)this.villager.get(EntityVillagerMCA.MARRIAGE_STATE)));
        if (this.hoveringOverHeartsIcon()) {
            int hearts = this.villager.getPlayerHistoryFor(this.player.func_110124_au()).getHearts();
            this.func_146279_a(I18n.func_135052_a((String)"gui.mca.interact.label.hearts", (Object[])new Object[]{hearts}), 35, 55);
        }
        if (this.hoveringOverMarriageIcon()) {
            String spouseName = (String)this.villager.get(EntityVillagerMCA.SPOUSE_NAME);
            String marriageInfo = marriageState == EnumMarriageState.MARRIED ? I18n.func_135052_a((String)"gui.interact.label.married_", (Object[])new Object[]{spouseName}) : (marriageState == EnumMarriageState.ENGAGED ? I18n.func_135052_a((String)"gui.interact.label.engaged_", (Object[])new Object[]{spouseName}) : I18n.func_135052_a((String)"gui.interact.label.notmarried_", (Object[])new Object[0]));
            this.func_146279_a(marriageInfo, 35, 85);
        }
        if (this.canDrawParentsIcon() && this.hoveringOverParentsIcon()) {
            ParentData data = ParentData.fromNBT((NBTTagCompound)((NBTTagCompound)this.villager.get(EntityVillagerMCA.PARENTS)));
            this.func_146279_a(I18n.func_135052_a((String)"gui.interact.label.parents_", (Object[])new Object[]{data.getParent1Name(), data.getParent2Name()}), 35, 115);
        }
        if (this.canDrawGiftIcon() && this.hoveringOverGiftIcon()) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.interact.label.gift_", (Object[])new Object[0]), 35, 145);
        }
    }

    protected GuiInteractMixin(EntityVillagerMCA villager, EntityPlayer player) {
        this.villager = villager;
        this.player = player;
    }

    @Shadow(remap=false)
    private boolean hoveringOverHeartsIcon() {
        return false;
    }

    @Shadow(remap=false)
    private boolean hoveringOverMarriageIcon() {
        return false;
    }

    @Shadow(remap=false)
    private boolean canDrawParentsIcon() {
        return false;
    }

    @Shadow(remap=false)
    private boolean hoveringOverParentsIcon() {
        return false;
    }

    @Shadow(remap=false)
    private boolean canDrawGiftIcon() {
        return false;
    }

    @Shadow(remap=false)
    private boolean hoveringOverGiftIcon() {
        return false;
    }
}

