/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.mixin.mca;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nonnull;
import mca.api.API;
import mca.core.MCA;
import mca.core.minecraft.ProfessionsMCA;
import mca.entity.EntityVillagerMCA;
import mca.entity.data.PlayerHistory;
import mca.enums.EnumAgeState;
import mca.enums.EnumGender;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityVillagerMCA.class})
public abstract class EntityVillagerMCAMixin
extends EntityVillager {
    @Unique
    private String localizator$myCauseName;

    @Inject(method={"onDeath(Lnet/minecraft/util/DamageSource;)V"}, at={@At(value="HEAD")}, remap=false)
    private void MCA_EntityVillagerMCA_onDeath_getCauseName(DamageSource cause, CallbackInfo ci) {
        if (!this.field_70170_p.field_72995_K) {
            this.localizator$myCauseName = cause.func_76364_f() == null ? cause.func_76355_l() : cause.func_76364_f().func_70005_c_();
        }
    }

    @ModifyArg(method={"onDeath(Lnet/minecraft/util/DamageSource;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;sendMessage(Lnet/minecraft/util/text/ITextComponent;)V", ordinal=0, remap=true), remap=false)
    private ITextComponent MCA_EntityVillagerMCA_onDeath_sendMessage_spousedied(ITextComponent message) {
        return new TextComponentTranslation("notify.spousedied_", new Object[]{this.get(EntityVillagerMCA.VILLAGER_NAME), this.localizator$myCauseName}).func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    }

    @ModifyArg(method={"lambda$onDeath$3(Ljava/lang/String;Lnet/minecraft/entity/Entity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;sendMessage(Lnet/minecraft/util/text/ITextComponent;)V", ordinal=0, remap=true), remap=false)
    private ITextComponent MCA_EntityVillagerMCA_onDeath_sendMessage_childdied(ITextComponent message) {
        return new TextComponentTranslation("notify.childdied_", new Object[]{this.get(EntityVillagerMCA.VILLAGER_NAME), this.localizator$myCauseName}).func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    }

    @ModifyArg(method={"lambda$onGrowingAdult$5(Lnet/minecraft/entity/Entity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;sendMessage(Lnet/minecraft/util/text/ITextComponent;)V", ordinal=0, remap=true), remap=false)
    private ITextComponent MCA_EntityVillagerMCA_onGrowingAdult_sendMessage_growUp(ITextComponent component) {
        return new TextComponentTranslation("notify.child.grownup_", new Object[]{this.get(EntityVillagerMCA.VILLAGER_NAME)});
    }

    @Nonnull
    @Overwrite(remap=false)
    public ITextComponent func_145748_c_() {
        TextComponentTranslation professionName;
        TextComponentTranslation careerName = new TextComponentTranslation("entity.Villager." + this.getVanillaCareer().getName(), new Object[0]);
        EnumAgeState age = EnumAgeState.byId((int)((Integer)this.get(EntityVillagerMCA.AGE_STATE)));
        TextComponentTranslation textComponentTranslation = professionName = age != EnumAgeState.ADULT ? new TextComponentTranslation(age.localizedName(), new Object[0]) : careerName;
        TextFormatting color = this.getProfessionForge() == ProfessionsMCA.bandit ? TextFormatting.RED : (this.getProfessionForge() == ProfessionsMCA.guard ? TextFormatting.GREEN : TextFormatting.RESET);
        return new TextComponentString(MCA.getConfig().villagerChatPrefix).func_150257_a(new TextComponentString(String.format("%s (", this.get(EntityVillagerMCA.VILLAGER_NAME))).func_150257_a((ITextComponent)professionName)).func_150258_a(")").func_150255_a(new Style().func_150238_a(color));
    }

    @Overwrite(remap=false)
    public void say(Optional<EntityPlayer> player, String phraseId, String ... params) {
        ArrayList<String> paramsList = new ArrayList<String>();
        if (params != null) {
            Collections.addAll(paramsList, params);
        }
        if (player.isPresent()) {
            EntityPlayer thePlayer = (EntityPlayer)player.get();
            paramsList.add(0, thePlayer.func_70005_c_());
            if (((Boolean)this.get(EntityVillagerMCA.IS_INFECTED)).booleanValue()) {
                thePlayer.func_145747_a(this.func_145748_c_().func_150258_a(": ???"));
                this.func_184185_a(SoundEvents.field_187899_gZ, 0.5f, this.field_70146_Z.nextFloat() + 0.5f);
            } else {
                String dialogueType = this.getPlayerHistoryFor(((EntityPlayer)player.get()).func_110124_au()).getDialogueType().getId();
                String langKey = MCA.getLocalizer().localize(dialogueType + "." + phraseId, paramsList);
                paramsList.add(API.getRandomName((EnumGender)EnumGender.getRandom()));
                paramsList.add(API.getRandomName((EnumGender)EnumGender.getRandom()));
                TextComponentTranslation phrase = new TextComponentTranslation(langKey, paramsList.toArray());
                thePlayer.func_145747_a(this.func_145748_c_().func_150258_a(": ").func_150257_a((ITextComponent)phrase));
            }
        } else {
            MCA.getLog().warn((Object)new Throwable("Say called on player that is not present!"));
        }
    }

    @ModifyArg(method={"handleButtonClick(Lnet/minecraft/entity/player/EntityPlayerMP;Ljava/lang/String;Ljava/lang/String;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayerMP;sendMessage(Lnet/minecraft/util/text/ITextComponent;)V", ordinal=0, remap=true), remap=false)
    private ITextComponent MCA_EntityVillagerMCA_handleButtonClick_sendMessage_localize(ITextComponent component) {
        return new TextComponentTranslation("info.trading.disabled", new Object[0]);
    }

    @Shadow(remap=false)
    public <T> T get(DataParameter<T> key) {
        return (T)this.field_70180_af.func_187225_a(key);
    }

    @Shadow(remap=false)
    public VillagerRegistry.VillagerCareer getVanillaCareer() {
        return null;
    }

    @Shadow(remap=false)
    public PlayerHistory getPlayerHistoryFor(UUID uuid) {
        return null;
    }

    public EntityVillagerMCAMixin(World worldIn) {
        super(worldIn);
    }
}

