/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.handlers;

import java.io.File;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kameib.localizator.Localizator;
import kameib.localizator.data.Production;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Config(modid="localizator")
public class ForgeConfigHandler {
    @Config.Comment(value={"Enable/Disable Localization Mixins (Tweaks)"})
    @Config.Name(value="Localizing_Mixins")
    @Config.LangKey(value="config.localizator.localizingMixins")
    public static final LocalizingMixinsConfig localizingMixinsConfig = new LocalizingMixinsConfig();
    @Config.Comment(value={"Enable/Disable QoL/bug-fix Mixins (Tweaks)"})
    @Config.Name(value="Miscelaneous_Mixins")
    @Config.LangKey(value="config.localizator.miscelaneousMixins")
    public static final MiscelaneousMixinsConfig miscelaneousMixinsConfig = new MiscelaneousMixinsConfig();
    @Config.Comment(value={"Apply Enabled Server-Side Mixins"})
    @Config.Name(value="Server")
    @Config.LangKey(value="config.localizator.server")
    public static final ServerConfig serverConfig = new ServerConfig();
    @Config.Comment(value={"Apply Enabled Client-side Mixins"})
    @Config.Name(value="Client")
    @Config.LangKey(value="config.localizator.client")
    public static final ClientConfig clientConfig = new ClientConfig();
    private static HashSet<Block> noveltyBlocksWhitelist = null;
    private static File configFile;
    private static String configBooleanString;
    private static boolean isFirstBoot;

    public static HashSet<Block> getNoveltyBlocksWhitelist() {
        if (noveltyBlocksWhitelist == null) {
            noveltyBlocksWhitelist = new HashSet();
            if (ForgeConfigHandler.serverConfig.minecraftPreventNoveltyBlocksPlacementWhitelist == null) {
                ForgeConfigHandler.serverConfig.minecraftPreventNoveltyBlocksPlacementWhitelist = new String[]{""};
            }
            for (String name : ForgeConfigHandler.serverConfig.minecraftPreventNoveltyBlocksPlacementWhitelist) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
                if (block == null || block == Blocks.field_150350_a) {
                    Localizator.LOGGER.warn("Localizator Novelty Blocks Whitelist. Invalid block: {}, ignoring...", (Object)name);
                    continue;
                }
                noveltyBlocksWhitelist.add(block);
            }
        }
        return noveltyBlocksWhitelist;
    }

    public static boolean getBoolean(String name) {
        if (configFile == null) {
            configFile = new File("config", "localizator.cfg");
            if (configFile.exists() && configFile.isFile()) {
                Throwable throwable;
                String configCurrentVersion = "";
                try {
                    throwable = null;
                    try (Stream<String> streamOld = Files.lines(configFile.toPath());){
                        configCurrentVersion = streamOld.filter(s -> s.trim().contains("Enable/Disable Localization Mixins (Tweaks)")).collect(Collectors.joining());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Exception e) {
                    Localizator.LOGGER.error("Failed to open LocEntityNameMixin config: {}", (Object)String.valueOf(e));
                }
                boolean bl = Production.migratedCfg = !configCurrentVersion.contains("Enable/Disable Localization Mixins (Tweaks)");
                if (Production.migratedCfg) {
                    String oldCfgName = "localizator_old.cfg";
                    Localizator.LOGGER.warn("[Localizator] Found an old-version config file. Renaming it to \"{}\" and creating a new one...", (Object)oldCfgName);
                    try {
                        Files.deleteIfExists(new File("config", oldCfgName).toPath());
                    }
                    catch (Exception e) {
                        Localizator.LOGGER.error("Failed to delete old config file: {}. {}", (Object)oldCfgName, (Object)e);
                    }
                    if (!configFile.renameTo(new File("config", oldCfgName))) {
                        Localizator.LOGGER.error("Failed to rename config file to: {}", (Object)oldCfgName);
                    }
                    Localizator.LOGGER.info("[Localizator] Please re-enable all your desired Mixins and configurations. Sorry for the inconvenience!");
                    configFile = null;
                    configBooleanString = "";
                    return false;
                }
                try {
                    throwable = null;
                    try (Stream<String> stream = Files.lines(configFile.toPath());){
                        configBooleanString = stream.filter(s -> s.trim().startsWith("B:")).collect(Collectors.joining());
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Exception ex) {
                    Localizator.LOGGER.error("Failed to parse LocEntityNameMixin config: {}", (Object)String.valueOf(ex));
                }
            } else {
                isFirstBoot = false;
            }
        }
        return isFirstBoot || configBooleanString.contains("B:\"" + name + "\"=true");
    }

    static {
        configBooleanString = "";
        isFirstBoot = false;
    }

    @Mod.EventBusSubscriber(modid="localizator")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("localizator")) {
                noveltyBlocksWhitelist = null;
                ConfigManager.sync((String)"localizator", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class ServerConfig {
        @Config.Comment(value={"If an item has both LocName and Name display NBT tags, show LocName instead of Name. \nThis is useful for Mixins that localize mods like Recurrent Complex, \nwhich assign custom hardcoded names to items on generation. \nRequired Mixin: \n- (Minecraft) Better Localized Name Mixin"})
        @Config.Name(value="(Minecraft) Show LocName instead of Name")
        @Config.LangKey(value="config.localizator.server.minecraftLocNameOverName")
        public boolean minecraftLocNameOverName = true;
        @Config.Comment(value={"This list is added to the original SRParasites Name lists. \nRequired Mixin: \n- (SRParasites) Custom Adventurer Names Mixin"})
        @Config.Name(value="(SRParasites) Custom Parasite Name list")
        @Config.LangKey(value="config.localizator.server.srparasitesCustomNamesList")
        public String[] srparasitesCustomNamesList = new String[]{"Collin"};
        @Config.Comment(value={"Enable the Lava Fish Bucket recipe?\nThis item will be registered only if Fishing Made Better is loaded"})
        @Config.Name(value="(FishingMadeBetter) Lava Fish Bucket")
        @Config.LangKey(value="config.localizator.server.fishingmadebetterLavaFishBucket")
        @Config.RequiresMcRestart
        public boolean fishingmadebetterLavaFishBucket = true;
        @Config.Comment(value={"Enable the Void Bucket and Void Fish Bucket recipes?\nThese items will be registered only if Fishing Made Better is loaded"})
        @Config.Name(value="(FishingMadeBetter) Void Fish Bucket")
        @Config.LangKey(value="config.localizator.server.fishingmadebetterVoidFishBucket")
        @Config.RequiresMcRestart
        public boolean fishingmadebetterVoidFishBucket = true;
        @Config.Comment(value={"Should the \"Nebris Crown\" (Golden Helmet) Novelty generate with the \"Unbreakable\" NBT tag?\nRequired Mixin: \n- (RLD) Unbreakable Novelties Mixin"})
        @Config.Name(value="(RLD) Eternal Nebris Crown")
        @Config.LangKey(value="config.localizator.server.rldEternalNebrisCrown")
        public boolean rldEternalNebrisCrown = true;
        @Config.Comment(value={"Should the \"Null Pointer\" (Diamond Sword) Novelty generate with the \"Unbreakable\" NBT tag?\nRequired Mixin: \n- (RLD) Unbreakable Novelties Mixin"})
        @Config.Name(value="(RLD) Eternal Null Pointer")
        @Config.LangKey(value="config.localizator.server.rldEternalNullPointer")
        public boolean rldEternalNullPointer = true;
        @Config.Comment(value={"Should the \"Man Pants\" (Leather Leggings) Novelty generate with the \"Unbreakable\" NBT tag?\nRequired Mixin: \n- (RLD) Unbreakable Novelties Mixin"})
        @Config.Name(value="(RLD) Eternal Man Pants")
        @Config.LangKey(value="config.localizator.server.rldEternalManPants")
        public boolean rldEternalManPants = true;
        @Config.Comment(value={"Should the \"Farland Travelers\" (Leather Boots) Novelty generate with the \"Unbreakable\" NBT tag?\nRequired Mixin: \n- (RLD) Unbreakable Novelties Mixin"})
        @Config.Name(value="(RLD) Eternal Farland Travelers")
        @Config.LangKey(value="config.localizator.server.rldEternalFarlandTravelers")
        public boolean rldEternalFarlandTravelers = true;
        @Config.Comment(value={"Should the \"Lascerator\" (Shears) Novelty generate with the \"Unbreakable\" NBT tag?\nRequired Mixin: \n- (RLD) Unbreakable Novelties Mixin"})
        @Config.Name(value="(RLD) Eternal Lascerator")
        @Config.LangKey(value="config.localizator.server.rldEternalLascerator")
        public boolean rldEternalLascerator = true;
        @Config.Comment(value={"Should the \"Pink Sweater\" (Leather Chestplate) Novelty generate with the \"Unbreakable\" NBT tag?\nRequired Mixin: \n- (RLD) Unbreakable Novelties Mixin"})
        @Config.Name(value="(RLD) Eternal Pink Sweater")
        @Config.LangKey(value="config.localizator.server.rldEternalPinkSweater")
        public boolean rldEternalPinkSweater = true;
        @Config.Comment(value={"Should the \"Dig Job\" (Diamond Shovel) Novelty generate with the \"Unbreakable\" NBT tag?\nRequired Mixin: \n- (RLD) Unbreakable Novelties Mixin"})
        @Config.Name(value="(RLD) Eternal Dig Job")
        @Config.LangKey(value="config.localizator.server.rldEternalDigJob")
        public boolean rldEternalDigJob = true;
        @Config.Comment(value={"Should the \"Your Mum\" (Wooden Pickaxe) Novelty generate with the \"Unbreakable\" NBT tag?\nRequired Mixin: \n- (RLD) Unbreakable Novelties Mixin"})
        @Config.Name(value="(RLD) Eternal Your Mum")
        @Config.LangKey(value="config.localizator.server.rldEternalYourMum")
        public boolean rldEternalYourMum = true;
        @Config.Comment(value={"Should the \"Enikos String Theory\" (Bow) Novelty generate with the \"Unbreakable\" NBT tag?\nRequired Mixin: \n- (RLD) Unbreakable Novelties Mixin"})
        @Config.Name(value="(RLD) Eternal Enikos String Theory")
        @Config.LangKey(value="config.localizator.server.rldEternalEnikoStringTheory")
        public boolean rldEternalEnikoStringTheory = true;
        @Config.Comment(value={"Should the \"Enikos Earring\" (Diamond Sword) Novelty generate with the \"Unbreakable\" NBT tag?\nRequired Mixin: \n- (RLD) Unbreakable Novelties Mixin"})
        @Config.Name(value="(RLD) Eternal Enikos Earring")
        @Config.LangKey(value="config.localizator.server.rldEternalEnikoEarring")
        public boolean rldEternalEnikoEarring = true;
        @Config.Comment(value={"Should the \"Bajs Last Resort\" (Golden Hoe) Novelty generate with the \"Unbreakable\" NBT tag?\nRequired Mixin: \n- (RLD) Unbreakable Novelties Mixin"})
        @Config.Name(value="(RLD) Eternal Bajs Last Resort")
        @Config.LangKey(value="config.localizator.server.rldEternalBajLastResort")
        public boolean rldEternalBajLastResort = true;
        @Config.Comment(value={"Should the \"Rod of Command\" (Fishing Rod) Novelty generate with the \"Unbreakable\" NBT tag?\nRequired Mixin: \n- (RLD) Unbreakable Novelties Mixin"})
        @Config.Name(value="(RLD) Eternal Rod of Command")
        @Config.LangKey(value="config.localizator.server.rldEternalRodOfCommand")
        public boolean rldEternalRodOfCommand = true;
        @Config.Comment(value={"Should the \"Valandrahs Kiss\" (Iron Sword) Novelty generate with the \"Unbreakable\" NBT tag?\nRequired Mixin: \n- (RLD) Unbreakable Novelties Mixin"})
        @Config.Name(value="(RLD) Eternal Valandrahs Kiss")
        @Config.LangKey(value="config.localizator.server.rldEternalValandrahKiss")
        public boolean rldEternalValandrahKiss = true;
        @Config.Comment(value={"Do you have any custom dungeon with Husk Spawners?\nThis option will balance this mobs Novelty generation chance acordingly.\nRequired Mixin: \n- (RLD) Extended Novelty Pool Mixin"})
        @Config.Name(value="(RLD) Custom Spawner - Husk")
        @Config.LangKey(value="config.localizator.server.rldCustomSpawnerHusk")
        public boolean rldCustomSpawnerHusk = false;
        @Config.Comment(value={"Do you have any custom dungeon with Zombie Villager Spawners?\nThis option will balance this mobs Novelty generation chance acordingly.\nRequired Mixin: \n- (RLD) Extended Novelty Pool Mixin"})
        @Config.Name(value="(RLD) Custom Spawner - Zombie Villager")
        @Config.LangKey(value="config.localizator.server.rldCustomSpawnerZombieVillager")
        public boolean rldCustomSpawnerZombieVillager = false;
        @Config.Comment(value={"If you have any custom dungeon with Vindicator Spawners, Johnny will have a chance to spawn from them.\n0.00 = 0% Spawn chance\n1.0 = 100% Spawn chance\nRequired Mixin: \n- (RLD) Spawn Johnny Mixin"})
        @Config.Name(value="(RLD) Johnny spawning chance")
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.LangKey(value="config.localizator.server.rldJohnnySpawnChance")
        public double rldJohnnySpawnChance = 0.0;
        @Config.Comment(value={"Prevent players from placing Novelty Paintings in the world by mistake, losing them.\nThe player will receive a message explaining why it can't be placed.\nRequired Mixin: \n- (Minecraft) Prevent Novelties Placement Mixin"})
        @Config.Name(value="(Minecraft) Prevent Novelty Paintings Placement")
        @Config.LangKey(value="config.localizator.server.minecraftPreventNoveltyPaintingsPlacement")
        public boolean minecraftPreventNoveltyPaintingsPlacement = true;
        @Config.Comment(value={"Prevent players from placing Novelty Signs in the world by mistake, losing them.\nThe player will receive a message explaining why it can't be placed.\nRequired Mixin: \n- (Minecraft) Prevent Novelties Placement Mixin"})
        @Config.Name(value="(Minecraft) Prevent Novelty Signs Placement")
        @Config.LangKey(value="config.localizator.server.minecraftPreventNoveltySignsPlacement")
        public boolean minecraftPreventNoveltySignsPlacement = true;
        @Config.Comment(value={"Prevent players from placing Novelty Skulls in the world by mistake, losing them.\nThe player will receive a message explaining why it can't be placed.\nRequired Mixin: \n- (Minecraft) Prevent Novelties Placement Mixin"})
        @Config.Name(value="(Minecraft) Prevent Novelty Skulls Placement")
        @Config.LangKey(value="config.localizator.server.minecraftPreventNoveltySkullsPlacement")
        public boolean minecraftPreventNoveltySkullsPlacement = true;
        @Config.Comment(value={"Prevent players from placing Novelty Blocks in the world by mistake, losing them.\nThe player will receive a message explaining why it can't be placed.\nRequired Mixin: \n- (Minecraft) Prevent Novelties Placement Mixin"})
        @Config.Name(value="(Minecraft) Prevent Novelty Blocks Placement")
        @Config.LangKey(value="config.localizator.server.minecraftPreventNoveltyBlocksPlacement")
        public boolean minecraftPreventNoveltyBlocksPlacement = true;
        @Config.Comment(value={"Block ID Whitelist to enable players to place the designated Novelty Blocks in the world.\nExample ID: minecraft:dirt\n\nKeep in mind, when a Block is placed in the world, its NBT tags are deleted, turning a Novelty into a normal Block! (Vanilla behaviour)\nRequired Server Config: \n- (Minecraft) Prevent Novelty Blocks Placement"})
        @Config.Name(value="(Minecraft) Prevent Novelty Blocks Placement Whitelist")
        @Config.LangKey(value="config.localizator.server.minecraftPreventNoveltyBlocksPlacementWhitelist")
        public String[] minecraftPreventNoveltyBlocksPlacementWhitelist = new String[]{""};
    }

    public static class ClientConfig {
        @Config.Comment(value={"If an entity has a custom name (CustomName tag with a language key in it), translate it. \nRequired Mixin:\n- (Minecraft) Mob Custom Names Mixin"})
        @Config.Name(value="(Minecraft) Translate Mob Custom Names")
        @Config.LangKey(value="config.localizator.client.minecraftMobLocCustomNames")
        public boolean minecraftMobLocCustomNames = true;
        @Config.Comment(value={"If a Boss has a custom Name (CustomName tag with a language key in it), translate it on client side. \nThe corresponding language key must exist! \nRequired Mixin:\n- (Minecraft) Boss Custom Names Mixin"})
        @Config.Name(value="(Minecraft) Translate Boss Custom Names")
        @Config.LangKey(value="config.localizator.client.minecraftBossLocCustomNames")
        public boolean minecraftBossLocCustomNames = true;
        @Config.Comment(value={"If an item has both \"Lore\" and \"LocLore\" NBT tags, LocLore contents will override Lore contents. \nIf it has only one of the lore tags, it will be displayed normally. \nRequired Mixin: \n- (Minecraft) Localized Lore Mixin"})
        @Config.Name(value="(Minecraft) Hide Lore if LocLore exists")
        @Config.LangKey(value="config.localizator.client.minecraftHideLore")
        public boolean minecraftHideLore = true;
        @Config.Comment(value={"If an entity has a custom name (CustomName tag with a language key), translate it. nRequired Mixin:\n- (Neat) Health Bar Mixin"})
        @Config.Name(value="(Neat) Translate Names In Health Bar")
        @Config.LangKey(value="config.localizator.client.neatLocHealthBar")
        public boolean neatLocHealthBar = true;
        @Config.Comment(value={"In SRP armor tooltip, translate resisted damage sources names. \nEntity names are taken from Forge's registry (automatic). \nNon-entity names are taken from a lang file. \nRequired Mixin: \n- (SRParasites) Armor Tooltips Mixin \nDisable this option if it impacts performance."})
        @Config.Name(value="(SRParasites) Translate Resisted Damage Sources")
        @Config.LangKey(value="config.localizator.client.srparasitesResistances")
        public boolean srparasitesResistances = true;
        @Config.Comment(value={"Prevents a Bauble's Modifier from displaying at Bauble Name\nRequired Mixin: \n- (BountifulBaubles) No Modifier at Name Mixin"})
        @Config.Name(value="(BountifulBaubles) Remove Modifier from Bauble Name")
        @Config.LangKey(value="config.localizator.client.bountifulbaublesRemoveModifierFromName")
        public boolean bountifulbaublesRemoveModifierFromName = true;
        @Config.Comment(value={"Removes the need of pressing Shift on RoughTweaks Items Tooltip to show the Heal Amount. \nRequired Mixin: \n- (RoughTweaks) Localized Names and Better Tooltip Mixin"})
        @Config.Name(value="(RoughTweaks) Show Heal Amount")
        @Config.LangKey(value="config.localizator.client.roughtweaksTooltip")
        public boolean roughtweaksTooltip = true;
        @Config.Comment(value={"Adds a little help for players that don't know how to fish. \n \"Press [LEFT] / [RIGHT]\". \nRequired Mixin: \n- (FishingMadeBetter) Instructions on Minigame Mixin"})
        @Config.Name(value="(FishingMadeBetter) Instructions on Minigame")
        @Config.LangKey(value="config.localizator.client.fishingmadebetterMinigameHelpText")
        public boolean fishingmadebetterMinigameHelpText = true;
        @Config.Comment(value={"The Overworld Sea Level line shown over the Fish Requirements JEI Plugin"})
        @Config.Name(value="(FMB/JEI) Y Meter. Overworld Sea Level")
        @Config.RangeInt(min=0, max=140)
        @Config.LangKey(value="config.localizator.client.fishingmadebetterYmeterSeaLevelText")
        @Config.RequiresMcRestart
        public int fishingmadebetterYmeterSeaLevel = 62;
        @Config.Comment(value={"The Nether Lava Ocean Level line shown over the Fish Requirements JEI Plugin"})
        @Config.Name(value="(FMB/JEI) Y Meter. Nether Lava Ocean Level")
        @Config.RangeInt(min=0, max=140)
        @Config.LangKey(value="config.localizator.client.fishingmadebetterYmeterLavaLevelText")
        @Config.RequiresMcRestart
        public int fishingmadebetterYmeterLavaLevel = 31;
        @Config.Comment(value={"The End Void Level line shown over the Fish Requirements JEI Plugin.\nIt's set to 5 just for visuals."})
        @Config.Name(value="(FMB/JEI) Y Meter. The End Void Level")
        @Config.RangeInt(min=0, max=140)
        @Config.LangKey(value="config.localizator.client.fishingmadebetterYmeterVoidLevelText")
        @Config.RequiresMcRestart
        public int fishingmadebetterYmeterVoidLevel = 5;
        @Config.Comment(value={"Represent fish light levels with the Photometer icon (if Inspirations mod is present)\nIf Inspirations is not present or this option is false, the Minecraft light icon is used."})
        @Config.Name(value="(FMB/JEI) Use Photometer icon for light levels")
        @Config.LangKey(value="config.localizator.client.fishingmadebetterPhotometer")
        public boolean fishingmadebetterPhotometer = true;
        @Config.Comment(value={"Minecraft shows an item's Lore with dark_purple color.\nLocalizator shows LocLore with white color.\nYou can choose the default text color for LocLore texts here.\nIf your lang key doesn't have any formatting codes, its text will be shown with this color setting.\n\nValid colors:\n black, dark_blue, dark_green, dark_aqua, dark_red, dark_purple, gold, gray, dark_gray, blue, green, aqua, red, light_purple, yellow, white"})
        @Config.Name(value="(Minecraft) LocLore Default Text Color")
        @Config.LangKey(value="config.localizator.client.minecraftDefaultLocLoreColor")
        public String minecraftDefaultLocLoreColor = "white";
        @Config.Comment(value={"Minecraft shows an item's Lore with italic format.\nLocalizator shows LocLore with no formatting code.\nYou can choose the default text formatting for LocLore texts here.\nIf your lang key doesn't have any formatting codes, its text will be shown with this formatting setting.\n\nValid formats:\n obfuscated, bold, strikethrough, underline, italic, none"})
        @Config.Name(value="(Minecraft) LocLore Default Text Format")
        @Config.LangKey(value="config.localizator.client.minecraftDefaultLocLoreFormat")
        public String minecraftDefaultLocLoreFormat = "none";
    }

    public static class MiscelaneousMixinsConfig {
        @Config.Comment(value={"Applies some QoL tooltip fixes. \n* Fixes Flywheel Ring's energy tooltip string not rendering its color properly. \n* Enables the Client config: \n- (BountifulBaubles) Remove Modifier from Bauble Name"})
        @Config.Name(value="(BountifulBaubles) Tooltip fixes Mixin")
        @Config.LangKey(value="config.localizator.mixins.bountifulbaublesTooltipFixesMixin")
        @Config.RequiresMcRestart
        public boolean bountifulbaublesTooltipFixesMixin = false;
        @Config.Comment(value={"If you hate those weird \"\u00c2\" symbols in the Staff tooltip as much as me, enable this Mixin."})
        @Config.Name(value="(DyamicTrees) Staff Mixin")
        @Config.LangKey(value="config.localizator.mixins.dynamictreesStaffMixin")
        @Config.RequiresMcRestart
        public boolean dynamictreesStaffMixin = false;
        @Config.Comment(value={"If an item is not THAT errored, retrieve its name and display it. \nWorks with ArmorUnderwear's Ozzy Liners and other items!"})
        @Config.Name(value="(ItemPhysic) ERRORED patch Mixin")
        @Config.LangKey(value="config.localizator.mixins.itemphysicErroredMixin")
        @Config.RequiresMcRestart
        public boolean itemphysicErroredMixin = false;
        @Config.Comment(value={"Reverse the order of a dropped item description, so it shows the same as on its tooltip."})
        @Config.Name(value="(ItemPhysic) Reverse Description Mixin")
        @Config.LangKey(value="config.localizator.mixins.itemphysicReverseDescriptionMixin")
        @Config.RequiresMcRestart
        public boolean itemphysicReverseDescriptionMixin = false;
        @Config.Comment(value={"Point Patrons and Version calls to valid repo URLs, to prevent java.io.FileNotFoundException."})
        @Config.Name(value="(iChunUtil) Fix Patrons and Version URL Mixin")
        @Config.LangKey(value="config.localizator.mixins.ichunutilFixURLs")
        @Config.RequiresMcRestart
        public boolean ichunutilFixURLs = false;
        @Config.Comment(value={"Adds cobweb immunity to the Ankh Charm. \nIf it makes sense to you as well c:"})
        @Config.Name(value="(BountifulBaubles) Ankh Charm Web Immune Mixin")
        @Config.LangKey(value="config.localizator.mixins.bountifulbaublesAnkhCharmWebImmunity")
        @Config.RequiresMcRestart
        public boolean bountifulbaublesAnkhCharmWebImmunity = false;
        @Config.Comment(value={"Adds cobweb immunity to the Ankh Shield. \nIf it makes sense to you as well c:"})
        @Config.Name(value="(BountifulBaubles) Ankh Shield Web Immune Mixin")
        @Config.LangKey(value="config.localizator.mixins.bountifulbaublesAnkhShieldmWebImmunity")
        @Config.RequiresMcRestart
        public boolean bountifulbaublesAnkhShieldmWebImmunity = false;
        @Config.Comment(value={"Enables the Client config:\n- (FishingMadeBetter) Instructions on Minigame"})
        @Config.Name(value="(FishingMadeBetter) Instructions on Minigame Mixin")
        @Config.LangKey(value="config.localizator.mixins.fishingmadebetterMinigameHelpTextMixin")
        @Config.RequiresMcRestart
        public boolean fishingmadebetterMinigameHelpTextMixin = false;
        @Config.Comment(value={"Enables the user-defined Name list for the parasite Adventurers/Thralls.\nRequires \"Mod Easter Eggs\" option in SRParasites cfg to be enabled."})
        @Config.Name(value="(SRParasites) Custom Adventurer Names Mixin")
        @Config.LangKey(value="config.localizator.mixins.srparasitesCustomAdventurerNames")
        @Config.RequiresMcRestart
        public boolean srparasitesCustomAdventurerNames = false;
        @Config.Comment(value={"Makes some Roguelike Dungeons Novelties generate with the \"Unbreakable\" NBT tag.\nIndividual Novelty items can be configured in the Server config section."})
        @Config.Name(value="(RLD) Unbreakable Novelties Mixin")
        @Config.LangKey(value="config.localizator.mixins.rldEternalNovelties")
        @Config.RequiresMcRestart
        public boolean rldEternalNovelties = false;
        @Config.Comment(value={"Originally, some zombies and skeletons rarely spawned with 1 of these 3 Novelty items:\n- Ashlea's Otameal Cookie\n- Rleahian battle sub\n- Valandrah's Kiss\nThis Mixin will enable more mob types to spawn holding or wearing other novelties.\nAlso, room-specific novelties will have a chance to generate in containers, making all novelties obtainable!"})
        @Config.Name(value="(RLD) Extended Novelty Pool Mixin")
        @Config.LangKey(value="config.localizator.mixins.rldExtendedNovelties")
        @Config.RequiresMcRestart
        public boolean rldExtendedNovelties = false;
        @Config.Comment(value={"Enables the Server config:\n- (RLD) Johnny spawning chance"})
        @Config.Name(value="(RLD) Spawn Johnny Mixin")
        @Config.LangKey(value="config.localizator.mixins.rldSpawnJohnny")
        @Config.RequiresMcRestart
        public boolean rldSpawnJohnny = false;
        @Config.Comment(value={"When using the /kill command, item entities will show their correct name instead of item.item.the_item."})
        @Config.Name(value="(Minecraft) Item Names on Kill Command Mixin")
        @Config.LangKey(value="config.localizator.mixins.minecraftLocItemEntityNameMixin")
        @Config.RequiresMcRestart
        public boolean minecraftLocItemEntityNameMixin = false;
        @Config.Comment(value={"Prevents players from placing Novelty Items in the world by mistake.\nItems with Name and Lore (or their localized versions) NBT tags are considered as Novelties.\nThis applies to:\n- Paintings\n- Signs\n- Skulls\n- Any other Block Item that has no custom action when placing it."})
        @Config.Name(value="(Minecraft) Prevent Novelties Placement Mixin")
        @Config.LangKey(value="config.localizator.mixins.minecraftPreventNoveltyPlacementMixin")
        @Config.RequiresMcRestart
        public boolean minecraftPreventNoveltyPlacementMixin = false;
    }

    public static class LocalizingMixinsConfig {
        @Config.Comment(value={"Enables the Client config: \n- (Minecraft) Translate Mob Custom Names"})
        @Config.Name(value="(Minecraft) Mob Custom Names Mixin")
        @Config.LangKey(value="config.localizator.mixins.minecraftMobLocCustomNamesMixin")
        @Config.RequiresMcRestart
        public boolean minecraftMobLocCustomNamesMixin = false;
        @Config.Comment(value={"Enables the Client config: \n- (Minecraft) Translate Boss Custom Names"})
        @Config.Name(value="(Minecraft) Boss Custom Names Mixin")
        @Config.LangKey(value="config.localizator.mixins.minecraftBossLocCustomNamesMixin")
        @Config.RequiresMcRestart
        public boolean minecraftBossLocCustomNamesMixin = false;
        @Config.Comment(value={"Enables Localized Lore \"LocLore\" NBT tag support.\nFor items with translatable \"lore\"."})
        @Config.Name(value="(Minecraft) Localized Lore Mixin")
        @Config.LangKey(value="config.localizator.mixins.minecraftLocLoreMixin")
        @Config.RequiresMcRestart
        public boolean minecraftLocLoreMixin = false;
        @Config.Comment(value={"Makes the \"LocName\" NBT tag, support language keys that accept parameters.\nAlso, enables the Server config: \n- (Minecraft) Show LocName instead of Name"})
        @Config.Name(value="(Minecraft) Better Localized Name Mixin")
        @Config.LangKey(value="config.localizator.mixins.minecraftLocNameMixin")
        @Config.RequiresMcRestart
        public boolean minecraftLocNameMixin = false;
        @Config.Comment(value={"Localizes Biome Names. \nFor modded biomes, please create and include their respective lang keys in your modpack"})
        @Config.Name(value="(Minecraft) Localized Biome Name Mixin")
        @Config.LangKey(value="config.localizator.mixins.minecraftBiomeMixin")
        @Config.RequiresMcRestart
        public boolean minecraftBiomeMixin = false;
        @Config.Comment(value={"Enables \"locTitle\" and \"locAuthor\" NBT tags support.\nFor Written Books with localized author and title."})
        @Config.Name(value="(Minecraft) Localized Written Book Mixin")
        @Config.LangKey(value="config.localizator.mixins.minecraftLocWrittenBookMixin")
        @Config.RequiresMcRestart
        public boolean minecraftLocWrittenBookMixin = false;
        @Config.Comment(value={"Enables \"locPages\" NBT List tag support.\nFor Command-Generated Writable Books with localized pages."})
        @Config.Name(value="(Minecraft) Localized Writable Book Mixin")
        @Config.LangKey(value="config.localizator.mixins.minecraftLocWritableBookMixin")
        @Config.RequiresMcRestart
        public boolean minecraftLocWritableBookMixin = false;
        @Config.Comment(value={"Localizes a Container (TileEntityLockable) CustomName."})
        @Config.Name(value="(Minecraft) Localized Container Name Mixin")
        @Config.LangKey(value="config.localizator.mixins.minecraftLocContainerNameMixin")
        @Config.RequiresMcRestart
        public boolean minecraftLocContainerNameMixin = false;
        @Config.Comment(value={"Enables the Client config: \n- (Neat) Translate Names In Health Bar"})
        @Config.Name(value="(Neat) Health Bar Mixin")
        @Config.LangKey(value="config.localizator.mixins.neatLocHealthBarMixin")
        @Config.RequiresMcRestart
        public boolean neatLocHealthBarMixin = false;
        @Config.Comment(value={"Localizes the MILD/COOL/WARM hardcoded texts when applying an Ozzy liner to a piece of armor."})
        @Config.Name(value="(ArmorUnder) Ozzy Liner text Mixin")
        @Config.LangKey(value="config.localizator.mixins.armorunderOzzyLinerMixin")
        @Config.RequiresMcRestart
        public boolean armorunderOzzyLinerMixin = false;
        @Config.Comment(value={"Enables support for Language keys in Set and Bonus names (config file)."})
        @Config.Name(value="(SetBonus) Tooltip Mixin")
        @Config.LangKey(value="config.localizator.mixins.setbonusTooltipMixin")
        @Config.RequiresMcRestart
        public boolean setbonusTooltipMixin = false;
        @Config.Comment(value={"Localizes all Forgotten Items' item descriptions."})
        @Config.Name(value="(ForgottenItems) Tooltips Mixin")
        @Config.LangKey(value="config.localizator.mixins.forgottenitemsTooltipMixin")
        @Config.RequiresMcRestart
        public boolean forgottenitemsTooltipMixin = false;
        @Config.Comment(value={"Localizes the \"Current Adaptation:\" and \"reduction:\" hardcoded texts on parasite armor tooltip. \nAlso the damage source!\nFor damage sources, enable the Client config: \n- (SRParasites) Translate Resisted Damage Sources"})
        @Config.Name(value="(SRParasites) Armor Tooltips Mixin")
        @Config.LangKey(value="config.localizator.mixins.srparasitesArmorTooltipMixin")
        @Config.RequiresMcRestart
        public boolean srparasitesArmorTooltipMixin = false;
        @Config.Comment(value={"Localizes the \"hits remaining\" hardcoded text added to a weapon's tooltip when it has been imbued with a potion in a cauldron."})
        @Config.Name(value="(BetterSurvival) Potion-Imbued Weapons Tooltip Mixin")
        @Config.LangKey(value="config.localizator.mixins.bettersurvivalTooltipMixin")
        @Config.RequiresMcRestart
        public boolean bettersurvivalTooltipMixin = false;
        @Config.Comment(value={"Modifies the lang keys of Rough Tweaks items, so they don't collide with FirstAid. \nAlso, Enables the Client config: \n- (RoughTweaks) Show Heal Amount"})
        @Config.Name(value="(RoughTweaks) Localized Names and Better Tooltip Mixin")
        @Config.LangKey(value="config.localizator.mixins.roughtweaksNamesAndTooltipMixin")
        @Config.RequiresMcRestart
        public boolean roughtweaksNamesAndTooltipMixin = false;
        @Config.Comment(value={"Localizes the \"Fertile Seasons:\", and seasons hardcoded texts at crop tooltip. \nAlso adds support to the following Rustic seeds: \n- Tomato Seeds \n- Chili seeds."})
        @Config.Name(value="(SereneSeasons) Localized Crop Fertility Tooltip Mixin")
        @Config.LangKey(value="config.localizator.mixins.sereneseasonsTooltipMixin")
        @Config.RequiresMcRestart
        public boolean sereneseasonsTooltipMixin = false;
        @Config.Comment(value={"Localizes special Cakes hardcoded Names."})
        @Config.Name(value="(Charm) Localized Cake Name Mixin")
        @Config.LangKey(value="config.localizator.mixins.charmCakeNameMixin")
        @Config.RequiresMcRestart
        public boolean charmCakeNameMixin = false;
        @Config.Comment(value={"Localizes the Composter JEI Recipe Integration GUI."})
        @Config.Name(value="(Charm) Localized Composter JEI Mixin")
        @Config.LangKey(value="config.localizator.mixins.charmComposterRecipeMixin")
        @Config.RequiresMcRestart
        public boolean charmComposterRecipeMixin = false;
        @Config.Comment(value={"Localizes all Charm Containers Custom Name on GUI."})
        @Config.Name(value="(Charm) Localized Container Name Mixin")
        @Config.LangKey(value="config.localizator.mixins.charmContainerNameMixin")
        @Config.RequiresMcRestart
        public boolean charmContainerNameMixin = false;
        @Config.Comment(value={"Localizes the names of Charm Crates generated in the world."})
        @Config.Name(value="(Charm) Localized World Crates Name Mixin")
        @Config.LangKey(value="config.localizator.mixins.charmWorldCratesNameMixin")
        @Config.RequiresMcRestart
        public boolean charmWorldCratesNameMixin = false;
        @Config.Comment(value={"Enables support for Language Keys in Entity's CustomName tag."})
        @Config.Name(value="(WAILA) Entity Name Mixin")
        @Config.LangKey(value="config.localizator.mixins.wailaEntityNameMixin")
        @Config.RequiresMcRestart
        public boolean wailaEntityNameMixin = false;
        @Config.Comment(value={"Localizes the Grave Scroll description hardcoded text."})
        @Config.Name(value="(CorpseComplex) Grave Scroll Description Mixin")
        @Config.LangKey(value="config.localizator.mixins.corpsecomplexScrollMixin")
        @Config.RequiresMcRestart
        public boolean corpsecomplexScrollMixin = false;
        @Config.Comment(value={"Localizes hardcoded texts in Forge's Mod List screen.\nAlso highlights the important information at the Mod details screen."})
        @Config.Name(value="(FML) Localized Mod List GUI Mixin")
        @Config.LangKey(value="config.localizator.mixins.forgeModListMixin")
        @Config.RequiresMcRestart
        public boolean forgeModListMixin = false;
        @Config.Comment(value={"The messages received from the server will be translated on client side to match their locale."})
        @Config.Name(value="(Lycanites) Client-side Translated Messages Mixin")
        @Config.LangKey(value="config.localizator.mixins.lycanitesMessagesMixin")
        @Config.RequiresMcRestart
        public boolean lycanitesMessagesMixin = false;
        @Config.Comment(value={"Localizes the message sent when the Battle Tower Golem is defeated."})
        @Config.Name(value="(BattleTowers) Golem Defeated Message Mixin")
        @Config.LangKey(value="config.localizator.mixins.battletowersMessagesMixin")
        @Config.RequiresMcRestart
        public boolean battletowersMessagesMixin = false;
        @Config.Comment(value={"Localizes all horse-related messages sent from the server."})
        @Config.Name(value="(Callable Horses) Horse Messages Mixin")
        @Config.LangKey(value="config.localizator.mixins.callableHorsesMessagesMixin")
        @Config.RequiresMcRestart
        public boolean callableHorsesMessagesMixin = false;
        @Config.Comment(value={"Localizes the \"Power: \" status message when throwing an item."})
        @Config.Name(value="(ItemPhysic) Power: Status Message Mixin")
        @Config.LangKey(value="config.localizator.mixins.itemphysicMessagesMixin")
        @Config.RequiresMcRestart
        public boolean itemphysicMessagesMixin = false;
        @Config.Comment(value={"Localizes Artifacts custom names."})
        @Config.Name(value="(RecComplex) Artifact Names Mixin")
        @Config.LangKey(value="config.localizator.mixins.reccomplexLocArtifacts")
        @Config.RequiresMcRestart
        public boolean reccomplexLocArtifacts = false;
        @Config.Comment(value={"Enables \"locPages\" NBT List tag support.\nFor Command-Generated Writable Books with localized pages."})
        @Config.Name(value="(VariedCommodities) Localized Book Mixin")
        @Config.LangKey(value="config.localizator.mixins.variedCommoditiesLocBookMixin")
        @Config.RequiresMcRestart
        public boolean variedcommoditiesLocBookMixin = false;
        @Config.Comment(value={"Localizes caught fishes information (Name, Weight, Scale, Alive)\nAlso localizes:\n- Fish Bucket\n- Fish Slice\n- Bobber\n- Command and Bait Bucket messages messages."})
        @Config.Name(value="(FishingMadeBetter) Localized Fishes Mixin")
        @Config.LangKey(value="config.localizator.mixins.fishingmadebetterLocFishesEtcMixin")
        @Config.RequiresMcRestart
        public boolean fishingmadebetterLocFishesEtcMixin = false;
        @Config.Comment(value={"Localizes Fancy Block Particles Keybinds texts on Settings screen."})
        @Config.Name(value="(FBP) Localized Keybinds Mixin")
        @Config.LangKey(value="config.localizator.mixins.fbpKeyBindsMixin")
        @Config.RequiresMcRestart
        public boolean fbpKeybindsMixin = false;
        @Config.Comment(value={"Localizes LevelUp Reloaded Keybinds texts on Settings screen."})
        @Config.Name(value="(LevelUp2) Localized Keybinds Mixin")
        @Config.LangKey(value="config.localizator.mixins.levelup2KeybindsMixin")
        @Config.RequiresMcRestart
        public boolean levelup2KeybindsMixin = false;
        @Config.Comment(value={"Localizes Mo'Bends Keybinds texts on Settings screen."})
        @Config.Name(value="(Mo'Bends) Localized Keybinds Mixin")
        @Config.LangKey(value="config.localizator.mixins.mobendsKeybindsMixin")
        @Config.RequiresMcRestart
        public boolean mobendsKeybindsMixin = false;
        @Config.Comment(value={"Localizes Scaling Health Keybinds texts on Settings screen."})
        @Config.Name(value="(ScalingHealth) Localized Keybinds Mixin")
        @Config.LangKey(value="config.localizator.mixins.scalingHealthKeybindsMixin")
        @Config.RequiresMcRestart
        public boolean scalingHealthKeybindsMixin = false;
        @Config.Comment(value={"Localizes Swords tooltip \"Material Bonus:\" text."})
        @Config.Name(value="(SpartanWeaponry) Localized Material Bonus Tooltip Mixin")
        @Config.LangKey(value="config.localizator.mixins.spartanWeaponrySwordTooltipMixin")
        @Config.RequiresMcRestart
        public boolean spartanWeaponrySwordTooltipMixin = false;
        @Config.Comment(value={"Localizes Ender Queen's chat messages when hurt."})
        @Config.Name(value="(T&B) Localized Ender Queen messages Mixin")
        @Config.LangKey(value="config.localizator.mixins.xatEnderQueenMessagesMixin")
        @Config.RequiresMcRestart
        public boolean xatEnderQueenMessagesMixin = false;
        @Config.Comment(value={"Localizes the armor weight tooltip text when transformed into Faelis race."})
        @Config.Name(value="(T&B) Localized Armor Weight Tooltip Mixin")
        @Config.LangKey(value="config.localizator.mixins.xatArmorWeightTooltipMixin")
        @Config.RequiresMcRestart
        public boolean xatArmorWeightTooltipMixin = false;
        @Config.Comment(value={"Localizes Scaling Health messages related to the date."})
        @Config.Name(value="(ScalingHealth) Localized Messages Mixin")
        @Config.LangKey(value="config.localizator.mixins.scalingHealthMessagesMixin")
        @Config.RequiresMcRestart
        public boolean scalingHealthMessagesMixin = false;
        @Config.Comment(value={"Localizes SRParasites messages."})
        @Config.Name(value="(SRParasites) Localized Messages Mixin")
        @Config.LangKey(value="config.localizator.mixins.srparasitesMessagesMixin")
        @Config.RequiresMcRestart
        public boolean srparasitesMessagesMixin = false;
        @Config.Comment(value={"Localizes Raw ores names to behave correctly on languages other than English.\nIt took the ore ingot name and stripped \"Ingot\" from it, which works only for English."})
        @Config.Name(value="(DynaOres) Correctly Localized Ore Names")
        @Config.LangKey(value="config.localizator.mixins.dynaoresNameMixin")
        @Config.RequiresMcRestart
        public boolean dynaoresNameMixin = false;
        @Config.Comment(value={"Messages will be taken from lang keys and translated client-side instead of being hardcoded from the config file."})
        @Config.Name(value="(Morpheus) Localized Messages Mixin")
        @Config.LangKey(value="config.localizator.mixins.morpheusMessagesMixin")
        @Config.RequiresMcRestart
        public boolean morpheusMessagesMixin = false;
        @Config.Comment(value={"Localizes messages related to Wormhole teleport items."})
        @Config.Name(value="(BountifulBaubles) Localized Wormhole Messages Mixin")
        @Config.LangKey(value="config.localizator.mixins.bountifulbaublesWormholeMessagesMixin")
        @Config.RequiresMcRestart
        public boolean bountifulbaublesWormholeMessages = false;
        @Config.Comment(value={"Adds the capability to interpret the \"lang\" Tag into the \"InGame Info XML\"'s XML Parser."})
        @Config.Name(value="(IGI) Add lang Tag in XML Mixin")
        @Config.LangKey(value="config.localizator.mixins.IGIlangTagMixin")
        @Config.RequiresMcRestart
        public boolean IGIlangTagMixin = false;
        @Config.Comment(value={"Localizes all Minecraft Comes Alive messages, GUIs, etc."})
        @Config.Name(value="(MCA) Localized Texts Mixin")
        @Config.LangKey(value="config.localizator.mixins.MCATextsMixin")
        @Config.RequiresMcRestart
        public boolean MCATextsMixin = false;
        @Config.Comment(value={"Localizes Biome Names showed in Dynamic Surroundings HUDs. \nFor modded biomes, please create and include their respective lang keys in your modpack."})
        @Config.Name(value="(DSHUDs) Localized Biome Name Mixin")
        @Config.LangKey(value="config.localizator.mixins.dshudsBiomeMixin")
        @Config.RequiresMcRestart
        public boolean dshudsBiomeMixin = false;
        @Config.Comment(value={"Allows custom EnhancedVisuals death messages to be localized."})
        @Config.Name(value="(EnhancedVisuals) Localized Death Message Mixin")
        @Config.LangKey(value="config.localizator.mixins.evDeathMessageMixin")
        @Config.RequiresMcRestart
        public boolean evDeathMessageMixin = false;
    }
}

