/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.common.fishingmadebetter.recipe;

import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import kameib.localizator.common.fishingmadebetter.item.ItemLavaFishBucket;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.theawesomegem.fishingmadebetter.BetterFishUtil;
import net.theawesomegem.fishingmadebetter.common.configuration.CustomConfigurationHandler;
import net.theawesomegem.fishingmadebetter.common.data.FishData;

public class RecipeLavaFishBucket
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private long worldTime;

    @ParametersAreNonnullByDefault
    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        if (worldIn == null) {
            return false;
        }
        this.worldTime = worldIn.func_82737_E();
        return this.validInput(inv) != null;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public ItemStack func_77572_b(InventoryCrafting inv) {
        Integer[] slots = this.validInput(inv);
        if (slots == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemFish = inv.func_70301_a(slots[1].intValue()).func_77946_l();
        return ItemLavaFishBucket.getItemStack(BetterFishUtil.getFishId((ItemStack)itemFish));
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    @Nullable
    private Integer[] validInput(InventoryCrafting inv) {
        int numStacks = 0;
        int bucketSlot = -1;
        int fishSlot = -1;
        ArrayList<Integer> occupiedSlots = new ArrayList<Integer>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            ++numStacks;
            occupiedSlots.add(i);
        }
        if (numStacks != 2) {
            return null;
        }
        Iterator i = occupiedSlots.iterator();
        while (i.hasNext()) {
            int i2 = (Integer)i.next();
            ItemStack itemStack = inv.func_70301_a(i2);
            if (itemStack.func_190926_b()) {
                return null;
            }
            if (itemStack.func_77973_b() == Items.field_151129_at) {
                bucketSlot = i2;
                continue;
            }
            if (BetterFishUtil.isBetterFish((ItemStack)itemStack) && !BetterFishUtil.isDead((ItemStack)itemStack, (long)this.worldTime) && ((FishData)CustomConfigurationHandler.fishDataMap.get((Object)BetterFishUtil.getFishId((ItemStack)itemStack))).liquid.equals((Object)FishData.FishingLiquid.LAVA)) {
                fishSlot = i2;
                continue;
            }
            return null;
        }
        Integer[] slots = new Integer[]{bucketSlot, fishSlot};
        return bucketSlot != -1 && fishSlot != -1 ? slots : null;
    }
}

