/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.client.jei.fishingmadebetter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kameib.localizator.data.Drawing;
import kameib.localizator.data.Texture;
import kameib.localizator.data.fishingmadebetter.FishRequirementData;
import kameib.localizator.handlers.ForgeConfigHandler;
import kameib.localizator.util.FMB_BetterFishUtil;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.gui.elements.DrawableResource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.theawesomegem.fishingmadebetter.common.data.FishData;
import net.theawesomegem.fishingmadebetter.common.item.ItemManager;

public class FishRequirementsRecipeWrapper
implements ICraftingRecipeWrapper {
    private final List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
    private final ItemStack output;
    public List<BiomeDimensionOverlay> overlayList = new ArrayList<BiomeDimensionOverlay>();
    private final FishRequirementData fishRequirementData;
    public DrawableResource photometerIcon;
    public DrawableResource lightLevelIcon;
    public List<String> biomeTypeList = new ArrayList<String>();
    private int biomeDisplay = 0;
    private static final short minigameBackgroundBarWidth = 128;
    private static final short minigameBackgroundBarHeight = 24;
    private static final short REEL_BASIC_RANGE = 40;
    private static final short REEL_FAST_RANGE = 75;
    private static final short REEL_LONG_RANGE = 150;
    private static final int MINIGAME_X_START = 20;
    private static final short X_OFFSET = -8;
    private static final short Y_OFFSET = -6;
    private static final int MINIGAME_Y_START = 5;
    private static final int MINIGAME_INNER_LEFT_OFFSET = 3;
    private static final int MINIGAME_INNER_TOP_OFFSET = 3;
    private static final int YMETER_X_START = 8;
    private static final int YMETER_Y_START = 5;
    private static final int YMETER_RANGE_LEFT_OFFSET = 1;
    private static final int YMETER_RANGE_TOP_OFFSET = 1;
    private static final int YMETER_LEVEL_LEFT_OFFSET = -1;
    private static final short MAX_Y_LEVEL = 28;
    private static final int LIGHTLEVEL_X = 57;
    private static final int LIGHTLEVEL_Y = 50;
    public static final Texture TEXTURE_MINIGAME_OUTLINE = new Texture(new ResourceLocation("fishingmadebetter", "textures/gui/reeling_hud_outline.png"), 256, 256);
    public static final Texture TEXTURE_LIQUID_SKY = new Texture(new ResourceLocation("fishingmadebetter", "textures/gui/reeling_hud_underoverlay.png"), 256, 256);
    public static final Texture TEXTURE_BIOME = new Texture(new ResourceLocation("fishingmadebetter", "textures/gui/reeling_hud_biome.png"), 256, 256);
    public static final Texture TEXTURE_DIMENSION_CAVE = new Texture(new ResourceLocation("fishingmadebetter", "textures/gui/reeling_hud_fullsize.png"), 256, 256);
    public static final Texture TEXTURE_OVERLAYS = new Texture(new ResourceLocation("fishingmadebetter", "textures/gui/fish_data_overlays.png"), 256, 256);
    public static final Drawing DRAWING_OUTLINE = new Drawing(0, 0, 134, 30);
    public static final Drawing DRAWING_THE_END = new Drawing(0, 0, 128, 24);
    public static final Drawing DRAWING_NETHER = new Drawing(0, 24, 128, 24);
    public static final List<Drawing> DRAWING_BIOME_LIQUIDS = Arrays.asList(new Drawing(128, FishRequirementData.texturePosFromBiomeTag("WATER") * 24, 128, 24), new Drawing(128, FishRequirementData.texturePosFromBiomeTag("JUNGLE") * 24, 128, 24), new Drawing(128, FishRequirementData.texturePosFromBiomeTag("SANDY") * 24, 128, 24), new Drawing(128, FishRequirementData.texturePosFromBiomeTag("COLD") * 24, 128, 24), new Drawing(128, FishRequirementData.texturePosFromBiomeTag("MOUNTAIN") * 24, 128, 24), new Drawing(128, FishRequirementData.texturePosFromBiomeTag("FOREST") * 24, 128, 24), new Drawing(128, FishRequirementData.texturePosFromBiomeTag("PLAINS") * 24, 128, 24), new Drawing(128, FishRequirementData.texturePosFromBiomeTag("SWAMP") * 24, 128, 24), new Drawing(128, FishRequirementData.texturePosFromBiomeTag("MUSHROOM") * 24, 128, 24), new Drawing(128, FishRequirementData.texturePosFromBiomeTag("DEAD") * 24, 128, 24));
    public static final List<Drawing> DRAWING_BIOME_SURROUNDINGS = Arrays.asList(new Drawing(0, FishRequirementData.texturePosFromBiomeTag("WATER") * 24, 128, 24), new Drawing(0, FishRequirementData.texturePosFromBiomeTag("JUNGLE") * 24, 128, 24), new Drawing(0, FishRequirementData.texturePosFromBiomeTag("SANDY") * 24, 128, 24), new Drawing(0, FishRequirementData.texturePosFromBiomeTag("COLD") * 24, 128, 24), new Drawing(0, FishRequirementData.texturePosFromBiomeTag("MOUNTAIN") * 24, 128, 24), new Drawing(0, FishRequirementData.texturePosFromBiomeTag("FOREST") * 24, 128, 24), new Drawing(0, FishRequirementData.texturePosFromBiomeTag("PLAINS") * 24, 128, 24), new Drawing(0, FishRequirementData.texturePosFromBiomeTag("SWAMP") * 24, 128, 24), new Drawing(0, FishRequirementData.texturePosFromBiomeTag("MUSHROOM") * 24, 128, 24), new Drawing(0, FishRequirementData.texturePosFromBiomeTag("DEAD") * 24, 128, 24));
    public static final Drawing DRAWING_LIQUID_LAVA = new Drawing(0, 24, 128, 24);
    public static final Drawing DRAWING_LIQUID_VOID = new Drawing(0, 48, 128, 24);
    public static final Drawing DRAWING_LIQUID_ANY = new Drawing(128, 24, 128, 24);
    public static final Drawing DRAWING_DAY = new Drawing(0, 72, 128, 24);
    public static final Drawing DRAWING_NIGHT = new Drawing(0, 96, 128, 24);
    public static final Drawing DRAWING_DAY_NIGHT = new Drawing(128, 0, 128, 24);
    public static final Drawing DRAWING_TIMELESS = new Drawing(0, 120, 128, 24);
    public static final Drawing DRAWING_RAIN = new Drawing(0, 0, 128, 24);
    public static final Drawing DRAWING_THUNDERSTORM = new Drawing(0, 24, 128, 24);
    public static final Drawing DRAWING_YMETER_BACKGROUND = new Drawing(0, 49, 7, 30);
    public static final Drawing DRAWING_YMETER_FOREGROUND = new Drawing(8, 49, 7, 30);
    public static final Drawing DRAWING_YRANGE = new Drawing(16, 49, 5, 28);
    public static final Drawing DRAWING_SEA_LEVEL = new Drawing(22, 49, 9, 1);
    public static final Drawing DRAWING_LAVA_LEVEL = new Drawing(22, 51, 9, 1);
    public static final Drawing DRAWING_VOID_LEVEL = new Drawing(22, 53, 9, 1);
    public static final Drawing DRAWING_NIGHT_DARKNESS = new Drawing(0, 144, 128, 24);
    public static final Drawing DRAWING_DAY_NIGHT_DARKNESS = new Drawing(128, 48, 128, 24);

    public FishRequirementsRecipeWrapper(FishData fishData) {
        this.fishRequirementData = new FishRequirementData(fishData);
        ArrayList<ItemStack> fishingRodStackList = new ArrayList<ItemStack>();
        fishingRodStackList.add(new ItemStack((Item)ItemManager.FISHING_ROD_WOOD));
        fishingRodStackList.add(new ItemStack((Item)ItemManager.FISHING_ROD_IRON));
        fishingRodStackList.add(new ItemStack((Item)ItemManager.FISHING_ROD_DIAMOND));
        ArrayList<ItemStack> reelStackList = new ArrayList<ItemStack>();
        if (fishData.minDeepLevel < 40) {
            reelStackList.add(new ItemStack((Item)ItemManager.REEL_BASIC));
        }
        if (fishData.minDeepLevel < 75) {
            reelStackList.add(new ItemStack((Item)ItemManager.REEL_FAST));
        }
        if (fishData.minDeepLevel < 150) {
            reelStackList.add(new ItemStack((Item)ItemManager.REEL_LONG));
        }
        if (reelStackList.isEmpty()) {
            reelStackList.add(new ItemStack(Items.field_190931_a));
        }
        ArrayList<ItemStack> bobberStackList = new ArrayList<ItemStack>();
        if (fishData.liquid == FishData.FishingLiquid.LAVA) {
            bobberStackList.add(new ItemStack((Item)ItemManager.BOBBER_OBSIDIAN));
        } else if (fishData.liquid == FishData.FishingLiquid.VOID) {
            bobberStackList.add(new ItemStack((Item)ItemManager.BOBBER_VOID));
        } else if (fishData.liquid == FishData.FishingLiquid.ANY) {
            bobberStackList.add(new ItemStack((Item)ItemManager.BOBBER_BASIC));
            bobberStackList.add(new ItemStack((Item)ItemManager.BOBBER_HEAVY));
            bobberStackList.add(new ItemStack((Item)ItemManager.BOBBER_LIGHTWEIGHT));
            bobberStackList.add(new ItemStack((Item)ItemManager.BOBBER_OBSIDIAN));
            bobberStackList.add(new ItemStack((Item)ItemManager.BOBBER_VOID));
        } else {
            bobberStackList.add(new ItemStack((Item)ItemManager.BOBBER_BASIC));
            bobberStackList.add(new ItemStack((Item)ItemManager.BOBBER_HEAVY));
            bobberStackList.add(new ItemStack((Item)ItemManager.BOBBER_LIGHTWEIGHT));
        }
        this.inputs.add(fishingRodStackList);
        this.inputs.add(reelStackList);
        this.inputs.add(bobberStackList);
        Item baitBucketItem = Item.func_111206_d((String)"fishingmadebetter:bait_bucket");
        if (baitBucketItem == null) {
            baitBucketItem = Items.field_190931_a;
        }
        this.inputs.add(Collections.singletonList(new ItemStack(baitBucketItem)));
        for (String baitName : fishData.baitItemMap.keySet()) {
            Integer[] integerArray = (Integer[])fishData.baitItemMap.get(baitName);
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int baitMetadata = integerArray[i];
                Item bait = Item.func_111206_d((String)baitName);
                if (bait == null) continue;
                this.inputs.add(Collections.singletonList(new ItemStack(bait, 1, baitMetadata)));
            }
        }
        while (this.inputs.size() < 20) {
            this.inputs.add(Collections.singletonList(new ItemStack(Items.field_190931_a)));
        }
        this.output = FMB_BetterFishUtil.fishIdToItemStack(fishData.fishId);
        for (Integer dimension : this.fishRequirementData.dimensionList) {
            if (dimension == -1) {
                this.overlayList.add(new BiomeDimensionOverlay(this.fishRequirementData, dimension, null));
                this.biomeTypeList.add("NETHER");
                continue;
            }
            if (dimension == 1) {
                this.overlayList.add(new BiomeDimensionOverlay(this.fishRequirementData, dimension, null));
                this.biomeTypeList.add("END");
                continue;
            }
            for (String biome : this.fishRequirementData.biomeTagList) {
                this.overlayList.add(new BiomeDimensionOverlay(this.fishRequirementData, dimension, biome));
                this.biomeTypeList.add(biome);
            }
        }
        if (this.overlayList.isEmpty()) {
            this.overlayList.add(new BiomeDimensionOverlay(this.fishRequirementData.minYLevel, this.fishRequirementData.maxYLevel));
            this.biomeTypeList.add("UNKNOWN");
        }
        if (this.fishRequirementData.maxLightLevel < 0) {
            this.lightLevelIcon = new DrawableResource(new ResourceLocation("minecraft", "textures/items/barrier.png"), 0, 0, 16, 16, 0, 0, 0, 0, 16, 16);
            this.photometerIcon = new DrawableResource(new ResourceLocation("minecraft", "textures/items/barrier.png"), 0, 0, 16, 16, 0, 0, 0, 0, 16, 16);
        } else {
            this.lightLevelIcon = new DrawableResource(new ResourceLocation("minecraft", "textures/light/" + String.format("%02d", Math.min(this.fishRequirementData.maxLightLevel, 15)) + ".png"), 0, 0, 16, 16, 0, 0, 0, 0, 16, 16);
            this.photometerIcon = Loader.isModLoaded((String)"inspirations") ? new DrawableResource(new ResourceLocation("inspirations", "textures/items/photometer/" + String.format("%02d", Math.min(this.fishRequirementData.maxLightLevel, 15)) + ".png"), 0, 0, 16, 16, 0, 0, 0, 0, 16, 16) : new DrawableResource(new ResourceLocation("minecraft", "textures/light/" + String.format("%02d", Math.min(this.fishRequirementData.maxLightLevel, 15)) + ".png"), 0, 0, 16, 16, 0, 0, 0, 0, 16, 16);
        }
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (mouseX >= 8 && mouseX < 8 + FishRequirementsRecipeWrapper.DRAWING_YMETER_BACKGROUND.width && mouseY >= 5 && mouseY < 5 + FishRequirementsRecipeWrapper.DRAWING_YMETER_BACKGROUND.height) {
            tooltip.add(TextFormatting.GRAY + "Y: " + TextFormatting.WHITE + this.fishRequirementData.minYLevel + TextFormatting.GRAY + " - " + TextFormatting.WHITE + this.fishRequirementData.maxYLevel);
            return tooltip;
        }
        if (mouseX >= 20 && mouseX < 20 + FishRequirementsRecipeWrapper.DRAWING_OUTLINE.width && mouseY >= 5 && mouseY < 5 + FishRequirementsRecipeWrapper.DRAWING_OUTLINE.height) {
            tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"jei.fishingmadebetter.category.fish_requirements.minigame.title", (Object[])new Object[0]));
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"jei.fishingmadebetter.category.fish_requirements.minigame.biometype", (Object[])new Object[]{TextFormatting.WHITE + I18n.func_135052_a((String)("biometype." + this.biomeTypeList.get(this.biomeDisplay / 20)), (Object[])new Object[0])}));
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"jei.fishingmadebetter.category.fish_requirements.minigame.time.tooltip", (Object[])new Object[]{TextFormatting.WHITE + I18n.func_135052_a((String)("notif.fishingmadebetter.fish_tracker.creative.time." + this.fishRequirementData.timeToFish), (Object[])new Object[0])}));
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"jei.fishingmadebetter.category.fish_requirements.minigame.rain.tooltip", (Object[])new Object[]{TextFormatting.WHITE + I18n.func_135052_a((String)("notif.fishingmadebetter.fish_tracker.creative.rain." + this.fishRequirementData.rainRequired), (Object[])new Object[0])}));
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"jei.fishingmadebetter.category.fish_requirements.minigame.thunder.tooltip", (Object[])new Object[]{TextFormatting.WHITE + I18n.func_135052_a((String)("notif.fishingmadebetter.fish_tracker.creative.thunder." + this.fishRequirementData.thunderRequired), (Object[])new Object[0])}));
            return tooltip;
        }
        if (mouseX >= 57 && mouseX < 75 && mouseY >= 50 && mouseY < 68) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"jei.fishingmadebetter.category.fish_requirements.minigame.light.tooltip", (Object[])new Object[]{TextFormatting.WHITE + "0" + TextFormatting.GRAY + " - " + TextFormatting.WHITE + this.fishRequirementData.maxLightLevel}));
            return tooltip;
        }
        return Collections.emptyList();
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return new ResourceLocation(this.fishRequirementData.fishId.toLowerCase(Locale.ENGLISH).replace(" ", "_") + "_requirements");
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.biomeDisplay = minecraft.field_71439_g.field_70173_aa % (this.overlayList.size() * 20);
        this.beginRenderingTransparency();
        this.overlayList.get(this.biomeDisplay / 20).drawMiniGame(minecraft, 20, 5);
        this.overlayList.get(this.biomeDisplay / 20).drawYmeter(minecraft, 8, 5);
        if (ForgeConfigHandler.clientConfig.fishingmadebetterPhotometer) {
            this.photometerIcon.draw(minecraft, 57, 50);
        } else {
            this.lightLevelIcon.draw(minecraft, 57, 50);
        }
        this.finishRenderingTransparency();
    }

    private void beginRenderingTransparency() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
    }

    private void finishRenderingTransparency() {
        GlStateManager.func_179121_F();
    }

    public static class BiomeDimensionOverlay {
        public DrawableResource[] minigameInner = new DrawableResource[6];
        public DrawableResource minigameBorder;
        public DrawableResource[] yMeter = new DrawableResource[4];

        public BiomeDimensionOverlay(int minYLevelIn, int maxYLevelIn) {
            int minYLevel = Math.max(minYLevelIn, 0);
            int maxYLevel = Math.min(maxYLevelIn, 140);
            if (minYLevel >= maxYLevel) {
                minYLevel = maxYLevel;
            }
            this.minigameBorder = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_MINIGAME_OUTLINE.texture, FishRequirementsRecipeWrapper.DRAWING_OUTLINE.u, FishRequirementsRecipeWrapper.DRAWING_OUTLINE.v, FishRequirementsRecipeWrapper.DRAWING_OUTLINE.width, FishRequirementsRecipeWrapper.DRAWING_OUTLINE.height, 0, 0, 0, 0, FishRequirementsRecipeWrapper.TEXTURE_MINIGAME_OUTLINE.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_MINIGAME_OUTLINE.textureHeight);
            this.yMeter[0] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.texture, FishRequirementsRecipeWrapper.DRAWING_YMETER_BACKGROUND.u, FishRequirementsRecipeWrapper.DRAWING_YMETER_BACKGROUND.v, FishRequirementsRecipeWrapper.DRAWING_YMETER_BACKGROUND.width, FishRequirementsRecipeWrapper.DRAWING_YMETER_BACKGROUND.height, 0, 0, 0, 0, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureHeight);
            this.yMeter[1] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.texture, FishRequirementsRecipeWrapper.DRAWING_YRANGE.u, FishRequirementsRecipeWrapper.DRAWING_YRANGE.v + (28 - maxYLevel / 5), FishRequirementsRecipeWrapper.DRAWING_YRANGE.width, maxYLevel / 5 - minYLevel / 5 + 1, 1 + (28 - maxYLevel / 5), 0, 1, 0, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureHeight);
            this.yMeter[2] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.texture, FishRequirementsRecipeWrapper.DRAWING_YMETER_FOREGROUND.u, FishRequirementsRecipeWrapper.DRAWING_YMETER_FOREGROUND.v, FishRequirementsRecipeWrapper.DRAWING_YMETER_FOREGROUND.width, FishRequirementsRecipeWrapper.DRAWING_YMETER_FOREGROUND.height, 0, 0, 0, 0, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureHeight);
            this.yMeter[3] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.texture, FishRequirementsRecipeWrapper.DRAWING_SEA_LEVEL.u, FishRequirementsRecipeWrapper.DRAWING_SEA_LEVEL.v, FishRequirementsRecipeWrapper.DRAWING_SEA_LEVEL.width, FishRequirementsRecipeWrapper.DRAWING_SEA_LEVEL.height, 1 + (28 - ForgeConfigHandler.clientConfig.fishingmadebetterYmeterSeaLevel / 5), 0, -1, 0, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureHeight);
            this.minigameInner[0] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.u, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.v, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.width, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
            this.minigameInner[1] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.u, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.v, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.width, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
            this.minigameInner[2] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.u, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.v, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.width, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
            this.minigameInner[3] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.u, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.v, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.width, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
            this.minigameInner[4] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.u, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.v, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.width, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
            this.minigameInner[5] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.u, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.v, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.width, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
        }

        public BiomeDimensionOverlay(FishRequirementData fishRequirementData, int dimension, String biomeTag) {
            int minYLevel = Math.max(fishRequirementData.minYLevel, 0);
            int maxYLevel = Math.min(fishRequirementData.maxYLevel, 140);
            if (minYLevel >= maxYLevel) {
                minYLevel = maxYLevel;
            }
            this.minigameBorder = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_MINIGAME_OUTLINE.texture, FishRequirementsRecipeWrapper.DRAWING_OUTLINE.u, FishRequirementsRecipeWrapper.DRAWING_OUTLINE.v, FishRequirementsRecipeWrapper.DRAWING_OUTLINE.width, FishRequirementsRecipeWrapper.DRAWING_OUTLINE.height, 0, 0, 0, 0, FishRequirementsRecipeWrapper.TEXTURE_MINIGAME_OUTLINE.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_MINIGAME_OUTLINE.textureHeight);
            this.yMeter[0] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.texture, FishRequirementsRecipeWrapper.DRAWING_YMETER_BACKGROUND.u, FishRequirementsRecipeWrapper.DRAWING_YMETER_BACKGROUND.v, FishRequirementsRecipeWrapper.DRAWING_YMETER_BACKGROUND.width, FishRequirementsRecipeWrapper.DRAWING_YMETER_BACKGROUND.height, 0, 0, 0, 0, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureHeight);
            this.yMeter[1] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.texture, FishRequirementsRecipeWrapper.DRAWING_YRANGE.u, FishRequirementsRecipeWrapper.DRAWING_YRANGE.v + (28 - maxYLevel / 5), FishRequirementsRecipeWrapper.DRAWING_YRANGE.width, maxYLevel / 5 - minYLevel / 5 + 1, 1 + (28 - maxYLevel / 5), 0, 1, 0, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureHeight);
            this.yMeter[2] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.texture, FishRequirementsRecipeWrapper.DRAWING_YMETER_FOREGROUND.u, FishRequirementsRecipeWrapper.DRAWING_YMETER_FOREGROUND.v, FishRequirementsRecipeWrapper.DRAWING_YMETER_FOREGROUND.width, FishRequirementsRecipeWrapper.DRAWING_YMETER_FOREGROUND.height, 0, 0, 0, 0, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureHeight);
            switch (dimension) {
                case -1: {
                    this.minigameInner[0] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_LIQUID_LAVA.u, FishRequirementsRecipeWrapper.DRAWING_LIQUID_LAVA.v, FishRequirementsRecipeWrapper.DRAWING_LIQUID_LAVA.width, FishRequirementsRecipeWrapper.DRAWING_LIQUID_LAVA.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                    this.minigameInner[1] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.u, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.v, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.width, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                    this.minigameInner[2] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_DIMENSION_CAVE.texture, FishRequirementsRecipeWrapper.DRAWING_NETHER.u, FishRequirementsRecipeWrapper.DRAWING_NETHER.v, FishRequirementsRecipeWrapper.DRAWING_NETHER.width, FishRequirementsRecipeWrapper.DRAWING_NETHER.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_DIMENSION_CAVE.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_DIMENSION_CAVE.textureHeight);
                    this.minigameInner[3] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.u, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.v, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.width, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                    this.minigameInner[4] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.u, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.v, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.width, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                    this.minigameInner[5] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.u, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.v, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.width, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                    this.yMeter[3] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.texture, FishRequirementsRecipeWrapper.DRAWING_LAVA_LEVEL.u, FishRequirementsRecipeWrapper.DRAWING_LAVA_LEVEL.v, FishRequirementsRecipeWrapper.DRAWING_LAVA_LEVEL.width, FishRequirementsRecipeWrapper.DRAWING_LAVA_LEVEL.height, 1 + (28 - ForgeConfigHandler.clientConfig.fishingmadebetterYmeterLavaLevel / 5), 0, -1, 0, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureHeight);
                    break;
                }
                case 1: {
                    this.minigameInner[0] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_LIQUID_VOID.u, FishRequirementsRecipeWrapper.DRAWING_LIQUID_VOID.v, FishRequirementsRecipeWrapper.DRAWING_LIQUID_VOID.width, FishRequirementsRecipeWrapper.DRAWING_LIQUID_VOID.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                    this.minigameInner[1] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.u, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.v, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.width, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                    this.minigameInner[2] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_DIMENSION_CAVE.texture, FishRequirementsRecipeWrapper.DRAWING_THE_END.u, FishRequirementsRecipeWrapper.DRAWING_THE_END.v, FishRequirementsRecipeWrapper.DRAWING_THE_END.width, FishRequirementsRecipeWrapper.DRAWING_THE_END.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_DIMENSION_CAVE.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_DIMENSION_CAVE.textureHeight);
                    this.minigameInner[3] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.u, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.v, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.width, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                    this.minigameInner[4] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.u, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.v, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.width, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                    this.minigameInner[5] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.u, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.v, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.width, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                    this.yMeter[3] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.texture, FishRequirementsRecipeWrapper.DRAWING_VOID_LEVEL.u, FishRequirementsRecipeWrapper.DRAWING_VOID_LEVEL.v, FishRequirementsRecipeWrapper.DRAWING_VOID_LEVEL.width, FishRequirementsRecipeWrapper.DRAWING_VOID_LEVEL.height, 1 + (28 - ForgeConfigHandler.clientConfig.fishingmadebetterYmeterVoidLevel / 5), 0, -1, 0, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureHeight);
                    break;
                }
                default: {
                    switch (fishRequirementData.liquid) {
                        case LAVA: {
                            this.minigameInner[0] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_LIQUID_LAVA.u, FishRequirementsRecipeWrapper.DRAWING_LIQUID_LAVA.v, FishRequirementsRecipeWrapper.DRAWING_LIQUID_LAVA.width, FishRequirementsRecipeWrapper.DRAWING_LIQUID_LAVA.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                            break;
                        }
                        case VOID: {
                            this.minigameInner[0] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_LIQUID_VOID.u, FishRequirementsRecipeWrapper.DRAWING_LIQUID_VOID.v, FishRequirementsRecipeWrapper.DRAWING_LIQUID_VOID.width, FishRequirementsRecipeWrapper.DRAWING_LIQUID_VOID.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                            break;
                        }
                        case ANY: {
                            this.minigameInner[0] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.texture, FishRequirementsRecipeWrapper.DRAWING_LIQUID_ANY.u, FishRequirementsRecipeWrapper.DRAWING_LIQUID_ANY.v, FishRequirementsRecipeWrapper.DRAWING_LIQUID_ANY.width, FishRequirementsRecipeWrapper.DRAWING_LIQUID_ANY.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureHeight);
                            break;
                        }
                        default: {
                            this.minigameInner[0] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_BIOME_LIQUIDS.get((int)FishRequirementData.texturePosFromBiomeTag((String)biomeTag)).u, FishRequirementsRecipeWrapper.DRAWING_BIOME_LIQUIDS.get((int)FishRequirementData.texturePosFromBiomeTag((String)biomeTag)).v, FishRequirementsRecipeWrapper.DRAWING_BIOME_LIQUIDS.get((int)FishRequirementData.texturePosFromBiomeTag((String)biomeTag)).width, FishRequirementsRecipeWrapper.DRAWING_BIOME_LIQUIDS.get((int)FishRequirementData.texturePosFromBiomeTag((String)biomeTag)).height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                        }
                    }
                    switch (fishRequirementData.timeToFish) {
                        case NIGHT: {
                            this.minigameInner[1] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_NIGHT.u, FishRequirementsRecipeWrapper.DRAWING_NIGHT.v, FishRequirementsRecipeWrapper.DRAWING_NIGHT.width, FishRequirementsRecipeWrapper.DRAWING_NIGHT.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                            this.minigameInner[3] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.u, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.v, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.width, FishRequirementsRecipeWrapper.DRAWING_NIGHT_DARKNESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                            break;
                        }
                        case ANY: {
                            this.minigameInner[1] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.texture, FishRequirementsRecipeWrapper.DRAWING_DAY_NIGHT.u, FishRequirementsRecipeWrapper.DRAWING_DAY_NIGHT.v, FishRequirementsRecipeWrapper.DRAWING_DAY_NIGHT.width, FishRequirementsRecipeWrapper.DRAWING_DAY_NIGHT.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureHeight);
                            this.minigameInner[3] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.texture, FishRequirementsRecipeWrapper.DRAWING_DAY_NIGHT_DARKNESS.u, FishRequirementsRecipeWrapper.DRAWING_DAY_NIGHT_DARKNESS.v, FishRequirementsRecipeWrapper.DRAWING_DAY_NIGHT_DARKNESS.width, FishRequirementsRecipeWrapper.DRAWING_DAY_NIGHT_DARKNESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureHeight);
                            break;
                        }
                        default: {
                            this.minigameInner[1] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_DAY.u, FishRequirementsRecipeWrapper.DRAWING_DAY.v, FishRequirementsRecipeWrapper.DRAWING_DAY.width, FishRequirementsRecipeWrapper.DRAWING_DAY.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                            this.minigameInner[3] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.u, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.v, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.width, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                        }
                    }
                    this.minigameInner[2] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_BIOME.texture, FishRequirementsRecipeWrapper.DRAWING_BIOME_SURROUNDINGS.get((int)FishRequirementData.texturePosFromBiomeTag((String)biomeTag)).u, FishRequirementsRecipeWrapper.DRAWING_BIOME_SURROUNDINGS.get((int)FishRequirementData.texturePosFromBiomeTag((String)biomeTag)).v, FishRequirementsRecipeWrapper.DRAWING_BIOME_SURROUNDINGS.get((int)FishRequirementData.texturePosFromBiomeTag((String)biomeTag)).width, FishRequirementsRecipeWrapper.DRAWING_BIOME_SURROUNDINGS.get((int)FishRequirementData.texturePosFromBiomeTag((String)biomeTag)).height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_BIOME.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_BIOME.textureHeight);
                    this.minigameInner[4] = fishRequirementData.rainRequired ? new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.texture, FishRequirementsRecipeWrapper.DRAWING_RAIN.u, FishRequirementsRecipeWrapper.DRAWING_RAIN.v, FishRequirementsRecipeWrapper.DRAWING_RAIN.width, FishRequirementsRecipeWrapper.DRAWING_RAIN.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureHeight) : new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.u, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.v, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.width, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                    this.minigameInner[5] = fishRequirementData.thunderRequired ? new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.texture, FishRequirementsRecipeWrapper.DRAWING_THUNDERSTORM.u, FishRequirementsRecipeWrapper.DRAWING_THUNDERSTORM.v, FishRequirementsRecipeWrapper.DRAWING_THUNDERSTORM.width, FishRequirementsRecipeWrapper.DRAWING_THUNDERSTORM.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureHeight) : new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.texture, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.u, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.v, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.width, FishRequirementsRecipeWrapper.DRAWING_TIMELESS.height, 3, 0, 3, 0, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_LIQUID_SKY.textureHeight);
                    this.yMeter[3] = new DrawableResource(FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.texture, FishRequirementsRecipeWrapper.DRAWING_SEA_LEVEL.u, FishRequirementsRecipeWrapper.DRAWING_SEA_LEVEL.v, FishRequirementsRecipeWrapper.DRAWING_SEA_LEVEL.width, FishRequirementsRecipeWrapper.DRAWING_SEA_LEVEL.height, 1 + (28 - ForgeConfigHandler.clientConfig.fishingmadebetterYmeterSeaLevel / 5), 0, -1, 0, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureWidth, FishRequirementsRecipeWrapper.TEXTURE_OVERLAYS.textureHeight);
                }
            }
        }

        public void drawMiniGame(Minecraft minecraft, int x, int y) {
            this.minigameInner[0].draw(minecraft, x, y);
            this.minigameInner[1].draw(minecraft, x, y);
            this.minigameInner[2].draw(minecraft, x, y);
            this.minigameInner[3].draw(minecraft, x, y);
            this.minigameInner[4].draw(minecraft, x, y);
            this.minigameInner[5].draw(minecraft, x, y);
            this.minigameBorder.draw(minecraft, x, y);
        }

        public void drawYmeter(Minecraft minecraft, int x, int y) {
            this.yMeter[0].draw(minecraft, x, y);
            this.yMeter[1].draw(minecraft, x, y);
            this.yMeter[2].draw(minecraft, x, y);
            this.yMeter[3].draw(minecraft, x, y);
        }
    }
}

