/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.client.event;

import javax.annotation.Nonnull;
import joptsimple.internal.Strings;
import kameib.localizator.Localizator;
import kameib.localizator.client.jei.fishingmadebetter.FMBJeiPlugin;
import kameib.localizator.common.text.event.FishRequirementsClickEvent;
import kameib.localizator.util.FMB_BetterFishUtil;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IRecipesGui;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.theawesomegem.fishingmadebetter.common.configuration.CustomConfigurationHandler;
import org.lwjgl.input.Mouse;

@Mod.EventBusSubscriber
public class FishRequirementsOnClickEvent {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="fishingmadebetter")
    public void onChatGuiClick(GuiScreenEvent.MouseInputEvent event) {
        FishRequirementsClickEvent FRClickEvent;
        if (event.isCanceled()) {
            return;
        }
        if (!(event.getGui() instanceof GuiChat)) {
            return;
        }
        if (!Mouse.isButtonDown((int)0)) {
            return;
        }
        GuiNewChat guiChatGUI = event.getGui().field_146297_k.field_71456_v.func_146158_b();
        ITextComponent chatMessage = guiChatGUI.func_146236_a(Mouse.getEventX(), Mouse.getEventY());
        if (chatMessage == null) {
            return;
        }
        Style style = chatMessage.func_150256_b();
        if (style.func_150229_g()) {
            return;
        }
        if (style.func_150235_h() == null) {
            return;
        }
        ClickEvent clickEvent = style.func_150235_h();
        if (!(clickEvent instanceof FishRequirementsClickEvent)) {
            if (clickEvent.func_150669_a() == ClickEvent.Action.SUGGEST_COMMAND && !Strings.isNullOrEmpty((String)clickEvent.func_150668_b()) && clickEvent.func_150668_b().startsWith(FishRequirementsClickEvent.Action.FISH_REQUIREMENTS.getCanonicalName())) {
                String fishId = clickEvent.func_150668_b().replace(FishRequirementsClickEvent.Action.FISH_REQUIREMENTS.getCanonicalName() + " ", "");
                if (Strings.isNullOrEmpty((String)fishId)) {
                    return;
                }
                clickEvent = new FishRequirementsClickEvent(FishRequirementsClickEvent.Action.FISH_REQUIREMENTS, fishId);
            } else {
                return;
            }
        }
        if ((FRClickEvent = (FishRequirementsClickEvent)clickEvent).getFishRequirementsAction() != FishRequirementsClickEvent.Action.FISH_REQUIREMENTS) {
            return;
        }
        String fishId = FRClickEvent.getfishId();
        if (!CustomConfigurationHandler.fishDataMap.containsKey(fishId)) {
            return;
        }
        ItemStack fishStack = FMB_BetterFishUtil.fishIdToItemStack(fishId);
        if (fishStack != null && !fishStack.func_190926_b() && Loader.isModLoaded((String)"jei")) {
            this.openJEIRecipesGUI(fishStack);
        }
        event.setCanceled(true);
    }

    @Optional.Method(modid="jei")
    private void openJEIRecipesGUI(final ItemStack fishStack) {
        IJeiRuntime jeiRuntime = FMBJeiPlugin.getJeiRuntime();
        if (jeiRuntime == null) {
            return;
        }
        IRecipesGui recipesGui = jeiRuntime.getRecipesGui();
        IFocus<ItemStack> focus = new IFocus<ItemStack>(){

            @Nonnull
            public ItemStack getValue() {
                return fishStack;
            }

            @Nonnull
            public IFocus.Mode getMode() {
                return IFocus.Mode.OUTPUT;
            }
        };
        try {
            recipesGui.show((IFocus)focus);
        }
        catch (Exception e) {
            Localizator.LOGGER.error("Error showing {} recipe in JEI", (Object)fishStack.func_82833_r(), (Object)e);
        }
    }
}

