/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.models.data;

import ivorius.ivtoolkit.models.data.IndexData;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import net.minecraft.client.renderer.GLAllocation;
import org.lwjgl.opengl.GL15;

public class IndexBufferObject
implements IndexData {
    ShortBuffer buffer;
    ByteBuffer byteBuffer;
    int bufferHandle;
    final boolean isDirect;
    boolean isDirty = true;
    boolean isBound = false;
    final int usage;

    public IndexBufferObject(boolean isStatic, int maxIndices) {
        this.byteBuffer = GLAllocation.func_74524_c((int)(maxIndices * 2));
        this.isDirect = true;
        this.buffer = this.byteBuffer.asShortBuffer();
        this.buffer.flip();
        this.byteBuffer.flip();
        this.bufferHandle = this.createBufferObject();
        this.usage = isStatic ? 35044 : 35048;
    }

    public IndexBufferObject(int maxIndices) {
        this.byteBuffer = GLAllocation.func_74524_c((int)(maxIndices * 2));
        this.isDirect = true;
        this.buffer = this.byteBuffer.asShortBuffer();
        this.buffer.flip();
        this.byteBuffer.flip();
        this.bufferHandle = this.createBufferObject();
        this.usage = 35044;
    }

    private int createBufferObject() {
        return GL15.glGenBuffers();
    }

    @Override
    public int getNumIndices() {
        return this.buffer.limit();
    }

    @Override
    public int getNumMaxIndices() {
        return this.buffer.capacity();
    }

    @Override
    public void setIndices(short[] indices, int offset, int count) {
        this.isDirty = true;
        this.buffer.clear();
        this.buffer.put(indices, offset, count);
        this.buffer.flip();
        this.byteBuffer.position(0);
        this.byteBuffer.limit(count << 1);
        if (this.isBound) {
            GL15.glBufferData((int)34963, (ByteBuffer)this.byteBuffer, (int)this.usage);
            this.isDirty = false;
        }
    }

    @Override
    public ShortBuffer getBuffer() {
        this.isDirty = true;
        return this.buffer;
    }

    @Override
    public void bind() {
        if (this.bufferHandle == 0) {
            throw new RuntimeException("No buffer allocated!");
        }
        GL15.glBindBuffer((int)34963, (int)this.bufferHandle);
        if (this.isDirty) {
            this.byteBuffer.limit(this.buffer.limit() * 2);
            GL15.glBufferData((int)34963, (ByteBuffer)this.byteBuffer, (int)this.usage);
            this.isDirty = false;
        }
        this.isBound = true;
    }

    @Override
    public void unbind() {
        GL15.glBindBuffer((int)34963, (int)0);
        this.isBound = false;
    }

    @Override
    public void invalidate() {
        this.bufferHandle = this.createBufferObject();
        this.isDirty = true;
    }

    @Override
    public void dispose() {
        GL15.glBindBuffer((int)34963, (int)0);
        if (this.bufferHandle > 0) {
            GL15.glDeleteBuffers((int)this.bufferHandle);
        }
        this.bufferHandle = 0;
    }
}

