/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.models;

import java.util.ArrayList;
import java.util.List;

public abstract class Attribute {
    private static final List<String> types = new ArrayList<String>();
    public final long type;
    private final int typeBit;

    public static final long getAttributeType(String alias) {
        for (int i = 0; i < types.size(); ++i) {
            if (types.get(i).compareTo(alias) != 0) continue;
            return 1L << i;
        }
        return 0L;
    }

    public static final String getAttributeAlias(long type) {
        int idx = -1;
        while (type != 0L && ++idx < 63 && (type >> idx & 1L) == 0L) {
        }
        return idx >= 0 && idx < types.size() ? types.get(idx) : null;
    }

    protected static final long register(String alias) {
        long result = Attribute.getAttributeType(alias);
        if (result > 0L) {
            return result;
        }
        types.add(alias);
        return 1L << types.size() - 1;
    }

    protected Attribute(long type) {
        this.type = type;
        this.typeBit = Long.numberOfTrailingZeros(type);
    }

    public abstract Attribute copy();

    protected boolean equals(Attribute other) {
        return other.hashCode() == this.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)obj;
        if (this.type != other.type) {
            return false;
        }
        return this.equals(other);
    }

    public String toString() {
        return Attribute.getAttributeAlias(this.type);
    }

    public int hashCode() {
        return 7489 * this.typeBit;
    }
}

