/*
 * Decompiled with CFR 0.152.
 */
package bqtweaker.client.gui;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.storage.IQuestSettings;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.SimpleTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.GuiQuestLines;
import betterquesting.client.gui2.GuiThemes;
import betterquesting.client.gui2.editors.nbt.GuiNbtEditor;
import betterquesting.client.gui2.party.GuiPartyCreate;
import betterquesting.client.gui2.party.GuiPartyManage;
import betterquesting.client.gui3.GuiStatus;
import betterquesting.handlers.ConfigHandler;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.handlers.NetChapterSync;
import betterquesting.network.handlers.NetQuestSync;
import betterquesting.network.handlers.NetSettingSync;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.QuestSettings;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector4f;

@SideOnly(value=Side.CLIENT)
public class GuiHomeOverride
extends GuiScreenCanvas {
    public static GuiScreen bookmark;

    public GuiHomeOverride(GuiScreen parent) {
        super(parent);
    }

    public void initPanel() {
        PanelButton tstBtn;
        super.initPanel();
        PEventBroadcaster.INSTANCE.register(this::onButtonPress, PEventButton.class);
        ResourceLocation homeGui = new ResourceLocation((String)QuestSettings.INSTANCE.getProperty(NativeProps.HOME_IMAGE));
        SimpleTexture homeSplashBG = new SimpleTexture(homeGui, (IGuiRect)new GuiRectangle(0, 0, 256, 128));
        SimpleTexture homeSplashTitle = new SimpleTexture(homeGui, (IGuiRect)new GuiRectangle(0, 128, 256, 128)).maintainAspect(true);
        float ancX = ((Float)QuestSettings.INSTANCE.getProperty(NativeProps.HOME_ANC_X)).floatValue();
        float ancY = ((Float)QuestSettings.INSTANCE.getProperty(NativeProps.HOME_ANC_Y)).floatValue();
        int offX = (Integer)QuestSettings.INSTANCE.getProperty(NativeProps.HOME_OFF_X);
        int offY = (Integer)QuestSettings.INSTANCE.getProperty(NativeProps.HOME_OFF_Y);
        CanvasTextured bgCan = new CanvasTextured((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel((IGuiPanel)bgCan);
        CanvasEmpty inCan = new CanvasEmpty((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(16, 16, 16, 16), 0));
        bgCan.addPanel((IGuiPanel)inCan);
        CanvasTextured splashCan = new CanvasTextured((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 32), 0), (IGuiTexture)homeSplashBG);
        inCan.addPanel((IGuiPanel)splashCan);
        CanvasTextured splashTitle = new CanvasTextured((IGuiRect)new GuiTransform(new Vector4f(ancX, ancY, ancX, ancY), new GuiPadding(offX, offY, -256 - offX, -128 - offY), 0), (IGuiTexture)homeSplashTitle);
        splashCan.addPanel((IGuiPanel)splashTitle);
        PanelButton btnExit = new PanelButton((IGuiRect)new GuiTransform(new Vector4f(0.0f, 1.0f, 0.25f, 1.0f), new GuiPadding(0, -32, 0, 0), 0), 0, QuestTranslation.translate((String)"betterquesting.home.exit", (Object[])new Object[0]));
        inCan.addPanel((IGuiPanel)btnExit);
        PanelButton btnQuests = new PanelButton((IGuiRect)new GuiTransform(new Vector4f(0.25f, 1.0f, 0.5f, 1.0f), new GuiPadding(0, -32, 0, 0), 0), 1, QuestTranslation.translate((String)"betterquesting.home.quests", (Object[])new Object[0]));
        inCan.addPanel((IGuiPanel)btnQuests);
        PanelButton btnParty = new PanelButton((IGuiRect)new GuiTransform(new Vector4f(0.5f, 1.0f, 0.75f, 1.0f), new GuiPadding(0, -32, 0, 0), 0), 2, QuestTranslation.translate((String)"betterquesting.home.party", (Object[])new Object[0]));
        btnParty.setActive(((Boolean)QuestSettings.INSTANCE.getProperty(NativeProps.PARTY_ENABLE)).booleanValue());
        inCan.addPanel((IGuiPanel)btnParty);
        PanelButton btnTheme = new PanelButton((IGuiRect)new GuiTransform(new Vector4f(0.75f, 1.0f, 1.0f, 1.0f), new GuiPadding(0, -32, 0, 0), 0), 3, QuestTranslation.translate((String)"betterquesting.home.theme", (Object[])new Object[0]));
        inCan.addPanel((IGuiPanel)btnTheme);
        if (bqtweaker.handlers.ConfigHandler.client.bqNotifEnabled) {
            PanelButton btnNotif = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_RIGHT, -140, -52, 136, 16, 0), 420, BQ_Settings.questNotices ? QuestTranslation.translate((String)"bqtweaker.notification.enabled", (Object[])new Object[0]) : QuestTranslation.translate((String)"bqtweaker.notification.disabled", (Object[])new Object[0])){

                public void onButtonClick() {
                    boolean bl = BQ_Settings.questNotices = !BQ_Settings.questNotices;
                    if (ConfigHandler.config != null) {
                        ConfigHandler.config.get("general", "Quest Notices", true).set(BQ_Settings.questNotices);
                        ConfigHandler.config.save();
                    }
                    this.setText(BQ_Settings.questNotices ? QuestTranslation.translate((String)"bqtweaker.notification.enabled", (Object[])new Object[0]) : QuestTranslation.translate((String)"bqtweaker.notification.disabled", (Object[])new Object[0]));
                }
            };
            btnNotif.setTooltip(Collections.singletonList(QuestTranslation.translate((String)"bqtweaker.notification.tooltip", (Object[])new Object[0])));
            inCan.addPanel((IGuiPanel)btnNotif);
        }
        if (((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g)) {
            PanelButton btnEdit = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, new GuiPadding(0, 0, -16, -16), 0), 4, "").setIcon(PresetIcon.ICON_GEAR.getTexture());
            inCan.addPanel((IGuiPanel)btnEdit);
        }
        if (Minecraft.func_71410_x().func_71387_A() && SaveLoadHandler.INSTANCE.hasUpdate()) {
            tstBtn = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.TOP_RIGHT, -16, 0, 16, 16, 0), 5, "");
            tstBtn.setIcon(PresetIcon.ICON_NOTICE.getTexture(), PresetColor.UPDATE_NOTICE.getColor(), 0);
            tstBtn.setTooltip(Collections.singletonList(QuestTranslation.translateTrimmed((String)"betterquesting.tooltip.update_quests", (Object[])new Object[]{true})));
            inCan.addPanel((IGuiPanel)tstBtn);
        }
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            tstBtn = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, 0, 16, 16, 16, 0), -2, "?"){

                public void onButtonClick() {
                    GuiHomeOverride.this.field_146297_k.func_147108_a((GuiScreen)new GuiStatus((GuiScreen)GuiHomeOverride.this));
                }
            };
            inCan.addPanel((IGuiPanel)tstBtn);
        }
    }

    private void onButtonPress(PanelEvent event) {
        File qFile;
        if (!(event instanceof PEventButton)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        IPanelButton btn = ((PEventButton)event).getButton();
        if (btn.getButtonID() == 0) {
            mc.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1) {
            mc.func_147108_a((GuiScreen)new GuiQuestLines((GuiScreen)this));
        } else if (btn.getButtonID() == 2) {
            DBEntry party = PartyManager.INSTANCE.getParty(QuestingAPI.getQuestingUUID((EntityPlayer)mc.field_71439_g));
            if (party != null) {
                mc.func_147108_a((GuiScreen)new GuiPartyManage((GuiScreen)this));
            } else {
                mc.func_147108_a((GuiScreen)new GuiPartyCreate((GuiScreen)this));
            }
        } else if (btn.getButtonID() == 3) {
            mc.func_147108_a((GuiScreen)new GuiThemes((GuiScreen)this));
        } else if (btn.getButtonID() == 4) {
            mc.func_147108_a((GuiScreen)new GuiNbtEditor((GuiScreen)this, QuestSettings.INSTANCE.writeToNBT(new NBTTagCompound()), value -> {
                QuestSettings.INSTANCE.readFromNBT(value);
                NetSettingSync.requestEdit();
            }));
        } else if (btn.getButtonID() == 5 && (qFile = new File(BQ_Settings.defaultDir, "DefaultQuests.json")).exists()) {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
                boolean editMode = (Boolean)QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE);
                boolean hardMode = (Boolean)QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE);
                NBTTagList jsonP = QuestDatabase.INSTANCE.writeProgressToNBT(new NBTTagList(), null);
                NBTTagCompound j1 = NBTConverter.JSONtoNBT_Object((JsonObject)JsonHelper.ReadFromFile((File)qFile), (NBTTagCompound)new NBTTagCompound(), (boolean)true);
                QuestSettings.INSTANCE.readFromNBT(j1.func_74775_l("questSettings"));
                QuestDatabase.INSTANCE.readFromNBT(j1.func_150295_c("questDatabase", 10), false);
                QuestLineDatabase.INSTANCE.readFromNBT(j1.func_150295_c("questLines", 10), false);
                QuestDatabase.INSTANCE.readProgressFromNBT(jsonP, false);
                QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, (Object)editMode);
                QuestSettings.INSTANCE.setProperty(NativeProps.HARDCORE, (Object)hardMode);
                NetSettingSync.sendSync(null);
                NetQuestSync.quickSync((int)-1, (boolean)true, (boolean)true);
                NetChapterSync.sendSync(null, null);
                SaveLoadHandler.INSTANCE.resetUpdate();
                SaveLoadHandler.INSTANCE.markDirty();
            });
            mc.func_147108_a(null);
        }
    }
}

