/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.common.ModConfig;
import artifacts.common.init.ModItems;
import artifacts.common.init.ModLootTables;
import artifacts.common.item.BaubleBase;
import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class BaubleAmulet
extends BaubleBase {
    public BaubleAmulet(String name) {
        super(name, BaubleType.AMULET);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77973_b() == ModItems.SACRIFICIAL_AMULET && ModConfig.general.sacrificialTooltip && stack.func_77978_p() != null && (GuiScreen.func_146272_n() || ModConfig.client.alwaysShowTooltip)) {
            tooltip.add(TextFormatting.DARK_RED + "" + I18n.func_74838_a((String)("tooltip.artifacts." + this.name + ".charge")) + ": " + (ModConfig.general.sacrificialVisible ? "" : TextFormatting.OBFUSCATED) + stack.func_77978_p().func_74762_e("Sacrificial Amulet Charge") + (ModConfig.general.sacrificialChargeShowTotal ? " / " + ModConfig.general.sacrificialCharge : ""));
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer) {
            Random random;
            EntityLiving attacker;
            boolean hasUltimatePendant;
            boolean bl = hasUltimatePendant = BaublesApi.isBaubleEquipped((EntityPlayer)((EntityPlayer)event.getEntity()), (Item)ModItems.ULTIMATE_PENDANT) != -1;
            if (event.getSource() == DamageSource.field_76370_b && (hasUltimatePendant || BaublesApi.isBaubleEquipped((EntityPlayer)((EntityPlayer)event.getEntity()), (Item)ModItems.FLAME_PENDANT) != -1)) {
                event.setCanceled(true);
                if (event.getEntity().func_70027_ad()) {
                    event.getEntity().func_70066_B();
                }
                return;
            }
            if (event.getAmount() < 1.0f) {
                return;
            }
            if (BaublesApi.isBaubleEquipped((EntityPlayer)((EntityPlayer)event.getEntity()), (Item)ModItems.PANIC_NECKLACE) != -1) {
                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76424_c, 60, 1, true, false));
            }
            if (hasUltimatePendant || BaublesApi.isBaubleEquipped((EntityPlayer)((EntityPlayer)event.getEntity()), (Item)ModItems.SHOCK_PENDANT) != -1) {
                if (event.getSource() == DamageSource.field_180137_b) {
                    event.setCanceled(true);
                } else if (event.getSource().func_76346_g() instanceof EntityLiving && ModConfig.general.shockChance > 0.0 && (ModConfig.general.pendantCooldown <= 0 || !((EntityPlayer)event.getEntity()).func_184811_cZ().func_185141_a((Item)ModItems.SHOCK_PENDANT))) {
                    attacker = (EntityLiving)event.getSource().func_76346_g();
                    random = ((EntityPlayer)event.getEntity()).func_70681_au();
                    if ((double)random.nextFloat() < ModConfig.general.shockChance && attacker.field_70170_p.func_175678_i(attacker.func_180425_c().func_177984_a())) {
                        attacker.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(attacker.field_70170_p, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, false));
                        if (ModConfig.general.pendantCooldown > 0) {
                            ((EntityPlayer)event.getEntity()).func_184811_cZ().func_185145_a((Item)ModItems.SHOCK_PENDANT, ModConfig.general.pendantCooldown);
                        }
                    }
                }
            }
            if ((hasUltimatePendant || BaublesApi.isBaubleEquipped((EntityPlayer)((EntityPlayer)event.getEntity()), (Item)ModItems.FLAME_PENDANT) != -1) && event.getSource().func_76346_g() instanceof EntityLiving && ModConfig.general.flameChance > 0.0 && (ModConfig.general.pendantCooldown <= 0 || !((EntityPlayer)event.getEntity()).func_184811_cZ().func_185141_a((Item)ModItems.FLAME_PENDANT))) {
                attacker = (EntityLiving)event.getSource().func_76346_g();
                random = ((EntityPlayer)event.getEntity()).func_70681_au();
                if (!attacker.func_70045_F() && attacker.func_190631_cK() && (double)random.nextFloat() < ModConfig.general.flameChance) {
                    attacker.func_70015_d(4);
                    attacker.func_70097_a(new EntityDamageSource("onFire", event.getEntity()).func_76361_j(), 2.0f);
                    if (ModConfig.general.pendantCooldown > 0) {
                        ((EntityPlayer)event.getEntity()).func_184811_cZ().func_185145_a((Item)ModItems.FLAME_PENDANT, ModConfig.general.pendantCooldown);
                    }
                }
            }
            if ((hasUltimatePendant || BaublesApi.isBaubleEquipped((EntityPlayer)((EntityPlayer)event.getEntity()), (Item)ModItems.THORN_PENDANT) != -1) && event.getSource().func_76346_g() instanceof EntityLiving && ModConfig.general.thornChance > 0.0 && (ModConfig.general.pendantCooldown <= 0 || !((EntityPlayer)event.getEntity()).func_184811_cZ().func_185141_a((Item)ModItems.THORN_PENDANT))) {
                attacker = (EntityLiving)event.getSource().func_76346_g();
                random = ((EntityPlayer)event.getEntity()).func_70681_au();
                if (attacker.func_190631_cK() && (double)random.nextFloat() < ModConfig.general.thornChance) {
                    attacker.func_70097_a(DamageSource.func_92087_a((Entity)event.getEntity()), (float)(2 + random.nextInt(3)));
                    if (ModConfig.general.pendantCooldown > 0) {
                        ((EntityPlayer)event.getEntity()).func_184811_cZ().func_185145_a((Item)ModItems.THORN_PENDANT, ModConfig.general.pendantCooldown);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getSource().func_76346_g() instanceof EntityPlayer) {
            int kills;
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            int amuletSlot = 0;
            ItemStack amuletStack = ItemStack.field_190927_a;
            for (int slot : BaubleType.AMULET.getValidSlots()) {
                ItemStack stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(slot);
                if (stack.func_77973_b() != ModItems.SACRIFICIAL_AMULET) continue;
                amuletSlot = slot;
                amuletStack = stack;
                break;
            }
            if (amuletStack == ItemStack.field_190927_a) {
                return;
            }
            if (amuletStack.func_77978_p() == null) {
                amuletStack.func_77982_d(new NBTTagCompound());
            }
            if ((kills = amuletStack.func_77978_p().func_74762_e("Sacrificial Amulet Charge") + 1) >= ModConfig.general.sacrificialCharge) {
                BaublesApi.getBaublesHandler((EntityPlayer)player).setStackInSlot(amuletSlot, ItemStack.field_190927_a);
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_191263_gW, SoundCategory.PLAYERS, 0.5f, 0.8f + player.func_70681_au().nextFloat() * 0.4f);
                BaubleAmulet.dropSacrificeReward(player);
            } else {
                amuletStack.func_77978_p().func_74768_a("Sacrificial Amulet Charge", kills);
            }
        }
    }

    private static void dropSacrificeReward(EntityPlayer player) {
        ResourceLocation resourcelocation = ModLootTables.SACRIFICIAL_REWARD;
        LootTable loottable = player.field_70170_p.func_184146_ak().func_186521_a(resourcelocation);
        LootContext.Builder builder = new LootContext.Builder((WorldServer)player.field_70170_p).func_186470_a(player).func_186469_a(player.func_184817_da());
        for (ItemStack itemstack : loottable.func_186462_a(player.func_70681_au(), builder.func_186471_a())) {
            if (itemstack.func_190926_b()) continue;
            EntityItem entityitem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, itemstack);
            entityitem.func_174869_p();
            player.field_70170_p.func_72838_d((Entity)entityitem);
        }
    }
}

