/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.util;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.CapabilityExtendedHealthSystem;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.quetzi.morpheus.Morpheus;
import net.quetzi.morpheus.MorpheusRegistry;
import net.quetzi.morpheus.api.INewDayHandler;
import net.quetzi.morpheus.world.WorldSleepState;

public class MorpheusHelper
implements INewDayHandler {
    private static final MorpheusHelper INSTANCE = new MorpheusHelper();
    private INewDayHandler oldHandler;

    public static void register() {
        if (MorpheusHelper.INSTANCE.oldHandler != null) {
            throw new IllegalStateException("MorpheusHelper did already init!");
        }
        MorpheusHelper.INSTANCE.oldHandler = (INewDayHandler)MorpheusRegistry.registry.get(0);
        FirstAid.LOGGER.info("Morpheus present - enabling compatibility module. Parent: " + MorpheusHelper.INSTANCE.oldHandler.getClass());
        Morpheus.register.registerHandler((INewDayHandler)INSTANCE, 0);
    }

    public void startNewDay() {
        if (this.oldHandler != null) {
            this.oldHandler.startNewDay();
        }
        if (FirstAidConfig.externalHealing.sleepHealPercentage <= 0.0) {
            return;
        }
        WorldSleepState sleepState = (WorldSleepState)Morpheus.playerSleepStatus.get(0);
        if (sleepState == null) {
            return;
        }
        if (MorpheusHelper.areEnoughPlayersAsleep(sleepState)) {
            WorldServer world = DimensionManager.getWorld((int)0);
            for (EntityPlayer player : world.field_73010_i) {
                if (!player.func_71026_bH()) continue;
                AbstractPlayerDamageModel damageModel = (AbstractPlayerDamageModel)player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null);
                Objects.requireNonNull(damageModel, "damage model").sleepHeal(player);
            }
        }
    }

    private static boolean areEnoughPlayersAsleep(WorldSleepState sleepState) {
        return sleepState.getSleepingPlayers() > 0 && sleepState.getPercentSleeping() >= Morpheus.perc;
    }
}

