/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client.util;

import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.client.util.EventCalendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PlayerModelRenderer {
    private static final ResourceLocation HEALTH_RENDER_LOCATION = new ResourceLocation("firstaid", "textures/gui/simple_health.png");
    private static final ResourceLocation HEALTH_RENDER_LOCATION_OLD = new ResourceLocation("firstaid", "textures/gui/simple_health_old.png");
    private static final int SIZE = 32;
    private static int angle = 0;
    private static boolean otherWay = false;
    private static int cooldown = 0;

    public static void renderPlayerHealth(AbstractPlayerDamageModel damageModel, boolean fourColors, boolean oldModel, Gui gui, boolean flashState, float alpha, float partialTicks) {
        int yOffset = flashState ? 64 : 0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - alpha / 255.0f));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(oldModel ? HEALTH_RENDER_LOCATION_OLD : HEALTH_RENDER_LOCATION);
        if (FirstAidConfig.overlay.enableEasterEggs && (EventCalendar.isAFDay() || EventCalendar.isHalloween())) {
            float angle = PlayerModelRenderer.angle;
            if (cooldown == 0) {
                angle += (otherWay ? -partialTicks : partialTicks) * 2.0f;
            }
            if (FirstAidConfig.overlay.pos == FirstAidConfig.Overlay.Position.BOTTOM_LEFT || FirstAidConfig.overlay.pos == FirstAidConfig.Overlay.Position.TOP_LEFT) {
                GlStateManager.func_179109_b((float)(angle * 1.5f), (float)0.0f, (float)0.0f);
            } else {
                GlStateManager.func_179109_b((float)(angle * 0.5f), (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (yOffset != 0) {
            GlStateManager.func_179109_b((float)0.0f, (float)(-yOffset), (float)0.0f);
        }
        PlayerModelRenderer.drawPart(gui, fourColors, damageModel.HEAD, 8, yOffset + 0, 16, 16);
        PlayerModelRenderer.drawPart(gui, fourColors, damageModel.BODY, 8, yOffset + 16, 16, 24);
        PlayerModelRenderer.drawPart(gui, fourColors, damageModel.LEFT_ARM, 0, yOffset + 16, 8, 24);
        PlayerModelRenderer.drawPart(gui, fourColors, damageModel.RIGHT_ARM, 24, yOffset + 16, 8, 24);
        PlayerModelRenderer.drawPart(gui, fourColors, damageModel.LEFT_LEG, 8, yOffset + 40, 8, 16);
        PlayerModelRenderer.drawPart(gui, fourColors, damageModel.RIGHT_LEG, 16, yOffset + 40, 8, 16);
        PlayerModelRenderer.drawPart(gui, fourColors, damageModel.LEFT_FOOT, 8, yOffset + 56, 8, 8);
        PlayerModelRenderer.drawPart(gui, fourColors, damageModel.RIGHT_FOOT, 16, yOffset + 56, 8, 8);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private static void drawPart(Gui gui, boolean fourColors, AbstractDamageablePart part, int texX, int texY, int sizeX, int sizeY) {
        int rawTexX = texX;
        gui.func_73729_b(rawTexX, texY, texX += 32 * PlayerModelRenderer.getState(part, fourColors), texY, sizeX, sizeY);
    }

    private static int getState(AbstractDamageablePart part, boolean fourColors) {
        if (part.currentHealth <= 0.001f) {
            return 5;
        }
        int maxHealth = part.getMaxHealth();
        if (Math.abs(part.currentHealth - (float)maxHealth) < 0.001f) {
            return 0;
        }
        float healthPercentage = part.currentHealth / (float)maxHealth;
        if (healthPercentage >= 1.0f || healthPercentage <= 0.0f) {
            throw new RuntimeException(String.format("Calculated invalid health for part %s with current health %s and max health %d. Got value %s", new Object[]{part.part, Float.valueOf(part.currentHealth), maxHealth, Float.valueOf(healthPercentage)}));
        }
        if (!fourColors && healthPercentage > 0.75f) {
            return 1;
        }
        if (healthPercentage > 0.5f) {
            return 2;
        }
        if (!fourColors && healthPercentage > 0.25f) {
            return 3;
        }
        return 4;
    }

    public static void tickFun() {
        if (cooldown > 0) {
            --cooldown;
            return;
        }
        if ((angle += otherWay ? -2 : 2) >= 90 || angle <= 0) {
            otherWay = !otherWay;
            cooldown = !otherWay ? 200 : 30;
        }
    }
}

