/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.lost;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lostcities.api.ILostChunkInfo;
import mcjty.lostcities.api.ILostCityBuilding;
import mcjty.lostcities.api.ILostCityInfo;
import mcjty.lostcities.api.ILostCityMultiBuilding;
import mcjty.lostcities.api.ILostExplosion;
import mcjty.lostcities.api.ILostSphere;
import mcjty.lostcities.api.LostChunkCharacteristics;
import mcjty.lostcities.api.LostCityEvent;
import mcjty.lostcities.api.RailChunkType;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.dimensions.world.ChunkHeightmap;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.driver.IIndex;
import mcjty.lostcities.dimensions.world.lost.BiomeInfo;
import mcjty.lostcities.dimensions.world.lost.City;
import mcjty.lostcities.dimensions.world.lost.CitySphere;
import mcjty.lostcities.dimensions.world.lost.DamageArea;
import mcjty.lostcities.dimensions.world.lost.Direction;
import mcjty.lostcities.dimensions.world.lost.Highway;
import mcjty.lostcities.dimensions.world.lost.Orientation;
import mcjty.lostcities.dimensions.world.lost.Railway;
import mcjty.lostcities.dimensions.world.lost.cityassets.AssetRegistries;
import mcjty.lostcities.dimensions.world.lost.cityassets.Building;
import mcjty.lostcities.dimensions.world.lost.cityassets.BuildingPart;
import mcjty.lostcities.dimensions.world.lost.cityassets.CityStyle;
import mcjty.lostcities.dimensions.world.lost.cityassets.CompiledPalette;
import mcjty.lostcities.dimensions.world.lost.cityassets.ConditionContext;
import mcjty.lostcities.dimensions.world.lost.cityassets.Palette;
import mcjty.lostcities.dimensions.world.lost.cityassets.PredefinedCity;
import mcjty.lostcities.dimensions.world.lost.cityassets.Style;
import mcjty.lostcities.dimensions.world.terraingen.LostCitiesTerrainGenerator;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.Counter;
import mcjty.lostcities.varia.QualityRandom;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public class BuildingInfo
implements ILostChunkInfo {
    public final int chunkX;
    public final int chunkZ;
    public final ChunkCoord coord;
    public final LostCityChunkGenerator provider;
    public final LostCityProfile profile;
    public final boolean outsideChunk;
    public final int groundLevel;
    public final int waterLevel;
    public final boolean isCity;
    public final boolean hasBuilding;
    public final int building2x2Section;
    public final ILostCityMultiBuilding multiBuilding;
    public final ILostCityBuilding buildingType;
    public final BuildingPart fountainType;
    public final BuildingPart parkType;
    public final BuildingPart bridgeType;
    public final BuildingPart stairType;
    public final BuildingPart frontType;
    private final float stairPriority;
    public final BuildingPart railDungeon;
    public final StreetType streetType;
    private final int floors;
    public final int floorsBelowGround;
    public final BuildingPart[] floorTypes;
    public final BuildingPart[] floorTypes2;
    public final boolean[] connectionAtX;
    public final boolean[] connectionAtZ;
    public final boolean noLoot;
    public final float ruinHeight;
    public final int highwayXLevel;
    public final int highwayZLevel;
    public final int cityLevel;
    public final boolean xBridge;
    public final boolean zBridge;
    public final boolean xRailCorridor;
    public final boolean zRailCorridor;
    public final Block doorBlock;
    private BuildingInfo xmin = null;
    private BuildingInfo xmax = null;
    private BuildingInfo zmin = null;
    private BuildingInfo zmax = null;
    private DamageArea damageArea = null;
    private Palette palette = null;
    private CompiledPalette compiledPalette = null;
    private Boolean isOcean = null;
    private boolean xBridgeTypeCalculated = false;
    private boolean zBridgeTypeCalculated = false;
    private BuildingPart xBridgeType = null;
    private BuildingPart zBridgeType = null;
    private boolean stairsCalculated = false;
    private Direction stairDirection;
    private boolean actualStairsCalculated = false;
    private Direction actualStairDirection;
    private Boolean horizontalMonorail = null;
    private Boolean verticalMonorail = null;
    private final List<Pair<BlockPos, ConditionTodo>> mobSpawnerTodo = new ArrayList<Pair<BlockPos, ConditionTodo>>();
    private final List<Pair<BlockPos, ConditionTodo>> lootTodo = new ArrayList<Pair<BlockPos, ConditionTodo>>();
    private final List<BlockPos> lightingUpdateTodo = new ArrayList<BlockPos>();
    private final List<Pair<IIndex, Map<String, Integer>>> torchTodo = new ArrayList<Pair<IIndex, Map<String, Integer>>>();
    private final List<BlockPos> saplingTodo = new ArrayList<BlockPos>();
    private static Map<ChunkCoord, BuildingInfo> buildingInfoMap = new HashMap<ChunkCoord, BuildingInfo>();
    private static Map<ChunkCoord, LostChunkCharacteristics> cityInfoMap = new HashMap<ChunkCoord, LostChunkCharacteristics>();

    public void addSaplingTodo(BlockPos pos) {
        this.saplingTodo.add(pos);
    }

    public List<BlockPos> getSaplingTodo() {
        return this.saplingTodo;
    }

    public void clearSaplingTodo() {
        this.saplingTodo.clear();
    }

    public void addTorchTodo(IIndex index, Map<String, Integer> orientations) {
        this.torchTodo.add((Pair<IIndex, Map<String, Integer>>)Pair.of((Object)index, orientations));
    }

    public List<Pair<IIndex, Map<String, Integer>>> getTorchTodo() {
        return this.torchTodo;
    }

    public void clearTorchTodo() {
        this.torchTodo.clear();
    }

    public void addLightingUpdateTodo(BlockPos pos) {
        this.lightingUpdateTodo.add(pos);
    }

    public List<BlockPos> getLightingUpdateTodo() {
        return this.lightingUpdateTodo;
    }

    public void clearLightingUpdateTodo() {
        this.lightingUpdateTodo.clear();
    }

    public void addSpawnerTodo(BlockPos pos, ConditionTodo mobId) {
        this.mobSpawnerTodo.add((Pair<BlockPos, ConditionTodo>)Pair.of((Object)pos, (Object)mobId));
    }

    public void addLootTodo(BlockPos pos, @Nullable ConditionTodo lootTable) {
        this.lootTodo.add((Pair<BlockPos, ConditionTodo>)Pair.of((Object)pos, (Object)lootTable));
    }

    public List<Pair<BlockPos, ConditionTodo>> getMobSpawnerTodo() {
        return this.mobSpawnerTodo;
    }

    public List<Pair<BlockPos, ConditionTodo>> getLootTodo() {
        return this.lootTodo;
    }

    public void clearMobSpawnerTodo() {
        this.mobSpawnerTodo.clear();
    }

    public void clearLootTodo() {
        this.lootTodo.clear();
    }

    public CompiledPalette getCompiledPalette() {
        if (this.compiledPalette == null) {
            this.compiledPalette = new CompiledPalette(this.palette);
        }
        return this.compiledPalette;
    }

    public DamageArea getDamageArea() {
        if (this.damageArea == null) {
            this.damageArea = new DamageArea(this.chunkX, this.chunkZ, this.provider, this);
        }
        return this.damageArea;
    }

    public BuildingInfo getTodoChunk(int x, int z) {
        if (x >= 8 && z >= 8) {
            return this;
        }
        if (x < 8 && z >= 8) {
            return this.getXmin();
        }
        if (x >= 8 && z < 8) {
            return this.getZmin();
        }
        return this.getXmin().getZmin();
    }

    public Style getOutsideStyle() {
        return AssetRegistries.STYLES.get(this.provider.worldStyle.getOutsideStyle());
    }

    private void createPalette(Random rand) {
        Style style;
        if (!this.isCity) {
            style = this.getOutsideStyle();
        } else {
            String name = this.getCityStyle().getStyle();
            style = AssetRegistries.STYLES.get(name);
            if (style == null) {
                throw new RuntimeException("Cannot find style '" + name + "'!");
            }
        }
        this.palette = style.getRandomPalette(this.provider, rand);
    }

    public BuildingInfo getAdjacent(int x, int z) {
        if (x == 0) {
            return this.getXmin();
        }
        if (x == 15) {
            return this.getXmax();
        }
        if (z == 0) {
            return this.getZmin();
        }
        if (z == 15) {
            return this.getZmax();
        }
        return null;
    }

    public BuildingInfo getXmin() {
        if (this.xmin == null) {
            this.xmin = BuildingInfo.getBuildingInfo(this.chunkX - 1, this.chunkZ, this.provider);
        }
        return this.xmin;
    }

    public BuildingInfo getXmax() {
        if (this.xmax == null) {
            this.xmax = BuildingInfo.getBuildingInfo(this.chunkX + 1, this.chunkZ, this.provider);
        }
        return this.xmax;
    }

    public BuildingInfo getZmin() {
        if (this.zmin == null) {
            this.zmin = BuildingInfo.getBuildingInfo(this.chunkX, this.chunkZ - 1, this.provider);
        }
        return this.zmin;
    }

    public BuildingInfo getZmax() {
        if (this.zmax == null) {
            this.zmax = BuildingInfo.getBuildingInfo(this.chunkX, this.chunkZ + 1, this.provider);
        }
        return this.zmax;
    }

    public int getMaxHeight() {
        if (this.hasBuilding) {
            return this.getCityGroundLevel() + this.floors * 6;
        }
        int m = this.getMaxHighwayLevel();
        if (m >= 0) {
            return this.groundLevel + m * 6;
        }
        return this.getCityGroundLevel();
    }

    public int getCityGroundLevel() {
        return this.groundLevel + this.cityLevel * 6;
    }

    public int getCityGroundLevelOutsideLower() {
        if (this.isCity) {
            return this.groundLevel + this.cityLevel * 6;
        }
        return this.groundLevel + this.cityLevel * 6 - 1;
    }

    public boolean isValidFloor(int l) {
        return l + this.floorsBelowGround >= 0 && l + this.floorsBelowGround < this.floorTypes.length;
    }

    public BuildingPart getFloor(int l) {
        return this.floorTypes[l + this.floorsBelowGround];
    }

    public BuildingPart getFloorPart2(int l) {
        return this.floorTypes2[l + this.floorsBelowGround];
    }

    public ILostCityBuilding getBuilding() {
        return this.buildingType;
    }

    public CityStyle getCityStyle() {
        return (CityStyle)BuildingInfo.getChunkCharacteristics((int)this.chunkX, (int)this.chunkZ, (LostCityChunkGenerator)this.provider).cityStyle;
    }

    public static LostChunkCharacteristics getChunkCharacteristics(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        LostChunkCharacteristics characteristics;
        ChunkCoord key;
        block17: {
            CityStyle cityStyle;
            Random rand;
            block15: {
                LostChunkCharacteristics topleft;
                block16: {
                    float dist;
                    key = new ChunkCoord(provider.dimensionId, chunkX, chunkZ);
                    if (cityInfoMap.containsKey(key)) {
                        return cityInfoMap.get(key);
                    }
                    LostCityProfile profile = BuildingInfo.getProfile(chunkX, chunkZ, provider);
                    characteristics = new LostChunkCharacteristics();
                    characteristics.isCity = BuildingInfo.isCityRaw(chunkX, chunkZ, provider, profile);
                    characteristics.section = BuildingInfo.getMultiBuildingSection(chunkX, chunkZ, provider, profile);
                    characteristics.cityLevel = characteristics.section > 0 ? BuildingInfo.getTopLeftCityInfo((LostChunkCharacteristics)characteristics, (int)chunkX, (int)chunkZ, (LostCityChunkGenerator)provider).cityLevel : BuildingInfo.getCityLevel(chunkX, chunkZ, provider);
                    rand = BuildingInfo.getBuildingRandom(chunkX, chunkZ, provider.seed);
                    boolean bl = characteristics.couldHaveBuilding = characteristics.isCity && BuildingInfo.checkBuildingPossibility(chunkX, chunkZ, provider, profile, characteristics.section, characteristics.cityLevel, rand);
                    if (profile.isSpace() && characteristics.section == -1 && (dist = CitySphere.getRelativeDistanceToCityCenter(chunkX, chunkZ, provider)) > 0.7f) {
                        characteristics.couldHaveBuilding = false;
                    }
                    ChunkCoord coord = new ChunkCoord(provider.dimensionId, chunkX, chunkZ);
                    if (characteristics.isCity && !characteristics.couldHaveBuilding) {
                        Counter<String> counter = new Counter<String>();
                        for (int cx = -1; cx <= 1; ++cx) {
                            for (int cz = -1; cz <= 1; ++cz) {
                                cityStyle = City.getCityStyle(coord.getChunkX() + cx, coord.getChunkZ() + cz, provider, profile);
                                counter.add(cityStyle.getName());
                                if (cx != 0 || cz != 0) continue;
                                counter.add(cityStyle.getName());
                            }
                        }
                        cityStyle = AssetRegistries.CITYSTYLES.get((String)counter.getMostOccuring());
                    } else {
                        cityStyle = City.getCityStyle(chunkX, chunkZ, provider, profile);
                    }
                    characteristics.cityStyle = cityStyle;
                    if (characteristics.section < 1) break block15;
                    topleft = BuildingInfo.getTopLeftCityInfo(characteristics, chunkX, chunkZ, provider);
                    characteristics.multiBuilding = topleft.multiBuilding;
                    if (characteristics.multiBuilding == null) break block16;
                    switch (characteristics.section) {
                        case 1: {
                            characteristics.buildingType = AssetRegistries.BUILDINGS.get(characteristics.multiBuilding.getBuilding(1, 0));
                            break block17;
                        }
                        case 2: {
                            characteristics.buildingType = AssetRegistries.BUILDINGS.get(characteristics.multiBuilding.getBuilding(0, 1));
                            break block17;
                        }
                        case 3: {
                            characteristics.buildingType = AssetRegistries.BUILDINGS.get(characteristics.multiBuilding.getBuilding(1, 1));
                            break block17;
                        }
                        default: {
                            throw new RuntimeException("What 2!");
                        }
                    }
                }
                characteristics.buildingType = topleft.buildingType;
                break block17;
            }
            PredefinedCity.PredefinedBuilding predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ, provider);
            if (characteristics.section == 0) {
                String name = cityStyle.getRandomMultiBuilding(rand);
                if (predefinedBuilding != null) {
                    name = predefinedBuilding.getBuilding();
                }
                characteristics.multiBuilding = AssetRegistries.MULTI_BUILDINGS.get(name);
                characteristics.buildingType = AssetRegistries.BUILDINGS.get(characteristics.multiBuilding.getBuilding(0, 0));
            } else {
                characteristics.multiBuilding = null;
                String name = cityStyle.getRandomBuilding(rand);
                if (predefinedBuilding != null) {
                    name = predefinedBuilding.getBuilding();
                }
                characteristics.buildingType = AssetRegistries.BUILDINGS.get(name);
            }
        }
        LostCityEvent.CharacteristicsEvent event = new LostCityEvent.CharacteristicsEvent(provider.worldObj, provider, chunkX, chunkZ, characteristics);
        MinecraftForge.EVENT_BUS.post((Event)event);
        cityInfoMap.put(key, characteristics);
        return characteristics;
    }

    public static boolean isCityRaw(int chunkX, int chunkZ, LostCityChunkGenerator provider, LostCityProfile profile) {
        float cityFactor;
        if (BuildingInfo.isVoidChunk(chunkX, chunkZ, provider)) {
            return false;
        }
        if (provider.getProfile().isSpace()) {
            if (CitySphere.onCitySphereBorder(chunkX, chunkZ, provider)) {
                return false;
            }
            if (!provider.getProfile().CITYSPHERE_LANDSCAPE_OUTSIDE && !CitySphere.fullyInsideCitySpere(chunkX, chunkZ, provider)) {
                return false;
            }
            if (CitySphere.hasMonorailStation(chunkX, chunkZ, provider)) {
                return false;
            }
        }
        return (cityFactor = City.getCityFactor(chunkX, chunkZ, provider, profile)) > profile.CITY_THRESSHOLD;
    }

    public static boolean isCity(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        return BuildingInfo.getChunkCharacteristics((int)chunkX, (int)chunkZ, (LostCityChunkGenerator)provider).isCity;
    }

    private static boolean checkBuildingPossibility(int chunkX, int chunkZ, LostCityChunkGenerator provider, LostCityProfile profile, int section, int cityLevel, Random rand) {
        int maxh;
        Railway.RailChunkInfo info;
        int maxh2;
        float bc = rand.nextFloat();
        PredefinedCity.PredefinedBuilding predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ, provider);
        if (predefinedBuilding != null) {
            return true;
        }
        PredefinedCity.PredefinedStreet predefinedStreet = City.getPredefinedStreet(chunkX, chunkZ, provider);
        if (predefinedStreet != null) {
            return false;
        }
        boolean b = section >= 0 ? true : (bc >= profile.BUILDING_CHANCE ? false : (BuildingInfo.hasHighway(chunkX, chunkZ, provider, profile) ? cityLevel > (maxh2 = Math.max(Highway.getXHighwayLevel(chunkX, chunkZ, provider, profile), Highway.getZHighwayLevel(chunkX, chunkZ, provider, profile))) + 1 : (BuildingInfo.hasRailway(chunkX, chunkZ, provider, profile) ? ((info = Railway.getRailChunkType(chunkX, chunkZ, provider, profile)).getType() == RailChunkType.STATION_UNDERGROUND ? false : cityLevel > (maxh = info.getLevel()) + 1) : true)));
        return b;
    }

    private static int getMultiBuildingSection(int chunkX, int chunkZ, LostCityChunkGenerator provider, LostCityProfile profile) {
        int section = BuildingInfo.isTopLeftOf2x2Building(chunkX, chunkZ, provider, profile) ? 0 : (BuildingInfo.isTopLeftOf2x2Building(chunkX - 1, chunkZ, provider, profile) ? 1 : (BuildingInfo.isTopLeftOf2x2Building(chunkX, chunkZ - 1, provider, profile) ? 2 : (BuildingInfo.isTopLeftOf2x2Building(chunkX - 1, chunkZ - 1, provider, profile) ? 3 : -1)));
        return section;
    }

    private BuildingInfo calculateTopLeft() {
        switch (this.building2x2Section) {
            case 0: {
                return this;
            }
            case 1: {
                return this.getXmin();
            }
            case 2: {
                return this.getZmin();
            }
            case 3: {
                return this.getXmin().getZmin();
            }
        }
        throw new RuntimeException("What!");
    }

    private static LostChunkCharacteristics getTopLeftCityInfo(LostChunkCharacteristics thisone, int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        switch (thisone.section) {
            case 0: {
                return thisone;
            }
            case 1: {
                return BuildingInfo.getChunkCharacteristics(chunkX - 1, chunkZ, provider);
            }
            case 2: {
                return BuildingInfo.getChunkCharacteristics(chunkX, chunkZ - 1, provider);
            }
            case 3: {
                return BuildingInfo.getChunkCharacteristics(chunkX - 1, chunkZ - 1, provider);
            }
        }
        throw new RuntimeException("What!");
    }

    private static boolean isCandidateForTopLeftOf2x2Building(int chunkX, int chunkZ, LostCityChunkGenerator provider, LostCityProfile profile) {
        PredefinedCity.PredefinedBuilding predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ, provider);
        if (predefinedBuilding != null && predefinedBuilding.isMulti()) {
            return true;
        }
        PredefinedCity.PredefinedStreet predefinedStreet = City.getPredefinedStreet(chunkX, chunkZ, provider);
        if (predefinedStreet != null) {
            return false;
        }
        if (BuildingInfo.isMultiBuildingCandidate(chunkX, chunkZ, provider, profile)) {
            Random rand = BuildingInfo.getBuildingRandom(chunkX, chunkZ, provider.seed);
            return rand.nextFloat() < profile.BUILDING2X2_CHANCE;
        }
        return false;
    }

    private static boolean isMultiBuildingCandidate(int chunkX, int chunkZ, LostCityChunkGenerator provider, LostCityProfile profile) {
        return BuildingInfo.isCityRaw(chunkX, chunkZ, provider, profile) && !BuildingInfo.hasHighway(chunkX, chunkZ, provider, profile) && !BuildingInfo.hasRailway(chunkX, chunkZ, provider, profile);
    }

    private static boolean hasHighway(int chunkX, int chunkZ, LostCityChunkGenerator provider, LostCityProfile profile) {
        return Highway.getXHighwayLevel(chunkX, chunkZ, provider, profile) >= 0 || Highway.getZHighwayLevel(chunkX, chunkZ, provider, profile) >= 0;
    }

    private static boolean hasRailway(int chunkX, int chunkZ, LostCityChunkGenerator provider, LostCityProfile profile) {
        return Railway.getRailChunkType(chunkX, chunkZ, provider, profile).getType() != RailChunkType.NONE;
    }

    public Railway.RailChunkInfo getRailInfo() {
        return Railway.getRailChunkType(this.chunkX, this.chunkZ, this.provider, this.profile);
    }

    public boolean isTunnel(int level) {
        if (this.isCity) {
            return this.cityLevel > level;
        }
        ChunkHeightmap heightmap = this.provider.getHeightmap(this.chunkX, this.chunkZ);
        int highwayHeight = this.groundLevel + level * 6 + 3;
        int cnt = 0;
        for (int x = 2; x < 16; x += 3) {
            for (int z = 2; z < 16; z += 3) {
                if (heightmap.getHeight(x, z) <= highwayHeight) continue;
                ++cnt;
            }
        }
        return cnt > 12;
    }

    private static boolean isTopLeftOf2x2Building(int chunkX, int chunkZ, LostCityChunkGenerator provider, LostCityProfile profile) {
        PredefinedCity.PredefinedBuilding predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ, provider);
        if (predefinedBuilding != null && predefinedBuilding.isMulti()) {
            return true;
        }
        if (!(!BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX, chunkZ, provider, profile) || BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX - 1, chunkZ, provider, profile) || BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX - 1, chunkZ - 1, provider, profile) || BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX, chunkZ - 1, provider, profile) || BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX + 1, chunkZ - 1, provider, profile) || BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX + 1, chunkZ, provider, profile) || BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX + 1, chunkZ + 1, provider, profile) || BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX, chunkZ + 1, provider, profile) || BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX - 1, chunkZ + 1, provider, profile))) {
            PredefinedCity.PredefinedStreet predefinedStreet = City.getPredefinedStreet(chunkX, chunkZ, provider);
            if (predefinedStreet != null) {
                return false;
            }
            return BuildingInfo.isMultiBuildingCandidate(chunkX + 1, chunkZ, provider, profile) && BuildingInfo.isMultiBuildingCandidate(chunkX + 1, chunkZ + 1, provider, profile) && BuildingInfo.isMultiBuildingCandidate(chunkX, chunkZ + 1, provider, profile);
        }
        return false;
    }

    public static void cleanCache() {
        buildingInfoMap.clear();
        cityInfoMap.clear();
    }

    public static BuildingInfo getBuildingInfo(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        ChunkCoord key = new ChunkCoord(provider.dimensionId, chunkX, chunkZ);
        if (buildingInfoMap.containsKey(key)) {
            return buildingInfoMap.get(key);
        }
        BuildingInfo info = new BuildingInfo(chunkX, chunkZ, provider);
        buildingInfoMap.put(key, info);
        return info;
    }

    public static LostCityProfile getProfile(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        if (provider.getProfile().isSpace()) {
            if (CitySphere.intersectsWithCitySphere(chunkX, chunkZ, provider)) {
                return provider.getProfile();
            }
            return provider.getOutsideProfile();
        }
        return provider.getProfile();
    }

    private BuildingInfo(final int chunkX, final int chunkZ, final LostCityChunkGenerator provider) {
        this.provider = provider;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.coord = new ChunkCoord(provider.dimensionId, chunkX, chunkZ);
        this.outsideChunk = provider.getProfile().isSpace() && !CitySphere.intersectsWithCitySphere(chunkX, chunkZ, provider);
        this.profile = BuildingInfo.getProfile(chunkX, chunkZ, provider);
        LostChunkCharacteristics characteristics = BuildingInfo.getChunkCharacteristics(chunkX, chunkZ, provider);
        this.isCity = characteristics.isCity;
        this.building2x2Section = characteristics.section;
        this.cityLevel = characteristics.cityLevel;
        this.buildingType = characteristics.buildingType;
        this.multiBuilding = characteristics.multiBuilding;
        Random rand = BuildingInfo.getBuildingRandom(chunkX, chunkZ, provider.seed);
        rand.nextFloat();
        boolean b = characteristics.couldHaveBuilding;
        if (b && this.building2x2Section < 0) {
            if (rand.nextFloat() < BuildingInfo.getChunkCharacteristics((int)(chunkX - 1), (int)chunkZ, (LostCityChunkGenerator)provider).buildingType.getPrefersLonely()) {
                b = false;
            } else if (rand.nextFloat() < BuildingInfo.getChunkCharacteristics((int)(chunkX + 1), (int)chunkZ, (LostCityChunkGenerator)provider).buildingType.getPrefersLonely()) {
                b = false;
            } else if (rand.nextFloat() < BuildingInfo.getChunkCharacteristics((int)chunkX, (int)(chunkZ - 1), (LostCityChunkGenerator)provider).buildingType.getPrefersLonely()) {
                b = false;
            } else if (rand.nextFloat() < BuildingInfo.getChunkCharacteristics((int)chunkX, (int)(chunkZ + 1), (LostCityChunkGenerator)provider).buildingType.getPrefersLonely()) {
                b = false;
            }
        }
        this.hasBuilding = b;
        if (this.outsideChunk && provider.getProfile().CITYSPHERE_LANDSCAPE_OUTSIDE) {
            this.groundLevel = provider.getOutsideProfile().GROUNDLEVEL;
            this.waterLevel = this.groundLevel - provider.getOutsideProfile().WATERLEVEL_OFFSET;
        } else {
            this.groundLevel = provider.getProfile().GROUNDLEVEL;
            this.waterLevel = this.groundLevel - provider.getProfile().WATERLEVEL_OFFSET;
        }
        CityStyle cs = (CityStyle)characteristics.cityStyle;
        if (this.building2x2Section >= 1) {
            BuildingInfo topleft = this.calculateTopLeft();
            this.highwayXLevel = topleft.highwayXLevel;
            this.highwayZLevel = topleft.highwayZLevel;
            this.streetType = topleft.streetType;
            this.fountainType = topleft.fountainType;
            this.parkType = topleft.parkType;
            this.floors = topleft.floors;
            this.floorsBelowGround = topleft.floorsBelowGround;
            this.doorBlock = topleft.doorBlock;
            this.bridgeType = topleft.bridgeType;
            this.stairType = topleft.stairType;
            this.stairPriority = topleft.stairPriority;
            this.palette = topleft.palette;
            this.compiledPalette = topleft.getCompiledPalette();
            this.noLoot = topleft.noLoot;
            this.ruinHeight = topleft.ruinHeight;
        } else {
            int minfloors;
            PredefinedCity.PredefinedBuilding predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ, provider);
            this.highwayXLevel = Highway.getXHighwayLevel(chunkX, chunkZ, provider, this.profile);
            this.highwayZLevel = Highway.getZHighwayLevel(chunkX, chunkZ, provider, this.profile);
            this.streetType = rand.nextDouble() < (double)this.profile.PARK_CHANCE ? StreetType.values()[rand.nextInt(StreetType.values().length)] : StreetType.NORMAL;
            this.fountainType = rand.nextFloat() < this.profile.FOUNTAIN_CHANCE ? AssetRegistries.PARTS.get(cs.getRandomFountain(rand)) : null;
            this.parkType = AssetRegistries.PARTS.get(cs.getRandomPark(rand));
            float cityFactor = City.getCityFactor(chunkX, chunkZ, provider, this.profile);
            int maxfloors = this.getMaxfloors(provider, cs);
            int f = this.profile.BUILDING_MINFLOORS + rand.nextInt((int)((float)this.profile.BUILDING_MINFLOORS_CHANCE + (cityFactor + 0.1f) * (float)(this.profile.BUILDING_MAXFLOORS_CHANCE - this.profile.BUILDING_MINFLOORS_CHANCE)));
            if (++f > maxfloors) {
                f = maxfloors;
            }
            if (f < (minfloors = this.getMinfloors(provider, cs))) {
                f = minfloors;
            }
            if (provider.getProfile().isSpace() && CitySphere.intersectsWithCitySphere(chunkX, chunkZ, provider)) {
                float reldest = CitySphere.getRelativeDistanceToCityCenter(chunkX, chunkZ, provider);
                if (reldest > 0.6f) {
                    f = Math.max(minfloors, f - 2);
                } else if (reldest > 0.5f) {
                    f = Math.max(minfloors, f - 1);
                }
            }
            this.floors = f;
            int maxcellars = this.getMaxcellars(provider, cs);
            int fb = this.profile.BUILDING_MINCELLARS + (maxcellars <= 0 ? 0 : rand.nextInt(maxcellars));
            if (this.getMaxHighwayLevel() >= 0 && (fb = Math.min(this.cityLevel - this.getMaxHighwayLevel() - 1, fb)) < 0) {
                fb = 0;
            }
            this.floorsBelowGround = fb;
            this.doorBlock = this.getRandomDoor(rand);
            this.bridgeType = AssetRegistries.PARTS.get(cs.getRandomBridge(rand));
            this.stairType = AssetRegistries.PARTS.get(cs.getRandomStair(rand));
            this.stairPriority = rand.nextFloat();
            this.createPalette(rand);
            float r = rand.nextFloat();
            this.noLoot = this.building2x2Section == -1 && r < this.profile.BUILDING_WITHOUT_LOOT_CHANCE;
            r = rand.nextFloat();
            this.ruinHeight = rand.nextFloat() < this.profile.RUIN_CHANCE && (predefinedBuilding == null || !predefinedBuilding.isPreventRuins()) ? this.profile.RUIN_MINLEVEL_PERCENT + (this.profile.RUIN_MAXLEVEL_PERCENT - this.profile.RUIN_MINLEVEL_PERCENT) * r : -1.0f;
        }
        this.floorTypes = new BuildingPart[this.floors + this.floorsBelowGround + 1];
        this.floorTypes2 = new BuildingPart[this.floors + this.floorsBelowGround + 1];
        this.connectionAtX = new boolean[this.floors + this.floorsBelowGround + 1];
        this.connectionAtZ = new boolean[this.floors + this.floorsBelowGround + 1];
        Building building = (Building)this.getBuilding();
        for (int i = 0; i <= this.floors + this.floorsBelowGround; ++i) {
            ConditionContext conditionContext = new ConditionContext(this.cityLevel + i - this.floorsBelowGround, i - this.floorsBelowGround, this.floorsBelowGround, this.floors, "<none>", building.getName(), chunkX, chunkZ){

                @Override
                public boolean isBuilding() {
                    return true;
                }

                @Override
                public boolean isSphere() {
                    return CitySphere.isInSphere(chunkX, chunkZ, new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8), provider);
                }

                @Override
                public String getBiome() {
                    return provider.worldObj.func_180494_b(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8)).func_185359_l();
                }
            };
            String randomPart = building.getRandomPart(rand, conditionContext);
            this.floorTypes[i] = (BuildingPart)Validate.notNull((Object)AssetRegistries.PARTS.get(randomPart), (String)("Null part for " + randomPart), (Object[])new Object[0]);
            randomPart = building.getRandomPart2(rand, conditionContext);
            this.floorTypes2[i] = AssetRegistries.PARTS.get(randomPart);
            this.connectionAtX[i] = BuildingInfo.isCity(chunkX - 1, chunkZ, provider) && rand.nextFloat() < this.profile.BUILDING_DOORWAYCHANCE;
            this.connectionAtZ[i] = BuildingInfo.isCity(chunkX, chunkZ - 1, provider) && rand.nextFloat() < this.profile.BUILDING_DOORWAYCHANCE;
        }
        if (this.hasBuilding && this.floorsBelowGround > 0) {
            this.xRailCorridor = false;
            this.zRailCorridor = false;
        } else {
            this.xRailCorridor = rand.nextFloat() < this.profile.CORRIDOR_CHANCE;
            boolean bl = this.zRailCorridor = rand.nextFloat() < this.profile.CORRIDOR_CHANCE;
        }
        if (this.isCity) {
            this.xBridge = false;
            this.zBridge = false;
        } else {
            this.xBridge = rand.nextFloat() < this.profile.BRIDGE_CHANCE;
            boolean bl = this.zBridge = rand.nextFloat() < this.profile.BRIDGE_CHANCE;
        }
        this.railDungeon = rand.nextFloat() < this.profile.RAILWAY_DUNGEON_CHANCE ? (!this.hasBuilding || -3 < this.cityLevel - this.floorsBelowGround ? AssetRegistries.PARTS.get(this.getCityStyle().getRandomRailDungeon(rand)) : null) : null;
        this.frontType = rand.nextFloat() < this.profile.BUILDING_FRONTCHANCE ? AssetRegistries.PARTS.get(this.getCityStyle().getRandomFront(rand)) : null;
    }

    public boolean hasHorizontalMonorail() {
        if (this.horizontalMonorail == null) {
            this.horizontalMonorail = CitySphere.hasHorizontalMonorail(this.chunkX, this.chunkZ, this.provider);
        }
        return this.horizontalMonorail;
    }

    public boolean hasVerticalMonorail() {
        if (this.verticalMonorail == null) {
            this.verticalMonorail = CitySphere.hasVerticalMonorail(this.chunkX, this.chunkZ, this.provider);
        }
        return this.verticalMonorail;
    }

    public boolean hasMonorail() {
        return this.hasHorizontalMonorail() || this.hasVerticalMonorail();
    }

    private int getMaxcellars(LostCityChunkGenerator provider, CityStyle cs) {
        int maxcellars = this.profile.BUILDING_MAXCELLARS + this.cityLevel;
        if (this.buildingType.getMaxCellars() != -1) {
            maxcellars = Math.min(maxcellars, this.buildingType.getMaxCellars());
        }
        if (this.buildingType.getMinCellars() != -1) {
            maxcellars = Math.max(maxcellars, this.buildingType.getMinCellars());
        }
        if (cs.getMaxCellarCount() != null) {
            maxcellars = Math.min(maxcellars, cs.getMaxCellarCount());
        }
        if (cs.getMinCellarCount() != null) {
            maxcellars = Math.max(maxcellars, cs.getMinCellarCount());
        }
        return maxcellars;
    }

    private int getMinfloors(LostCityChunkGenerator provider, CityStyle cs) {
        int minfloors = this.profile.BUILDING_MINFLOORS + 1;
        if (this.buildingType.getMinFloors() != -1) {
            minfloors = Math.max(minfloors, this.buildingType.getMinFloors());
        }
        if (cs.getMinFloorCount() != null) {
            minfloors = Math.max(minfloors, cs.getMinFloorCount());
        }
        return minfloors;
    }

    private int getMaxfloors(LostCityChunkGenerator provider, CityStyle cs) {
        int maxfloors = this.profile.BUILDING_MAXFLOORS;
        if (this.buildingType.getMaxFloors() != -1) {
            maxfloors = Math.min(maxfloors, this.buildingType.getMaxFloors());
        }
        if (cs.getMaxFloorCount() != null) {
            maxfloors = Math.min(maxfloors, cs.getMaxFloorCount());
        }
        return maxfloors;
    }

    public int getHighwayXLevel() {
        return Highway.getXHighwayLevel(this.chunkX, this.chunkZ, this.provider, this.profile);
    }

    public int getHighwayZLevel() {
        return Highway.getZHighwayLevel(this.chunkX, this.chunkZ, this.provider, this.profile);
    }

    public static boolean isVoidChunk(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        if (provider.otherGenerator != null) {
            return false;
        }
        if (provider.getProfile().isFloating()) {
            if (provider.getHeightmap(chunkX, chunkZ).getHeight(8, 8) <= 0) {
                return true;
            }
            if (provider.getHeightmap(chunkX, chunkZ).getHeight(3, 3) <= 0) {
                return true;
            }
            if (provider.getHeightmap(chunkX, chunkZ).getHeight(12, 3) <= 0) {
                return true;
            }
            if (provider.getHeightmap(chunkX, chunkZ).getHeight(3, 12) <= 0) {
                return true;
            }
            return provider.getHeightmap(chunkX, chunkZ).getHeight(12, 12) <= 0;
        }
        return false;
    }

    public static int getCityLevel(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        if (provider.otherGenerator != null) {
            int height = provider.otherGenerator.getHeight(chunkX, chunkZ, 8, 8);
            return BuildingInfo.getLevelBasedOnHeight(height, provider.getProfile());
        }
        if (provider.getProfile().isSpace()) {
            return BuildingInfo.getCityLevelSpace(chunkX, chunkZ, provider);
        }
        if (provider.getProfile().isFloating()) {
            return BuildingInfo.getCityLevelFloating(chunkX, chunkZ, provider);
        }
        if (provider.getProfile().isCavern()) {
            return BuildingInfo.getCityLevelCavern(chunkX, chunkZ, provider);
        }
        return BuildingInfo.getCityLevelNormal(chunkX, chunkZ, provider, provider.getProfile());
    }

    private static int getCityLevelCavern(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        return BuildingInfo.getCityLevelFloating(chunkX, chunkZ, provider);
    }

    private static int getCityLevelSpace(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        if (CitySphere.intersectsWithCitySphere(chunkX, chunkZ, provider)) {
            float dist = CitySphere.getRelativeDistanceToCityCenter(chunkX, chunkZ, provider);
            Random rand = new Random(provider.seed + (long)chunkZ * 817505771L + (long)chunkX * 217645177L);
            rand.nextFloat();
            rand.nextFloat();
            if (dist < 0.3f) {
                return 2 + rand.nextInt(2);
            }
            if (dist < 0.4f) {
                return 1 + rand.nextInt(2);
            }
            if (dist < 0.6f) {
                return rand.nextInt(2);
            }
            return 0;
        }
        return BuildingInfo.getCityLevelNormal(chunkX, chunkZ, provider, provider.getOutsideProfile());
    }

    private static int getCityLevelNormal(int chunkX, int chunkZ, LostCityChunkGenerator provider, LostCityProfile profile) {
        Biome[] biomes = BiomeInfo.getBiomeInfo(provider, new ChunkCoord(provider.dimensionId, chunkX, chunkZ)).getBiomes();
        float h = 0.0f;
        for (Biome biome : biomes) {
            h += biome.func_185355_j();
        }
        int height = 0;
        height = h < 0.15f ? 70 : (h < 0.4f ? 79 : (h < 0.7f ? 88 : ((double)(h /= (float)biomes.length) < 1.3 ? 95 : 100)));
        return BuildingInfo.getLevelBasedOnHeight(height, profile);
    }

    private static int getCityLevelFloating(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        int h4;
        int h3;
        int h2;
        int h1;
        int cnt = 0;
        int h = 0;
        int h0 = provider.getHeightmap(chunkX, chunkZ).getHeight(8, 8);
        if (h0 > 1) {
            h += h0;
            ++cnt;
        }
        if ((h1 = provider.getHeightmap(chunkX, chunkZ).getHeight(3, 3)) > 1) {
            h += h1;
            ++cnt;
        }
        if ((h2 = provider.getHeightmap(chunkX, chunkZ).getHeight(12, 3)) > 1) {
            h += h2;
            ++cnt;
        }
        if ((h3 = provider.getHeightmap(chunkX, chunkZ).getHeight(3, 12)) > 1) {
            h += h3;
            ++cnt;
        }
        if ((h4 = provider.getHeightmap(chunkX, chunkZ).getHeight(12, 12)) > 1) {
            h += h4;
            ++cnt;
        }
        if (cnt > 0) {
            h /= cnt;
        }
        return BuildingInfo.getLevelBasedOnHeight(h, provider.getProfile());
    }

    private static int getLevelBasedOnHeight(int height, LostCityProfile profile) {
        if (height < profile.CITY_LEVEL0_HEIGHT) {
            return 0;
        }
        if (height < profile.CITY_LEVEL1_HEIGHT) {
            return 1;
        }
        if (height < profile.CITY_LEVEL2_HEIGHT) {
            return 2;
        }
        if (height < profile.CITY_LEVEL3_HEIGHT) {
            return 3;
        }
        return 4;
    }

    private Block getRandomDoor(Random rand) {
        BlockDoor doorBlock;
        switch (rand.nextInt(7)) {
            case 0: {
                doorBlock = Blocks.field_180412_aq;
                break;
            }
            case 1: {
                doorBlock = Blocks.field_180410_as;
                break;
            }
            case 2: {
                doorBlock = Blocks.field_180409_at;
                break;
            }
            case 3: {
                doorBlock = Blocks.field_180414_ap;
                break;
            }
            case 4: {
                doorBlock = Blocks.field_180413_ao;
                break;
            }
            case 5: {
                doorBlock = Blocks.field_180411_ar;
                break;
            }
            case 6: {
                doorBlock = Blocks.field_150454_av;
                break;
            }
            default: {
                doorBlock = Blocks.field_180413_ao;
            }
        }
        return doorBlock;
    }

    public boolean isStreetSection() {
        return this.isCity && !this.hasBuilding;
    }

    public boolean isElevatedParkSection() {
        if (!this.isStreetSection()) {
            return false;
        }
        if (!this.getXmin().isStreetSection()) {
            return false;
        }
        if (!this.getXmax().isStreetSection()) {
            return false;
        }
        if (!this.getZmin().isStreetSection()) {
            return false;
        }
        if (!this.getZmax().isStreetSection()) {
            return false;
        }
        int cnt = 0;
        cnt += this.getXmin().getZmin().isStreetSection() ? 1 : 0;
        cnt += this.getXmin().getZmax().isStreetSection() ? 1 : 0;
        cnt += this.getXmax().getZmin().isStreetSection() ? 1 : 0;
        return (cnt += this.getXmax().getZmax().isStreetSection() ? 1 : 0) >= 3;
    }

    private Direction getStairDirection() {
        if (!this.stairsCalculated) {
            this.stairsCalculated = true;
            this.stairDirection = this.streetType != StreetType.PARK && !this.hasBuilding && this.isCity ? (this.cityLevel == this.getXmin().cityLevel - 1 && !this.getXmin().hasBuilding && this.getXmin().isCity ? Direction.XMIN : (this.cityLevel == this.getXmax().cityLevel - 1 && !this.getXmax().hasBuilding && this.getXmax().isCity ? Direction.XMAX : (this.cityLevel == this.getZmin().cityLevel - 1 && !this.getZmin().hasBuilding && this.getZmin().isCity ? Direction.ZMIN : (this.cityLevel == this.getZmax().cityLevel - 1 && !this.getZmax().hasBuilding && this.getZmax().isCity ? Direction.ZMAX : null)))) : null;
        }
        return this.stairDirection;
    }

    public Direction getActualStairDirection() {
        if (!this.actualStairsCalculated) {
            this.actualStairsCalculated = true;
            this.actualStairDirection = this.getStairDirection();
            if (this.actualStairDirection != null) {
                block0: for (int cx = -1; cx <= 1; ++cx) {
                    for (int cz = -1; cz <= 1; ++cz) {
                        BuildingInfo adjacent;
                        if (cx == 0 && cz == 0 || (adjacent = BuildingInfo.getBuildingInfo(this.chunkX + cx, this.chunkZ + cz, this.provider)).getStairDirection() == null || !(adjacent.stairPriority > this.stairPriority)) continue;
                        this.actualStairDirection = null;
                        continue block0;
                    }
                }
            }
        }
        return this.actualStairDirection;
    }

    public BuildingPart hasBridge(LostCityChunkGenerator provider, Orientation orientation) {
        switch (orientation) {
            case X: {
                return this.hasXBridge(provider);
            }
            case Z: {
                return this.hasZBridge(provider);
            }
        }
        return null;
    }

    public BuildingPart hasXBridge(LostCityChunkGenerator provider) {
        if (this.xBridgeTypeCalculated) {
            return this.xBridgeType;
        }
        this.xBridgeTypeCalculated = true;
        this.xBridgeType = null;
        if (!this.xBridge) {
            return null;
        }
        if (!this.isSuitableForBridge(provider, this)) {
            return null;
        }
        if (this.chunkZ % 2 != 0 && (this.getZmin().hasXBridge(provider) != null || this.getZmax().hasXBridge(provider) != null)) {
            return null;
        }
        BuildingPart bt = this.bridgeType;
        BuildingInfo i = this.getXmin();
        while (!i.isCity && i.xBridge && this.isSuitableForBridge(provider, i)) {
            if (this.chunkZ % 2 != 0 && (i.getZmin().hasXBridge(provider) != null || i.getZmax().hasXBridge(provider) != null)) {
                return null;
            }
            bt = i.bridgeType;
            i = i.getXmin();
        }
        if (!i.isCity || i.hasBuilding || i.cityLevel > 0) {
            return null;
        }
        BuildingInfo minimum = i;
        i = this.getXmax();
        while (!i.isCity && i.xBridge && this.isSuitableForBridge(provider, i)) {
            if (this.chunkZ % 2 != 0 && (i.getZmin().hasXBridge(provider) != null || i.getZmax().hasXBridge(provider) != null)) {
                return null;
            }
            i = i.getXmax();
        }
        if (!i.isCity || i.hasBuilding || i.cityLevel > 0) {
            return null;
        }
        this.xBridgeType = bt;
        for (i = i.getXmin(); i != minimum; i = i.getXmin()) {
            i.xBridgeType = bt;
            i.xBridgeTypeCalculated = true;
            i.zBridgeType = null;
            i.zBridgeTypeCalculated = true;
        }
        return bt;
    }

    public BuildingPart hasZBridge(LostCityChunkGenerator provider) {
        if (this.zBridgeTypeCalculated) {
            return this.zBridgeType;
        }
        this.zBridgeTypeCalculated = true;
        this.zBridgeType = null;
        if (!this.zBridge) {
            return null;
        }
        if (!this.isSuitableForBridge(provider, this)) {
            return null;
        }
        if (this.hasXBridge(provider) != null) {
            return null;
        }
        if (this.chunkX % 2 != 0 && (this.getXmin().hasZBridge(provider) != null || this.getXmax().hasZBridge(provider) != null)) {
            return null;
        }
        BuildingPart bt = this.bridgeType;
        BuildingInfo i = this.getZmin();
        while (!i.isCity && i.zBridge && this.isSuitableForBridge(provider, i)) {
            if (i.hasXBridge(provider) != null) {
                return null;
            }
            if (this.chunkX % 2 != 0 && (i.getXmin().hasZBridge(provider) != null || i.getXmax().hasZBridge(provider) != null)) {
                return null;
            }
            bt = i.bridgeType;
            i = i.getZmin();
        }
        BuildingInfo minimum = i;
        if (!i.isCity || i.hasBuilding || i.cityLevel > 0) {
            return null;
        }
        i = this.getZmax();
        while (!i.isCity && i.zBridge && this.isSuitableForBridge(provider, i)) {
            if (i.hasXBridge(provider) != null) {
                return null;
            }
            if (this.chunkX % 2 != 0 && (i.getXmin().hasZBridge(provider) != null || i.getXmax().hasZBridge(provider) != null)) {
                return null;
            }
            i = i.getZmax();
        }
        if (!i.isCity || i.hasBuilding || i.cityLevel > 0) {
            return null;
        }
        this.zBridgeType = bt;
        for (i = i.getZmin(); i != minimum; i = i.getZmin()) {
            i.zBridgeType = bt;
            i.zBridgeTypeCalculated = true;
            i.xBridgeType = null;
            i.xBridgeTypeCalculated = true;
        }
        return bt;
    }

    public boolean isOcean() {
        if (this.isOcean != null) {
            return this.isOcean;
        }
        Biome[] biomes = BiomeInfo.getBiomeInfo(this.provider, new ChunkCoord(this.provider.dimensionId, this.chunkX, this.chunkZ)).getBiomes();
        this.isOcean = BuildingInfo.isOcean(biomes);
        return this.isOcean;
    }

    private static boolean isOcean(Biome[] biomes) {
        int cnt = 0;
        for (Biome biome : biomes) {
            if (biome != Biomes.field_76771_b && biome != Biomes.field_150575_M && biome != Biomes.field_76776_l) continue;
            ++cnt;
        }
        return cnt * 100 / biomes.length > 50;
    }

    private boolean isSuitableForBridge(LostCityChunkGenerator provider, BuildingInfo i) {
        if (provider.getProfile().isSpace() && this.hasMonorail()) {
            return false;
        }
        return i.cityLevel < this.cityLevel || LostCitiesTerrainGenerator.isWaterBiome(provider, i.coord);
    }

    public boolean hasXCorridor() {
        if (!this.xRailCorridor) {
            return false;
        }
        BuildingInfo i = this.getXmin();
        while (i.canRailGoThrough() && i.xRailCorridor) {
            i = i.getXmin();
        }
        if (!i.hasBuilding || i.floorsBelowGround == 0) {
            return false;
        }
        i = this.getXmax();
        while (i.canRailGoThrough() && i.xRailCorridor) {
            i = i.getXmax();
        }
        return i.hasBuilding && i.floorsBelowGround != 0;
    }

    public boolean hasZCorridor() {
        if (!this.zRailCorridor) {
            return false;
        }
        BuildingInfo i = this.getZmin();
        while (i.canRailGoThrough() && i.zRailCorridor) {
            i = i.getZmin();
        }
        if (!i.hasBuilding || i.floorsBelowGround == 0) {
            return false;
        }
        i = this.getZmax();
        while (i.canRailGoThrough() && i.zRailCorridor) {
            i = i.getZmax();
        }
        return i.hasBuilding && i.floorsBelowGround != 0;
    }

    public boolean canRailGoThrough() {
        if (!this.isCity) {
            return false;
        }
        if (!this.hasBuilding) {
            return true;
        }
        return this.floorsBelowGround == 0;
    }

    public boolean canWaterCorridorGoThrough() {
        if (!this.isCity) {
            return false;
        }
        if (!this.hasBuilding) {
            return true;
        }
        return this.floorsBelowGround <= 1;
    }

    public boolean doesRoadExtendTo() {
        boolean b;
        boolean bl = b = this.isCity && !this.hasBuilding;
        if (b) {
            return !this.isElevatedParkSection();
        }
        return false;
    }

    public static boolean hasRoadConnection(BuildingInfo i1, BuildingInfo i2) {
        if (!i1.doesRoadExtendTo()) {
            return false;
        }
        if (!i2.doesRoadExtendTo()) {
            return false;
        }
        return Math.abs(i1.cityLevel - i2.cityLevel) <= 0;
    }

    public static Random getBuildingRandom(int chunkX, int chunkZ, long seed) {
        QualityRandom rand = new QualityRandom(seed + (long)chunkZ * 341873128712L + (long)chunkX * 132897987541L);
        rand.nextFloat();
        rand.nextFloat();
        return rand;
    }

    public int localToGlobal(int l) {
        return l + this.cityLevel;
    }

    public int globalToLocal(int l) {
        return l - this.cityLevel;
    }

    public boolean hasConnectionAt(int level, Orientation orientation) {
        switch (orientation) {
            case X: {
                return this.hasConnectionAtX(level);
            }
            case Z: {
                return this.hasConnectionAtZ(level);
            }
        }
        throw new IllegalStateException("Cannot happen!");
    }

    public boolean hasFrontPartFrom(BuildingInfo adj) {
        StreetType st = this.streetType;
        boolean elevated = this.isElevatedParkSection();
        if (elevated) {
            st = StreetType.PARK;
        }
        if (adj.hasBuilding && adj.frontType != null && st == StreetType.NORMAL && this.cityLevel < adj.cityLevel + adj.getNumFloors()) {
            RailChunkType type = this.getRailInfo().getType();
            if (type == RailChunkType.STATION_UNDERGROUND) {
                return false;
            }
            if (type == RailChunkType.GOING_DOWN_ONE_FROM_SURFACE) {
                return false;
            }
            if (this.getMaxHighwayLevel() >= 0) {
                return false;
            }
            int local = adj.globalToLocal(this.cityLevel);
            return !adj.isValidFloor(local) || !adj.getFloor(local).getMetaBoolean("dontconnect");
        }
        return false;
    }

    public boolean hasConnectionAtX(int level) {
        if (!this.isCity) {
            return false;
        }
        if (this.building2x2Section == 1 || this.building2x2Section == 3) {
            return false;
        }
        if (level < 0 || level >= this.connectionAtX.length) {
            return false;
        }
        if (level < this.floorTypes.length && this.floorTypes[level].getMetaBoolean("dontconnect")) {
            return false;
        }
        if (this.getXmin().hasFrontPartFrom(this)) {
            return true;
        }
        return this.connectionAtX[level];
    }

    public boolean hasConnectionAtXFromStreet(int level) {
        if (!this.isCity) {
            return false;
        }
        if (this.building2x2Section == 1 || this.building2x2Section == 3) {
            return false;
        }
        if (level < 0 || level >= this.connectionAtX.length) {
            return false;
        }
        if (this.hasFrontPartFrom(this.getXmin())) {
            return true;
        }
        return this.connectionAtX[level];
    }

    public boolean hasConnectionAtZ(int level) {
        if (!this.isCity) {
            return false;
        }
        if (this.building2x2Section == 2 || this.building2x2Section == 3) {
            return false;
        }
        if (level < 0 || level >= this.connectionAtZ.length) {
            return false;
        }
        if (level < this.floorTypes.length && this.floorTypes[level].getMetaBoolean("dontconnect")) {
            return false;
        }
        if (this.getZmin().hasFrontPartFrom(this)) {
            return true;
        }
        return this.connectionAtZ[level];
    }

    public boolean hasConnectionAtZFromStreet(int level) {
        if (!this.isCity) {
            return false;
        }
        if (this.building2x2Section == 2 || this.building2x2Section == 3) {
            return false;
        }
        if (level < 0 || level >= this.connectionAtZ.length) {
            return false;
        }
        if (this.hasFrontPartFrom(this.getZmin())) {
            return true;
        }
        return this.connectionAtZ[level];
    }

    @Override
    public boolean isCity() {
        return this.isCity;
    }

    @Override
    public String getBuildingType() {
        return this.hasBuilding ? this.buildingType.getName() : null;
    }

    @Override
    public int getCityLevel() {
        return this.cityLevel;
    }

    @Override
    public int getNumFloors() {
        return this.floors;
    }

    @Override
    public int getNumCellars() {
        return this.floorsBelowGround;
    }

    @Override
    public float getDamage(int chunkY) {
        return this.getDamageArea().getDamage(this.chunkX * 16 + 8, chunkY * 16 + 8, this.chunkZ * 16 + 8);
    }

    @Override
    public Collection<ILostExplosion> getExplosions() {
        return new ArrayList<ILostExplosion>(this.getDamageArea().getExplosions());
    }

    @Override
    public int getMaxHighwayLevel() {
        return Math.max(this.getHighwayXLevel(), this.getHighwayZLevel());
    }

    @Override
    @Nonnull
    public RailChunkType getRailType() {
        return this.getRailInfo().getType();
    }

    @Override
    public int getRailLevel() {
        return this.getRailInfo().getLevel();
    }

    @Override
    @Nullable
    public ILostCityInfo getCityInfo() {
        if (City.isCityCenter(this.chunkX, this.chunkZ, this.provider)) {
            return new ILostCityInfo(){

                @Override
                public float getCityRadius() {
                    return City.getCityRadius(BuildingInfo.this.chunkX, BuildingInfo.this.chunkZ, BuildingInfo.this.provider);
                }

                @Override
                public String getCityStyle() {
                    return City.getCityStyleForCityCenter(BuildingInfo.this.chunkX, BuildingInfo.this.chunkZ, BuildingInfo.this.provider);
                }
            };
        }
        return null;
    }

    @Override
    public int getRuinLevel() {
        if (!this.profile.RUINS) {
            return -1;
        }
        if (this.ruinHeight < 0.0f) {
            return -1;
        }
        return (int)((float)(this.getCityGroundLevel() + 1) + this.ruinHeight * (float)this.getNumFloors() * 6.0f);
    }

    @Override
    @Nullable
    public ILostSphere getSphere() {
        CitySphere sphere = CitySphere.getCitySphere(this.chunkX, this.chunkZ, this.provider);
        if (sphere.isEnabled()) {
            return sphere;
        }
        return null;
    }

    public static enum StreetType {
        NORMAL,
        FULL,
        PARK;

    }

    public static class ConditionTodo {
        private final String condition;
        private final String part;
        private final String building;

        public ConditionTodo(String condition, String part, BuildingInfo info) {
            this.part = part == null ? "<none>" : part;
            this.condition = condition;
            this.building = info.hasBuilding ? info.getBuildingType() : "<none>";
        }

        public String getCondition() {
            return this.condition;
        }

        public String getPart() {
            return this.part;
        }

        public String getBuilding() {
            return this.building;
        }
    }
}

