/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world;

import mcjty.lostcities.config.LandscapeType;
import mcjty.lostcities.dimensions.world.driver.IPrimerDriver;
import mcjty.lostcities.dimensions.world.terraingen.LostCitiesTerrainGenerator;

public class ChunkHeightmap {
    private byte[] heightmap = new byte[256];

    public ChunkHeightmap(IPrimerDriver driver, LandscapeType type, int groundLevel, char baseChar) {
        char air = LostCitiesTerrainGenerator.airChar;
        if (type == LandscapeType.CAVERN) {
            int base = Math.max(groundLevel - 20, 1);
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int y;
                    driver.current(x, y, z);
                    for (y = base; y < 100 && driver.getBlock() != air; ++y) {
                        driver.incY();
                    }
                    if (y >= 100) {
                        y = 128;
                    } else {
                        while (y > 0 && driver.getBlock() == air) {
                            --y;
                            driver.decY();
                        }
                    }
                    this.heightmap[z * 16 + x] = (byte)y;
                }
            }
        } else if (type == LandscapeType.SPACE) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int y;
                    driver.current(x, y, z);
                    for (y = 255; y > 0 && driver.getBlock() != baseChar; --y) {
                        driver.decY();
                    }
                    this.heightmap[z * 16 + x] = (byte)y;
                }
            }
        } else {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int y;
                    driver.current(x, y, z);
                    for (y = 255; y > 0 && driver.getBlock() == air; --y) {
                        driver.decY();
                    }
                    this.heightmap[z * 16 + x] = (byte)y;
                }
            }
        }
    }

    public int getHeight(int x, int z) {
        return this.heightmap[z * 16 + x] & 0xFF;
    }

    public int getAverageHeight() {
        int cnt = 0;
        int y = 0;
        int yy = this.getHeight(2, 2);
        if (yy > 5) {
            y += yy;
            ++cnt;
        }
        if ((yy = this.getHeight(13, 2)) > 5) {
            y += yy;
            ++cnt;
        }
        if ((yy = this.getHeight(2, 13)) > 5) {
            y += yy;
            ++cnt;
        }
        if ((yy = this.getHeight(13, 13)) > 5) {
            y += yy;
            ++cnt;
        }
        if ((yy = this.getHeight(8, 8)) > 5) {
            y += yy;
            ++cnt;
        }
        if (cnt > 0) {
            return y / cnt;
        }
        return 0;
    }

    public int getMinimumHeight() {
        int y = 255;
        int yy = this.getHeight(2, 2);
        if (yy < y) {
            y = yy;
        }
        if ((yy = this.getHeight(13, 2)) < y) {
            y = yy;
        }
        if ((yy = this.getHeight(2, 13)) < y) {
            y = yy;
        }
        if ((yy = this.getHeight(13, 13)) < y) {
            y = yy;
        }
        if ((yy = this.getHeight(8, 8)) < y) {
            y = yy;
        }
        return y;
    }
}

