/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item.crafting;

import com.oblivioussp.spartanweaponry.item.ItemQuiverBase;
import com.oblivioussp.spartanweaponry.util.Log;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class QuiverUpgradeRecipe
extends ShapedRecipes {
    public QuiverUpgradeRecipe(String regName, String group, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(group, width, height, ingredients, result);
        this.setRegistryName("spartanweaponry", regName);
        this.validateRecipe();
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack resultStack = super.func_77572_b(inv);
        ItemStack quiverStack = ItemStack.field_190927_a;
        if (!(resultStack.func_77973_b() instanceof ItemQuiverBase)) {
            Log.error("Quiver upgrade recipe output is not a Quiver!");
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemQuiverBase)) continue;
            quiverStack = stack;
            break;
        }
        if (!quiverStack.func_190926_b()) {
            IItemHandler itemHandler = (IItemHandler)quiverStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            IItemHandler resultItemHandler = (IItemHandler)resultStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                resultItemHandler.insertItem(i, stack, false);
            }
            resultStack.func_77982_d(resultStack.func_77973_b().getNBTShareTag(resultStack));
        }
        return resultStack;
    }

    public void validateRecipe() {
        if (!(this.func_77571_b().func_77973_b() instanceof ItemQuiverBase)) {
            throw new IllegalArgumentException("Recipe \"" + this.getRegistryName().toString() + "\" has invalid output! Output must be a ItemQuiverBase item!");
        }
        int inputQuiverCount = 0;
        for (Ingredient ingredient : this.func_192400_c()) {
            ItemStack stack;
            if (ingredient.func_193365_a().length <= 0 || !((stack = ingredient.func_193365_a()[0]).func_77973_b() instanceof ItemQuiverBase)) continue;
            ++inputQuiverCount;
        }
        if (inputQuiverCount != 1) {
            throw new IllegalArgumentException("Recipe \"" + this.getRegistryName().toString() + "\" has invalid inputs! Input must contain only one ItemQuiverBase item!");
        }
    }
}

