/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.oblivioussp.spartanweaponry.api.IWeaponPropertyContainer;
import com.oblivioussp.spartanweaponry.api.ToolMaterialEx;
import com.oblivioussp.spartanweaponry.api.WeaponProperties;
import com.oblivioussp.spartanweaponry.api.weaponproperty.IPropertyCallback;
import com.oblivioussp.spartanweaponry.api.weaponproperty.WeaponProperty;
import com.oblivioussp.spartanweaponry.client.gui.CreativeTabsSW;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityThrownWeapon;
import com.oblivioussp.spartanweaponry.util.ConfigHandler;
import com.oblivioussp.spartanweaponry.util.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemSwordBase
extends ItemSword
implements IWeaponPropertyContainer<ItemSwordBase> {
    protected float attackDamage = 1.0f;
    protected double attackSpeed = 0.0;
    protected List<WeaponProperty> properties;
    protected ToolMaterialEx materialEx;
    protected String modId = null;
    protected String displayName = null;
    protected boolean doCraftCheck = true;
    protected boolean canBeCrafted = true;

    public ItemSwordBase(String unlocName, ToolMaterialEx material, float weaponBaseDamage, float weaponDamageMultiplier, double weaponSpeed, WeaponProperty ... weaponProperties) {
        super(material.getMaterial());
        this.func_77637_a(CreativeTabsSW.TAB_SW);
        this.setRegistryName(unlocName);
        this.func_77655_b(unlocName);
        this.materialEx = material;
        this.attackDamage = Math.max(0.5f, this.materialEx.getAttackDamage() * weaponDamageMultiplier + weaponBaseDamage - 1.0f);
        this.attackSpeed = weaponSpeed;
        this.properties = new ArrayList<WeaponProperty>();
        this.properties.addAll(Arrays.asList(weaponProperties));
    }

    public String func_77658_a() {
        if (this.modId != null) {
            return StringHelper.getItemUnlocalizedName(super.func_77658_a(), this.modId);
        }
        return StringHelper.getItemUnlocalizedName(super.func_77658_a());
    }

    public String func_77667_c(ItemStack itemStack) {
        if (this.modId != null) {
            return StringHelper.getItemUnlocalizedName(super.func_77658_a(), this.modId);
        }
        return StringHelper.getItemUnlocalizedName(super.func_77658_a());
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof EntityLivingBase) {
            IPropertyCallback callback;
            EntityLivingBase living = (EntityLivingBase)entity;
            if (this.properties != null) {
                for (WeaponProperty property : this.properties) {
                    callback = property.getCallback();
                    if (callback == null) continue;
                    callback.onItemUpdate(this.materialEx, stack, world, living, itemSlot, isSelected);
                }
            }
            if (this.materialEx.hasAnyWeaponProperty()) {
                for (WeaponProperty property : this.materialEx.getAllWeaponProperties()) {
                    callback = property.getCallback();
                    if (callback == null) continue;
                    callback.onItemUpdate(this.materialEx, stack, world, living, itemSlot, isSelected);
                }
            }
        }
    }

    public float func_150931_i() {
        return this.materialEx.getAttackDamage();
    }

    public int func_77619_b() {
        return this.materialEx.getEnchantability();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        if (toRepair.func_190926_b() || repair.func_190926_b()) {
            return false;
        }
        if (this.materialEx.doesOreDictMatch(repair)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public String func_150932_j() {
        return this.materialEx.getMaterial().toString();
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return this.materialEx.getEfficiency();
        }
        return super.func_150893_a(stack, state);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getDirectAttackDamage(), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.attackSpeed - 4.0, 0));
        }
        return multimap;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, EntityLivingBase entity, EntityLivingBase attacker) {
        return this.hasWeaponProperty(WeaponProperties.SHIELD_BREACH);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean isShiftPressed = GuiScreen.func_146272_n();
        if (this.doCraftCheck && worldIn != null) {
            NonNullList ores;
            if (this.materialEx.getModId() == "spartanweaponry" && ((ores = OreDictionary.getOres((String)this.materialEx.getOreDictForRepairMaterial(), (boolean)false)) == null || ores.isEmpty())) {
                this.canBeCrafted = false;
            }
            this.doCraftCheck = false;
        }
        if (!ConfigHandler.forceDisableUncraftableTooltips && !this.canBeCrafted) {
            tooltip.add(TextFormatting.RED + StringHelper.translateFormattedString("cantCraftMissingMaterial", "tooltip", "spartanweaponry", StringHelper.translateString(this.materialEx.getOreDictForRepairMaterial(), "material", this.materialEx.getModId())));
        }
        if (!this.properties.isEmpty() || this.materialEx.hasAnyWeaponProperty()) {
            tooltip.add(TextFormatting.GOLD + StringHelper.translateFormattedString("properties", "tooltip", "spartanweaponry", isShiftPressed ? TextFormatting.DARK_GRAY + StringHelper.translateString("showingDetails", "tooltip", "spartanweaponry") : TextFormatting.DARK_GRAY + StringHelper.translateFormattedString("showDetails", "tooltip", "spartanweaponry", TextFormatting.AQUA + "SHIFT" + TextFormatting.DARK_GRAY)));
        }
        for (WeaponProperty property : this.properties) {
            property.addTooltip(stack, tooltip, isShiftPressed);
        }
        if (this.materialEx.hasAnyWeaponProperty()) {
            tooltip.add(TextFormatting.DARK_AQUA + "Material Bonus:");
            for (WeaponProperty matProp : this.materialEx.getAllWeaponProperties()) {
                matProp.addTooltip(stack, tooltip, isShiftPressed);
            }
        }
        tooltip.add("");
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public String func_77653_i(ItemStack stack) {
        if (this.displayName != null) {
            String name = I18n.func_74837_a((String)String.format("item.%s:%s.name", "spartanweaponry", this.displayName), (Object[])new Object[]{I18n.func_74838_a((String)this.materialEx.getFullUnlocName())});
            return name;
        }
        return super.func_77653_i(stack);
    }

    @Override
    public float getDirectAttackDamage() {
        return this.attackDamage;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        IPropertyCallback callback;
        for (WeaponProperty prop : this.properties) {
            callback = prop.getCallback();
            if (callback == null) continue;
            callback.onHitEntity(this.materialEx, stack, target, attacker, null);
        }
        for (WeaponProperty prop : this.materialEx.getAllWeaponProperties()) {
            callback = prop.getCallback();
            if (callback == null) continue;
            callback.onHitEntity(this.materialEx, stack, target, attacker, null);
        }
        return super.func_77644_a(stack, target, attacker);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (this.getFirstWeaponPropertyWithType("throwable") != null) {
            ItemStack stack = playerIn.func_184586_b(hand);
            playerIn.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (this.getFirstWeaponPropertyWithType("throwable") != null && entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            int charge = this.func_77626_a(stack) - timeLeft;
            if (charge >= 5) {
                charge = 5;
            }
            if (!worldIn.field_72995_K && charge > 2) {
                int k;
                int j;
                EntityThrownWeapon thrown = new EntityThrownWeapon(worldIn, (EntityLivingBase)player);
                thrown.setWeapon(stack);
                thrown.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f * ((float)charge / 10.0f + 0.5f), 0.5f);
                thrown.func_70239_b((double)this.getDirectAttackDamage() + 1.0);
                double damageModifier = 0.0;
                if (Loader.isModLoaded((String)"somanyenchantments")) {
                    Enchantment supSharpness = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation("somanyenchantments:supremesharpness"));
                    Enchantment advSharpness = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation("somanyenchantments:advancedsharpness"));
                    Enchantment lesSharpness = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation("somanyenchantments:lessersharpness"));
                    int j2 = EnchantmentHelper.func_77506_a((Enchantment)supSharpness, (ItemStack)stack);
                    if (j2 > 0) {
                        damageModifier = 4.0 + (double)j2 * 1.6;
                    } else {
                        j2 = EnchantmentHelper.func_77506_a((Enchantment)advSharpness, (ItemStack)stack);
                        if (j2 > 0) {
                            damageModifier = 1.25 + (double)j2 * 0.95;
                        } else {
                            j2 = EnchantmentHelper.func_77506_a((Enchantment)lesSharpness, (ItemStack)stack);
                            if (j2 > 0) {
                                damageModifier = 0.25 + (double)j2 * 0.25;
                            }
                        }
                    }
                }
                if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)stack)) > 0) {
                    damageModifier = 0.5 + (double)j * 0.5;
                }
                if (damageModifier > 0.0) {
                    thrown.func_70239_b(thrown.func_70242_d() + damageModifier);
                }
                if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)stack)) > 0) {
                    thrown.func_70240_a(k);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)stack) > 0) {
                    thrown.func_70015_d(100);
                }
                if (player.field_71075_bZ.field_75098_d) {
                    thrown.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                } else if (thrown.isValidThrowingWeapon()) {
                    stack.func_190920_e(stack.func_190916_E() - 1);
                    if (stack.func_190916_E() <= 0) {
                        player.field_71071_by.func_184437_d(stack);
                    }
                }
                if (thrown.isValidThrowingWeapon()) {
                    worldIn.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187827_fP, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                    worldIn.func_72838_d((Entity)thrown);
                }
                player.func_71029_a(StatList.func_188057_b((Item)this));
            }
        }
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
    }

    public int func_77626_a(ItemStack stack) {
        if (this.getFirstWeaponPropertyWithType("throwable") != null) {
            return 72000;
        }
        return super.func_77626_a(stack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (this.getFirstWeaponPropertyWithType("throwable") != null) {
            return EnumAction.BOW;
        }
        return super.func_77661_b(stack);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        IPropertyCallback callback;
        for (WeaponProperty prop : this.properties) {
            callback = prop.getCallback();
            if (callback == null) continue;
            callback.onCreateItem(this.materialEx, stack);
        }
        for (WeaponProperty prop : this.materialEx.getAllWeaponProperties()) {
            callback = prop.getCallback();
            if (callback == null) continue;
            callback.onCreateItem(this.materialEx, stack);
        }
        super.func_77622_d(stack, worldIn, playerIn);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            IPropertyCallback callback;
            ItemStack stack = new ItemStack((Item)this);
            for (WeaponProperty prop : this.properties) {
                callback = prop.getCallback();
                if (callback == null) continue;
                callback.onCreateItem(this.materialEx, stack);
            }
            for (WeaponProperty prop : this.materialEx.getAllWeaponProperties()) {
                callback = prop.getCallback();
                if (callback == null) continue;
                callback.onCreateItem(this.materialEx, stack);
            }
            items.add((Object)stack);
        }
    }

    @Nullable
    public String getCreatorModId(ItemStack itemStack) {
        if (this.modId != null) {
            return this.modId;
        }
        return super.getCreatorModId(itemStack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        WeaponProperty prop = this.getFirstWeaponPropertyWithType("sweep_damage");
        boolean isSweepCompatible = prop != null && prop.getLevel() == 1;
        return enchantment == Enchantments.field_191530_r && isSweepCompatible || enchantment != Enchantments.field_191530_r && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    public ItemSwordBase addWeaponProperty(WeaponProperty prop) {
        this.properties.add(prop);
        return this;
    }

    @Override
    public boolean hasWeaponProperty(WeaponProperty prop) {
        return this.properties.contains(prop) || this.materialEx.getAllWeaponProperties().contains(prop);
    }

    @Override
    public WeaponProperty getFirstWeaponPropertyWithType(String type) {
        for (WeaponProperty property : this.properties) {
            if (property.getType() != type) continue;
            return property;
        }
        for (WeaponProperty property : this.materialEx.getAllWeaponProperties()) {
            if (property.getType() != type) continue;
            return property;
        }
        return null;
    }

    @Override
    public List<WeaponProperty> getAllWeaponPropertiesWithType(String type) {
        ArrayList<WeaponProperty> result = new ArrayList<WeaponProperty>();
        for (WeaponProperty property : this.properties) {
            if (property.getType() != type) continue;
            result.add(property);
        }
        for (WeaponProperty property : this.materialEx.getAllWeaponProperties()) {
            if (property.getType() != type) continue;
            result.add(property);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    @Override
    public List<WeaponProperty> getAllWeaponProperties() {
        return new ArrayList<WeaponProperty>(this.properties);
    }

    @Override
    public ToolMaterialEx getMaterialEx() {
        return this.materialEx;
    }
}

