/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.entity.projectile;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.oblivioussp.spartanweaponry.util.ConfigHandler;
import com.oblivioussp.spartanweaponry.util.ExplosionHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityDynamite
extends EntityThrowable {
    private static final Predicate<Entity> VALID_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(Entity input) {
            return input.func_70067_L();
        }
    }});
    protected int timer;
    protected boolean stuckToSomething = false;
    protected int fuseTicks = ConfigHandler.fuseTicksDynamite;
    protected int ignoreTime = 0;

    public EntityDynamite(World worldIn) {
        super(worldIn);
    }

    public EntityDynamite(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityDynamite(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        this.func_70030_z();
        Vec3d currentPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d nextPos = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult rayTrace = this.field_70170_p.func_147447_a(currentPos, nextPos, false, true, false);
        if (rayTrace != null) {
            nextPos = new Vec3d(rayTrace.field_72307_f.field_72450_a, rayTrace.field_72307_f.field_72448_b, rayTrace.field_72307_f.field_72449_c);
        }
        Entity hitEntity = null;
        double distanceToEntity = 0.0;
        boolean ignoreChosenEntity = false;
        List nearbyEntities = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), VALID_TARGETS);
        for (Entity entityToCheck : nearbyEntities) {
            double sqDist;
            if (entityToCheck == this.field_184539_c) {
                ignoreChosenEntity = true;
                continue;
            }
            if (this.field_70192_c != null && this.field_70173_aa < 2 && this.field_184539_c == null) {
                this.field_184539_c = entityToCheck;
                ignoreChosenEntity = true;
                continue;
            }
            ignoreChosenEntity = false;
            AxisAlignedBB aabb = entityToCheck.func_174813_aQ().func_186662_g(0.3);
            RayTraceResult interceptResult = aabb.func_72327_a(currentPos, nextPos);
            if (interceptResult == null || !((sqDist = currentPos.func_72436_e(interceptResult.field_72307_f)) < distanceToEntity) && distanceToEntity != 0.0) continue;
            hitEntity = entityToCheck;
            distanceToEntity = sqDist;
        }
        if (this.field_184539_c != null) {
            if (ignoreChosenEntity) {
                this.ignoreTime = 2;
            } else if (this.ignoreTime-- <= 0) {
                this.field_184539_c = null;
            }
        }
        if (hitEntity != null) {
            rayTrace = new RayTraceResult(hitEntity);
        }
        if (rayTrace != null) {
            if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(rayTrace.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(rayTrace.func_178782_a());
            } else if (!ForgeEventFactory.onProjectileImpact((EntityThrowable)this, (RayTraceResult)rayTrace)) {
                this.func_70184_a(rayTrace);
            }
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.stuckToSomething) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        } else if (this.field_70122_E) {
            this.field_70159_w *= 0.7;
            this.field_70179_y *= 0.7;
            this.field_70181_x *= -0.5;
        }
        if (!this.func_189652_ae() && !this.stuckToSomething) {
            this.field_70181_x -= 0.05;
        }
        ++this.timer;
        if (this.timer >= this.fuseTicks) {
            ExplosionHelper.explode((Entity)this, (Entity)this.field_70192_c, this.func_180425_c());
        } else {
            double friction = 0.99;
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                friction = 0.6;
            }
            this.field_70159_w *= friction;
            this.field_70181_x *= friction;
            this.field_70179_y *= friction;
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.25, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    protected void func_70184_a(RayTraceResult result) {
    }
}

