/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.entity.projectile;

import com.oblivioussp.spartanweaponry.entity.projectile.EntityThrownWeapon;
import com.oblivioussp.spartanweaponry.init.SoundRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityBoomerang
extends EntityThrownWeapon {
    protected final String NBT_RETURN_POS = "returnPos";
    protected final String NBT_X = "x";
    protected final String NBT_Y = "y";
    protected final String NBT_Z = "z";
    protected final String NBT_IS_RETURNING = "isReturning";
    protected final String NBT_MAX_DISTANCE = "maxDistance";
    protected final double MAX_VELOCITY = 2.0;
    protected final double VELOCITY_PER_TICK = 0.1;
    public static final double MAX_DISTANCE_LIMIT = 5.0;
    protected final double DEFAULT_DISTANCE = 5.0;
    protected Vec3d returnPos = null;
    protected boolean isReturning = false;
    protected double maxDistance = 5.0;
    protected int ticksUntilSound = 0;
    protected final int TICKS_PER_SOUND = 5;

    public EntityBoomerang(World world) {
        super(world);
        this.func_189654_d(true);
    }

    public EntityBoomerang(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.func_189654_d(true);
    }

    public EntityBoomerang(World world, EntityLivingBase shooter) {
        super(world, shooter);
        this.func_189654_d(true);
        this.maxDistance = 5.0;
        this.returnPos = new Vec3d(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() * 0.9 - 0.1, shooter.field_70161_v);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.returnPos != null) {
            NBTTagCompound returnPosTag = new NBTTagCompound();
            returnPosTag.func_74780_a("x", this.returnPos.field_72450_a);
            returnPosTag.func_74780_a("y", this.returnPos.field_72448_b);
            returnPosTag.func_74780_a("z", this.returnPos.field_72449_c);
            compound.func_74782_a("returnPos", (NBTBase)returnPosTag);
            compound.func_74780_a("maxDistance", this.maxDistance);
        } else {
            compound.func_82580_o("returnPos");
        }
        compound.func_74757_a("isReturning", this.isReturning);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("returnPos")) {
            NBTTagCompound returnPosTag = compound.func_74775_l("returnPos");
            if (returnPosTag != null && !returnPosTag.func_82582_d()) {
                double x = returnPosTag.func_74769_h("x");
                double y = returnPosTag.func_74769_h("y");
                double z = returnPosTag.func_74769_h("z");
                this.returnPos = new Vec3d(x, y, z);
            } else {
                this.returnPos = null;
            }
            this.maxDistance = compound.func_74769_h("maxDistance");
        } else {
            this.returnPos = null;
        }
        this.isReturning = compound.func_74767_n("isReturning");
    }

    public void setMaxDistance(double distance) {
        this.maxDistance = distance;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70254_i) {
            return;
        }
        if (this.field_70250_c != null) {
            this.returnPos = new Vec3d(this.field_70250_c.field_70165_t, this.field_70250_c.field_70163_u + (double)this.field_70250_c.func_70047_e() * 0.9 - 0.1, this.field_70250_c.field_70161_v);
        }
        double distance = -1.0;
        if (this.returnPos != null) {
            distance = this.returnPos.func_72438_d(this.func_174791_d());
        }
        if (this.func_189652_ae()) {
            if (distance < 1.0 && this.isReturning || this.field_70171_ac || this.returnPos == null) {
                this.func_189654_d(false);
            }
            if (distance > this.maxDistance && !this.isReturning) {
                this.isReturning = true;
            }
            if (this.isReturning && this.returnPos != null) {
                Vec3d distanceVec = this.func_174791_d().func_178788_d(this.returnPos);
                double length = distanceVec.func_72433_c();
                if (length < 5.0) {
                    this.field_70159_w = -distanceVec.field_72450_a / length;
                    this.field_70181_x = -distanceVec.field_72448_b / length;
                    this.field_70179_y = -distanceVec.field_72449_c / length;
                } else {
                    this.field_70159_w -= 0.1 * (distanceVec.field_72450_a / length);
                    this.field_70181_x -= 0.1 * (distanceVec.field_72448_b / length);
                    this.field_70179_y -= 0.1 * (distanceVec.field_72449_c / length);
                }
            }
            --this.ticksUntilSound;
            if (this.ticksUntilSound <= 0) {
                this.ticksUntilSound = 5;
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundRegistry.BOOMERANG_FLIGHT, SoundCategory.NEUTRAL, 2.0f, 0.5f);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 200) {
            if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED) {
                this.dropAsItem();
            }
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && !this.field_70254_i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT_MAGIC, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_184548_a(EntityLivingBase entity) {
        this.isReturning = true;
    }

    @Override
    protected void func_184549_a(RayTraceResult rayTrace) {
        if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && this.func_189652_ae()) {
            BlockPos blockPos = rayTrace.func_178782_a();
            IBlockState blockState = this.field_70170_p.func_180495_p(blockPos);
            Vec3i faceNormali = rayTrace.field_178784_b.func_176730_m();
            Vec3d faceNormalVec = new Vec3d((double)faceNormali.func_177958_n(), (double)faceNormali.func_177956_o(), (double)faceNormali.func_177952_p());
            Vec3d motionVec = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            faceNormalVec.func_72432_b();
            Vec3d reflectVec = faceNormalVec.func_186678_a(2.0 * motionVec.func_72430_b(faceNormalVec)).func_178788_d(motionVec);
            Vec3d bounceVec = reflectVec.func_186678_a(-0.75);
            this.field_70159_w = bounceVec.field_72450_a;
            this.field_70181_x = bounceVec.field_72448_b;
            this.field_70179_y = bounceVec.field_72449_c;
            this.func_184185_a(SoundEvents.field_187724_dU, 1.0f, 2.2f / this.field_70146_Z.nextFloat() * 0.2f + 0.9f);
            if (!this.field_70170_p.field_72995_K) {
                ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5, 0.1, 0.1, 0.1, 0.05, new int[]{Block.func_149682_b((Block)this.field_70170_p.func_180495_p(blockPos).func_177230_c())});
            }
            if (blockState.func_185904_a() != Material.field_151579_a) {
                blockState.func_177230_c().func_180634_a(this.field_70170_p, blockPos, blockState, (Entity)this);
            }
        } else {
            super.func_184549_a(rayTrace);
        }
    }

    @Override
    protected boolean canBeCaughtInMidair(Entity shooter, Entity entityHit) {
        return shooter.func_70028_i(entityHit);
    }

    public boolean isInGround() {
        return this.field_70254_i;
    }
}

