/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.compat.rlcombat;

import bettercombat.mod.event.RLCombatModifyDamageEvent;
import bettercombat.mod.event.RLCombatSweepEvent;
import com.oblivioussp.spartanweaponry.api.IWeaponPropertyContainer;
import com.oblivioussp.spartanweaponry.api.weaponproperty.WeaponProperty;
import com.oblivioussp.spartanweaponry.util.ConfigHandler;
import com.oblivioussp.spartanweaponry.util.EntityDamageSourceArmorPiercing;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandlerRLCombat {
    @SubscribeEvent
    public void onModifyDamage(RLCombatModifyDamageEvent.Post ev) {
        ItemStack weaponStack = ev.getStack();
        if (weaponStack.func_77973_b() instanceof IWeaponPropertyContainer) {
            IWeaponPropertyContainer weaponItem = (IWeaponPropertyContainer)weaponStack.func_77973_b();
            WeaponProperty armourPiercingProp = weaponItem.getFirstWeaponPropertyWithType("armour_piercing");
            if (armourPiercingProp != null) {
                boolean isPlayer = ev.getEntityPlayer() != null;
                EntityDamageSourceArmorPiercing source = new EntityDamageSourceArmorPiercing(isPlayer ? "player" : "mob", (Entity)(isPlayer ? ev.getEntityPlayer() : ev.getEntityLiving()), armourPiercingProp.getMagnitude() / 100.0f);
                ev.setDamageSource((DamageSource)source);
            }
            if (ConfigHandler.damageBonusRidingCheckSpeed && weaponItem.getFirstWeaponPropertyWithType("extra_damage_riding") != null) {
                Vec3d motionVec = new Vec3d(ev.getMotionX(), ev.getMotionY() + 0.0784000015258789, ev.getMotionZ());
                ev.getEntityPlayer().getEntityData().func_74776_a("spartanweaponry_RidingSpeed", (float)motionVec.func_72433_c());
            }
        }
    }

    @SubscribeEvent
    public void onSweepAttack(RLCombatSweepEvent ev) {
        ItemStack weaponStack = ev.getItemStack();
        if (weaponStack.func_77973_b() instanceof IWeaponPropertyContainer) {
            IWeaponPropertyContainer weaponItem = (IWeaponPropertyContainer)weaponStack.func_77973_b();
            WeaponProperty sweepProp = weaponItem.getFirstWeaponPropertyWithType("wide_sweep");
            if (sweepProp == null) {
                sweepProp = weaponItem.getFirstWeaponPropertyWithType("sweep_damage");
            }
            if (sweepProp != null) {
                if (sweepProp.getMagnitude() > 1.0f) {
                    float modifier = sweepProp.getMagnitude() / 100.0f;
                    float directDmg = ev.getBaseDamage() * modifier;
                    ev.setSweepModifier(Math.max(ev.getSweepModifier(), modifier *= (directDmg - 1.0f) / directDmg));
                }
                if (sweepProp.getType() == "wide_sweep") {
                    AxisAlignedBB sweepingAABB = ev.getSweepingAABB().func_186662_g((double)ConfigHandler.wideSweepAdditionalRange);
                    ev.setSweepingAABB(sweepingAABB);
                }
            } else {
                ev.setDoSweep(false);
            }
        }
    }
}

