/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import svenhjol.charm.world.feature.TotemOfReturning;
import svenhjol.meson.helper.ItemNBTHelper;
import svenhjol.meson.helper.PlayerHelper;
import svenhjol.meson.helper.SoundHelper;
import svenhjol.meson.iface.IMesonItem;

public class ItemTotemOfReturning
extends Item
implements IMesonItem {
    private static final String POS = "pos";
    private static final String DIM = "dim";
    private static final String USES = "uses";

    public ItemTotemOfReturning() {
        this.register("totem_of_returning");
        this.func_77637_a(CreativeTabs.field_78029_e);
        this.func_77625_d(1);
    }

    @Override
    public String getModId() {
        return "charm";
    }

    public boolean func_77636_d(ItemStack stack) {
        return ItemTotemOfReturning.getPos(stack) != null;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        BlockPos pos = ItemTotemOfReturning.getPos(stack);
        int dim = ItemTotemOfReturning.getDim(stack);
        int uses = ItemTotemOfReturning.getUses(stack);
        if (pos == null || player.func_70093_af()) {
            BlockPos playerPos = player.func_180425_c();
            int playerDim = player.field_71093_bK;
            ItemTotemOfReturning.setPos(stack, playerPos);
            ItemTotemOfReturning.setDim(stack, playerDim);
            SoundHelper.playSoundAtPos(world, playerPos, SoundEvents.field_190021_aL, 1.0f, 0.8f);
            return super.func_77659_a(world, player, hand);
        }
        PlayerHelper.teleportPlayer(player, pos, dim);
        if (uses > 1) {
            ItemTotemOfReturning.setUses(stack, uses - 1);
            SoundHelper.playSoundAtPos(world, pos, SoundEvents.field_187791_eX, 0.8f, 1.0f);
        } else {
            stack.func_190918_g(1);
            SoundHelper.playSoundAtPos(world, pos, SoundEvents.field_191263_gW, 0.8f, 1.0f);
        }
        return super.func_77659_a(world, player, hand);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int uses = ItemTotemOfReturning.getUses(stack);
        TextFormatting color = uses == 1 ? TextFormatting.RED : TextFormatting.GREEN;
        tooltip.add(color + I18n.func_135052_a((String)"number_of_uses", (Object[])new Object[0]) + ": " + uses);
        BlockPos pos = ItemTotemOfReturning.getPos(stack);
        if (pos != null) {
            String x = String.valueOf(pos.func_177958_n());
            String y = String.valueOf(pos.func_177956_o());
            String z = String.valueOf(pos.func_177952_p());
            String dim = String.valueOf(ItemTotemOfReturning.getDim(stack));
            tooltip.add(TextFormatting.BLUE + x + " " + y + " " + z + ", " + I18n.func_135052_a((String)"dimension", (Object[])new Object[0]) + " " + dim);
        }
    }

    public static void setPos(ItemStack stack, BlockPos pos) {
        ItemNBTHelper.setLong(stack, POS, pos.func_177986_g());
    }

    public static void setDim(ItemStack stack, int dim) {
        ItemNBTHelper.setInt(stack, DIM, dim);
    }

    public static void setUses(ItemStack stack, int uses) {
        ItemNBTHelper.setInt(stack, USES, uses);
    }

    public static BlockPos getPos(ItemStack stack) {
        long pos = ItemNBTHelper.getLong(stack, POS, 0L);
        return pos == 0L ? null : BlockPos.func_177969_a((long)pos);
    }

    public static int getDim(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, DIM, 0);
    }

    public static int getUses(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, USES, TotemOfReturning.numberOfUses);
    }
}

