/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.decorator.outer;

import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmLootTables;
import svenhjol.charm.crafting.feature.Barrel;
import svenhjol.charm.crafting.feature.Composter;
import svenhjol.charm.crafting.tile.TileBarrel;
import svenhjol.charm.world.compat.FutureMcBlocks;
import svenhjol.charm.world.compat.ItemHandlerLootTableFiller;
import svenhjol.charm.world.feature.VillageDecorations;
import svenhjol.meson.decorator.MesonOuterDecorator;

public class Barrels
extends MesonOuterDecorator {
    public Barrels(World world, BlockPos pos, Random rand, List<ChunkPos> chunks) {
        super(world, pos, rand, chunks);
    }

    @Override
    public void generate() {
        if (!Charm.hasFeature(Barrel.class) && !Charm.hasFeature(Composter.class)) {
            return;
        }
        ResourceLocation loot = CharmLootTables.VILLAGE_FARMER;
        int max = 1;
        for (int i = 0; i < max; ++i) {
            boolean grassBelow;
            int zz;
            if ((double)this.rand.nextFloat() < VillageDecorations.barrelsWeight) continue;
            int xx = this.rand.nextInt(16) + 8;
            BlockPos current = this.world.func_175645_m(this.pos.func_177982_a(xx, 0, zz = this.rand.nextInt(16) + 8));
            boolean airAbove = this.world.func_180495_p(current) == Blocks.field_150350_a.func_176223_P();
            boolean bl = grassBelow = this.world.func_180495_p(current.func_177972_a(EnumFacing.DOWN)) == Blocks.field_150349_c.func_176223_P();
            if (!airAbove || !grassBelow) continue;
            if (this.rand.nextFloat() < 0.5f) {
                IItemHandler capability;
                TileEntity tile;
                if (Charm.hasFeature(Barrel.class)) {
                    this.world.func_175656_a(current, Barrel.block.func_176223_P());
                    tile = this.world.func_175625_s(current);
                    if (!(tile instanceof TileBarrel)) continue;
                    ((TileBarrel)tile).setLootTable(loot);
                    continue;
                }
                if (FutureMcBlocks.barrel == null) continue;
                this.world.func_175656_a(current, FutureMcBlocks.barrel.func_176223_P());
                if (!this.world.field_72995_K || (tile = this.world.func_175625_s(current)) == null || (capability = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) == null) continue;
                ItemHandlerLootTableFiller.fillWithLoot(capability, this.world, loot, 0);
                continue;
            }
            if (Charm.hasFeature(Composter.class)) {
                this.world.func_175656_a(current, Composter.composter.func_176223_P());
                continue;
            }
            if (FutureMcBlocks.composter == null) continue;
            this.world.func_175656_a(current, FutureMcBlocks.composter.func_176223_P());
        }
    }
}

