/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.smithing.feature;

import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import svenhjol.meson.Feature;

public class ExtractBookXP
extends Feature {
    public static int minXpBottles;
    public static int xpCost;

    @Override
    public String getDescription() {
        return "Combine an Enchanted Book with empty bottles on an anvil to get Bottles o' Enchanting.\nThe more levels and enchantments the book has, the more bottles are returned.";
    }

    @Override
    public void configure() {
        super.configure();
        minXpBottles = this.propInt("Minimum required bottles", "The minimum number of glass bottles needed when converting enchantments.", 5);
        xpCost = this.propInt("XP cost", "Amount of XP (levels) to activate the conversion of enchantments into Bottles o' Enchanting.", 0);
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack in = event.getLeft();
        ItemStack combine = event.getRight();
        if (!in.func_190926_b() && !combine.func_190926_b() && in.func_77973_b() == Items.field_151134_bR && combine.func_77973_b() == Items.field_151069_bo && in.func_190916_E() == 1) {
            int emptyBottles = combine.func_190916_E();
            int xpBottles = minXpBottles;
            NBTTagList enchants = ItemEnchantedBook.func_92110_g((ItemStack)in);
            for (int i = 0; i < enchants.func_74745_c(); ++i) {
                NBTTagCompound cmp = enchants.func_150305_b(i);
                int lvl = cmp.func_74762_e("lvl");
                xpBottles = (int)((double)xpBottles + Math.pow(lvl, 2.0));
            }
            ItemStack out = new ItemStack(Items.field_151062_by, Math.min(emptyBottles, xpBottles));
            event.setCost(xpCost);
            event.setMaterialCost(Math.min(emptyBottles, xpBottles));
            event.setOutput(out);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

