/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.enchanting.feature;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import svenhjol.charm.enchanting.enchantment.EnchantmentSalvage;
import svenhjol.meson.Feature;
import svenhjol.meson.helper.EnchantmentHelper;
import svenhjol.meson.helper.SoundHelper;

public class Salvage
extends Feature {
    public static EnchantmentSalvage enchantment;
    public static int minEnchantability;
    public static Map<UUID, ItemStack> ignoreEquipped;

    @Override
    public String getDescription() {
        return "An item with the Salvage enchantment does not disappear when its durability is depleted, giving you a chance to get it repaired.\nIf the item runs out of durability the player will drop it and must be picked up again.  Watch out for lava.";
    }

    @Override
    public void configure() {
        super.configure();
        minEnchantability = 5;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        enchantment = new EnchantmentSalvage();
    }

    @SubscribeEvent
    public void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        if (!event.getWorld().field_72995_K && event.getEntityPlayer() != null && event.getItemStack().func_77973_b() instanceof ItemArmor && EnchantmentHelper.hasEnchantment(enchantment, event.getItemStack())) {
            ignoreEquipped.put(event.getEntityPlayer().func_110124_au(), event.getItemStack().func_77946_l());
        }
    }

    @SubscribeEvent
    public void onDestroy(PlayerDestroyItemEvent event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K && EnchantmentHelper.hasEnchantment(enchantment, event.getOriginal())) {
            EntityPlayer player = event.getEntityPlayer();
            UUID playerId = player.func_110124_au();
            ItemStack item = event.getOriginal();
            if (ignoreEquipped.containsKey(playerId)) {
                ItemStack ignored = ignoreEquipped.get(playerId);
                ignoreEquipped.remove(playerId);
                if (ItemStack.func_77989_b((ItemStack)ignored, (ItemStack)item)) {
                    return;
                }
            }
            Salvage.dropItem(player, item);
        }
    }

    public static void dropItem(EntityPlayer player, ItemStack stack) {
        stack.func_77964_b(stack.func_77958_k());
        player.func_71019_a(stack, false);
        SoundHelper.playerSound(player, SoundEvents.field_187689_f, 0.5f, 1.5f, 0.15f, null);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static {
        ignoreEquipped = new HashMap<UUID, ItemStack>();
    }
}

