/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.handler.OverrideRegistryHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.world.block.BlockVariantLeaves;
import vazkii.quark.world.block.BlockVariantSapling;
import vazkii.quark.world.world.SakuraTreeGenerator;
import vazkii.quark.world.world.tree.WorldGenSwampTree;

public class TreeVariants
extends Feature {
    public static Block variant_leaves;
    public static Block variant_sapling;
    public static boolean enableSwamp;
    public static boolean enableSakura;
    public static boolean changeVineColor;
    public static double sakuraChance;

    @Override
    public void setupConfig() {
        enableSwamp = this.loadPropBool("Enable Swamp", "", true);
        enableSakura = this.loadPropBool("Enable Blossom", "", true);
        changeVineColor = this.loadPropBool("Change vine color in swamps", "", true);
        sakuraChance = this.loadPropChance("Blossom Tree Chance", "The chance per chunk for a Oak Blossom Tree to spawn (0 is 0%, 1 is 100%). This can be higher than 1 if you want multiple per chunk.", 0.05);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        variant_leaves = new BlockVariantLeaves();
        variant_sapling = new BlockVariantSapling();
        if (enableSwamp) {
            try {
                Field f = ObfuscationReflectionHelper.findField(Biome.class, (String)"field_76763_Q");
                OverrideRegistryHandler.crackFinalField(f);
                f.set(null, (Object)new WorldGenSwampTree(true));
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }
        if (enableSakura) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new SakuraTreeGenerator(), (int)0);
        }
        TreeVariants.addOreDict("treeLeaves", ProxyRegistry.newStack((Block)variant_leaves, (int)1, (int)Short.MAX_VALUE));
        TreeVariants.addOreDict("treeSapling", ProxyRegistry.newStack((Block)variant_sapling, (int)1, (int)Short.MAX_VALUE));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postInitClient() {
        if (changeVineColor) {
            BlockColors colors = Minecraft.func_71410_x().func_184125_al();
            IBlockColor parent = (state, worldIn, pos, tintIndex) -> {
                if (worldIn != null && pos != null) {
                    return BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos);
                }
                return ColorizerFoliage.func_77468_c();
            };
            try {
                Map colorMap = (Map)ObfuscationReflectionHelper.findField(BlockColors.class, (String)"blockColorMap").get(colors);
                parent = colorMap.getOrDefault(Blocks.field_150395_bd.delegate, parent);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            IBlockColor finalParent = parent;
            colors.func_186722_a((state, worldIn, pos, i) -> {
                Biome b;
                if (worldIn != null && pos != null && (b = worldIn.func_180494_b(pos)) == Biomes.field_76780_h) {
                    return 6975545;
                }
                return finalParent.func_186720_a(state, worldIn, pos, i);
            }, new Block[]{Blocks.field_150395_bd});
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ((BlockLeaves)variant_leaves).func_150122_b(Minecraft.func_71410_x().field_71474_y.field_74347_j);
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }
}

