/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.lib.util.script;

import com.bloodnbonesgaming.lib.BNBGamingLib;
import com.bloodnbonesgaming.lib.util.script.ScriptParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScriptUtil {
    private static Map<String, Class> mainClassKeywords = new HashMap<String, Class>();

    public static boolean readScript(File file, Object mainObj, Map<String, Class> classKeywords) {
        return ScriptUtil.readScript(file, mainObj, classKeywords, null);
    }

    public static boolean readScript(File file, Object mainObj, Map<String, Class> classKeywords, Map<String, Object> localVariables) {
        List<String> scriptLines = ScriptUtil.getScriptLines(file);
        if (!scriptLines.isEmpty()) {
            return new ScriptParser(scriptLines, file.getAbsolutePath(), mainObj, classKeywords, localVariables).parseScript();
        }
        return true;
    }

    public static Class getClassForKeyword(String keyword) {
        return mainClassKeywords.get(keyword);
    }

    public static List<String> getScriptLines(File file) {
        ArrayList<String> array = new ArrayList<String>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            String line;
            while ((line = r.readLine()) != null) {
                array.add(line.trim());
            }
        }
        catch (IOException e) {
            BNBGamingLib.libInstance.getLog().error("Failed to load script file " + file.getName());
        }
        return array;
    }

    public static void addClassKeyword(String keyword, Class clazz) {
        if (keyword != null && clazz != null) {
            mainClassKeywords.put(keyword, clazz);
        }
    }

    public static void addClassKeywords(Map<String, Class> keywords) {
        if (keywords != null && !keywords.isEmpty()) {
            mainClassKeywords.putAll(keywords);
        }
    }
}

