/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.input;

import de.keksuccino.konkrete.resources.ResourceUtils;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;

public class MouseInput {
    private static Cursor VRESIZE_CURSOR;
    private static Cursor HRESIZE_CURSOR;
    private static boolean leftClicked;
    private static boolean rightClicked;
    private static Map<String, Boolean> vanillainput;
    private static boolean ignoreBlocked;
    private static boolean useRenderScale;
    private static float renderScale;
    private static List<Consumer<MouseData>> listeners;

    public static void init() {
        VRESIZE_CURSOR = MouseInput.loadCursor(new ResourceLocation("keksuccino", "cursor/vresize.png"), 32, 32, 16, 16);
        HRESIZE_CURSOR = MouseInput.loadCursor(new ResourceLocation("keksuccino", "cursor/hresize.png"), 32, 32, 16, 16);
        MinecraftForge.EVENT_BUS.register((Object)new MouseInput());
    }

    public static boolean isLeftMouseDown() {
        return leftClicked;
    }

    public static boolean isRightMouseDown() {
        return rightClicked;
    }

    public static int getMouseX() {
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int i1 = scaledresolution.func_78326_a();
        int x = Mouse.getX() * i1 / Minecraft.func_71410_x().field_71443_c;
        if (useRenderScale) {
            return (int)((float)x / renderScale);
        }
        return x;
    }

    public static int getMouseY() {
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int j1 = scaledresolution.func_78328_b();
        int y = j1 - Mouse.getY() * j1 / Minecraft.func_71410_x().field_71440_d - 1;
        if (useRenderScale) {
            return (int)((float)y / renderScale);
        }
        return y;
    }

    public static void setRenderScale(float scale) {
        renderScale = scale;
        useRenderScale = true;
    }

    public static void resetRenderScale() {
        useRenderScale = false;
    }

    public static void setCursor(CursorType cursor) {
        try {
            if (cursor == null) {
                MouseInput.resetCursor();
            }
            if (cursor == CursorType.HRESIZE) {
                Mouse.setNativeCursor((Cursor)HRESIZE_CURSOR);
            }
            if (cursor == CursorType.VRESIZE) {
                Mouse.setNativeCursor((Cursor)VRESIZE_CURSOR);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void resetCursor() {
        try {
            Mouse.setNativeCursor(null);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    private static Cursor loadCursor(ResourceLocation r, int width, int height, int xHotspot, int yHotspot) {
        try {
            BufferedImage i = ResourceUtils.getImageResourceAsStream(r);
            if (i.getType() != 2) {
                BufferedImage tmp = new BufferedImage(i.getWidth(), i.getHeight(), 2);
                tmp.getGraphics().drawImage(i, 0, 0, null);
                i = tmp;
            }
            int[] srcPixels = ((DataBufferInt)i.getRaster().getDataBuffer()).getData();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(srcPixels.length * 4);
            byteBuffer.order(ByteOrder.nativeOrder());
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            intBuffer.put(srcPixels);
            intBuffer.position(0);
            return new Cursor(width, height, xHotspot, yHotspot, 1, intBuffer, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void blockVanillaInput(String category) {
        vanillainput.put(category, true);
    }

    public static void unblockVanillaInput(String category) {
        vanillainput.put(category, false);
    }

    public static boolean isVanillaInputBlocked() {
        if (ignoreBlocked) {
            return false;
        }
        return vanillainput.containsValue(true);
    }

    public static void ignoreBlockedVanillaInput(boolean ignore) {
        ignoreBlocked = ignore;
    }

    public static void registerMouseListener(Consumer<MouseData> c) {
        listeners.add(c);
    }

    @SubscribeEvent
    public void onMouseClicked(GuiScreenEvent.MouseInputEvent.Pre e) {
        for (Consumer<MouseData> c : listeners) {
            c.accept(new MouseData(MouseInput.getMouseX(), MouseInput.getMouseY(), Mouse.getEventDX(), Mouse.getEventDY(), Mouse.getEventDWheel()));
        }
        int i = Mouse.getEventButton();
        if (i == 0 && Mouse.getEventButtonState()) {
            leftClicked = true;
        }
        if (i == 1 && Mouse.getEventButtonState()) {
            rightClicked = true;
        }
        if (i == 0 && !Mouse.getEventButtonState()) {
            leftClicked = false;
        }
        if (i == 1 && !Mouse.getEventButtonState()) {
            rightClicked = false;
        }
        if (MouseInput.isVanillaInputBlocked()) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onScreenInit(GuiScreenEvent.InitGuiEvent.Pre e) {
        leftClicked = false;
        rightClicked = false;
        vanillainput.clear();
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71462_r == null) {
            vanillainput.clear();
        }
    }

    static {
        leftClicked = false;
        rightClicked = false;
        vanillainput = new HashMap<String, Boolean>();
        ignoreBlocked = false;
        useRenderScale = false;
        renderScale = 1.0f;
        listeners = new ArrayList<Consumer<MouseData>>();
    }

    public static class MouseData {
        public int deltaX;
        public int deltaY;
        public int deltaZ;
        public int mouseX;
        public int mouseY;

        public MouseData(int mouseX, int mouseY, int deltaX, int deltaY, int deltaZ) {
            this.deltaX = deltaX;
            this.deltaY = deltaY;
            this.deltaZ = deltaZ;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
        }
    }

    public static enum CursorType {
        VRESIZE,
        HRESIZE;

    }
}

