/*
 * Decompiled with CFR 0.152.
 */
package noisethreader.mixin.otg;

import com.pg85.otg.generator.noise.NoiseGeneratorPerlin;
import com.pg85.otg.generator.noise.NoiseGeneratorPerlinOctaves;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.util.math.MathHelper;
import noisethreader.handlers.ForgeConfigHandler;
import noisethreader.handlers.OTGNoiseHandler;
import noisethreader.handlers.ThreadHandler;
import noisethreader.mixin.otg.INoiseGeneratorPerlinMixin;
import noisethreader.util.INoiseGeneratorPerlinOctaves;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NoiseGeneratorPerlinOctaves.class})
public abstract class NoiseGeneratorPerlinOctavesMixin
implements INoiseGeneratorPerlinOctaves {
    @Shadow(remap=false)
    private int numOctaves;
    @Shadow(remap=false)
    private NoiseGeneratorPerlin[] noiseArray;
    @Unique
    private final OTGNoiseHandler noisethreader$otgNoiseHandler = new OTGNoiseHandler();
    @Unique
    private int noisethreader$octaveSplitAmount = 0;

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    private void noisethreader_otgNoiseGeneratorPerlinOctaves_init(Random seed, int octavesIn, CallbackInfo ci) {
        if (ThreadHandler.getPoolSize() >= ForgeConfigHandler.server.threadPoolMinimumSize) {
            this.noisethreader$octaveSplitAmount = (int)((double)(this.numOctaves + 1) / 2.0);
        }
    }

    @Overwrite(remap=false)
    public double[] Noise3D(double[] doubleArray, int xOffset, int yOffset, int zOffset, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale) {
        if (doubleArray == null) {
            doubleArray = new double[xSize * ySize * zSize];
        } else {
            Arrays.fill(doubleArray, 0.0);
        }
        if (this.noisethreader$octaveSplitAmount <= 0 || this.numOctaves * xSize * ySize * zSize / this.noisethreader$octaveSplitAmount < 550) {
            return this.noisethreader$generateNoiseOctavesOTG(doubleArray, xOffset, yOffset, zOffset, xSize, ySize, zSize, xScale, yScale, zScale);
        }
        return this.noisethreader$otgNoiseHandler.generateOTGNoiseOctaves((NoiseGeneratorPerlinOctaves)this, doubleArray, xOffset, yOffset, zOffset, xSize, ySize, zSize, xScale, yScale, zScale, this.numOctaves, 2, this.noisethreader$octaveSplitAmount);
    }

    @Override
    @Unique
    public double[] noisethreader$generateNoiseOctavesOTG(double[] doubleArray, int xOffset, int yOffset, int zOffset, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale) {
        double d3 = 1.0;
        for (int j = 0; j < this.numOctaves; ++j) {
            double d0 = (double)xOffset * d3 * xScale;
            double d1 = (double)yOffset * d3 * yScale;
            double d2 = (double)zOffset * d3 * zScale;
            long k = MathHelper.func_76124_d((double)d0);
            long l = MathHelper.func_76124_d((double)d2);
            d0 -= (double)k;
            d2 -= (double)l;
            ((INoiseGeneratorPerlinMixin)this.noiseArray[j]).invokePopulateNoiseArray3D(doubleArray, d0 += (double)(k %= 0x1000000L), d1, d2 += (double)(l %= 0x1000000L), xSize, ySize, zSize, xScale * d3, yScale * d3, zScale * d3, d3);
            d3 /= 2.0;
        }
        return doubleArray;
    }

    @Override
    @Unique
    public double[] noisethreader$generateNoiseOctavesThreaded(double[] doubleArray, int xOffset, int yOffset, int zOffset, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale, int octaveStart, int octaveEnd) {
        if (doubleArray == null) {
            doubleArray = new double[xSize * ySize * zSize];
        }
        double d3 = 1.0;
        for (int i = 0; i < octaveStart; ++i) {
            d3 /= 2.0;
        }
        for (int j = octaveStart; j < octaveEnd; ++j) {
            double d0 = (double)xOffset * d3 * xScale;
            double d1 = (double)yOffset * d3 * yScale;
            double d2 = (double)zOffset * d3 * zScale;
            long k = MathHelper.func_76124_d((double)d0);
            long l = MathHelper.func_76124_d((double)d2);
            d0 -= (double)k;
            d2 -= (double)l;
            ((INoiseGeneratorPerlinMixin)this.noiseArray[j]).invokePopulateNoiseArray3D(doubleArray, d0 += (double)(k %= 0x1000000L), d1, d2 += (double)(l %= 0x1000000L), xSize, ySize, zSize, xScale * d3, yScale * d3, zScale * d3, d3);
            d3 /= 2.0;
        }
        return doubleArray;
    }
}

