/*
 * Decompiled with CFR 0.152.
 */
package noisethreader.mixin.bettercaves;

import com.yungnickyoung.minecraft.bettercaves.enums.CavernType;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseColumn;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseGen;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtils;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverSettings;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverUtils;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cavern.CavernCarver;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cavern.CavernCarverBuilder;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import noisethreader.util.bettercaves.ICavernCarver;
import noisethreader.util.bettercaves.NoiseColumnNew;
import noisethreader.util.bettercaves.NoiseGenNew;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CavernCarver.class})
public abstract class CavernCarverMixin
implements ICavernCarver {
    @Shadow(remap=false)
    private CarverSettings settings;
    @Shadow(remap=false)
    private NoiseGen noiseGen;
    @Shadow(remap=false)
    private int bottomY;
    @Shadow(remap=false)
    private CavernType cavernType;
    @Shadow(remap=false)
    private World world;
    @Unique
    private NoiseGenNew noisethreader$noiseGenNew;

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void noisethreader$betterCavesCavernCarver_init(CavernCarverBuilder builder, CallbackInfo ci) {
        this.noisethreader$noiseGenNew = new NoiseGenNew(this.settings.getWorld(), this.settings.isFastNoise(), this.settings.getNoiseSettings(), this.settings.getNumGens(), this.settings.getyCompression(), this.settings.getXzCompression());
        this.noiseGen = null;
    }

    @Overwrite(remap=false)
    public void carveColumn(ChunkPrimer primer, BlockPos colPos, int topY, float smoothAmp, NoiseColumn noises, IBlockState liquidBlock, boolean flooded) {
    }

    @Override
    @Unique
    public void noisethreader$carveColumnNew(ChunkPrimer primer, BlockPos colPos, int topY, float smoothAmp, NoiseColumnNew noises, IBlockState liquidBlock, boolean flooded) {
        if (this.bottomY >= 0 && this.bottomY <= 255) {
            int localX = BetterCavesUtils.getLocal((int)colPos.func_177958_n());
            int localZ = BetterCavesUtils.getLocal((int)colPos.func_177952_p());
            if (localX >= 0 && localX <= 15 && localZ >= 0 && localZ <= 15 && topY <= 255) {
                int topTransitionBoundary = Math.max((topY -= 2) - 6, 1);
                int bottomTransitionBoundary = this.bottomY + 3;
                if (this.cavernType == CavernType.FLOORED) {
                    bottomTransitionBoundary = this.bottomY < this.settings.getLiquidAltitude() ? this.settings.getLiquidAltitude() + 8 : this.bottomY + 7;
                }
                bottomTransitionBoundary = Math.min(bottomTransitionBoundary, 255);
                for (int y = topY; y >= this.bottomY && (y > this.settings.getLiquidAltitude() || liquidBlock != null); --y) {
                    boolean digBlock = false;
                    float noise = 1.0f;
                    for (double n : noises.get(y).getNoiseValuesArray()) {
                        noise *= (float)n;
                    }
                    float noiseThreshold = this.settings.getNoiseThreshold();
                    if (y >= topTransitionBoundary) {
                        noiseThreshold *= (float)(y - topY) / (float)(topTransitionBoundary - topY);
                    }
                    if (y < bottomTransitionBoundary) {
                        noiseThreshold *= (float)(y - this.bottomY) / (float)(bottomTransitionBoundary - this.bottomY);
                    }
                    if (smoothAmp < 1.0f) {
                        noiseThreshold *= smoothAmp;
                    }
                    if (noise < noiseThreshold) {
                        digBlock = true;
                    }
                    if (this.settings.isEnableDebugVisualizer()) {
                        BlockPos blockPos = new BlockPos(localX, y, localZ);
                        CarverUtils.debugDigBlock((ChunkPrimer)primer, (BlockPos)blockPos, (IBlockState)this.settings.getDebugBlock(), (boolean)digBlock);
                        continue;
                    }
                    if (!digBlock) continue;
                    BlockPos blockPos = new BlockPos(localX, y, localZ);
                    IBlockState airBlockState = flooded && y < this.world.func_181545_F() ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P();
                    CarverUtils.digBlock((World)this.settings.getWorld(), (ChunkPrimer)primer, (BlockPos)blockPos, (IBlockState)airBlockState, (IBlockState)liquidBlock, (int)this.settings.getLiquidAltitude(), (boolean)this.settings.isReplaceFloatingGravel());
                }
            }
        }
    }

    @Overwrite(remap=false)
    public NoiseGen getNoiseGen() {
        return null;
    }

    @Override
    @Unique
    public NoiseGenNew noisethreader$getNoiseGenNew() {
        return this.noisethreader$noiseGenNew;
    }
}

