/*
 * Decompiled with CFR 0.152.
 */
package noisethreader.mixin.bettercaves;

import com.yungnickyoung.minecraft.bettercaves.noise.NoiseColumn;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseGen;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtils;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverSettings;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverUtils;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cave.CaveCarver;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cave.CaveCarverBuilder;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import noisethreader.util.bettercaves.ICaveCarver;
import noisethreader.util.bettercaves.NoiseColumnNew;
import noisethreader.util.bettercaves.NoiseGenNew;
import noisethreader.util.bettercaves.NoiseTupleNew;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CaveCarver.class})
public abstract class CaveCarverMixin
implements ICaveCarver {
    @Shadow(remap=false)
    private CarverSettings settings;
    @Shadow(remap=false)
    private int bottomY;
    @Shadow(remap=false)
    private int surfaceCutoff;
    @Shadow(remap=false)
    private boolean enableYAdjust;
    @Shadow(remap=false)
    private World world;
    @Shadow(remap=false)
    private float yAdjustF1;
    @Shadow(remap=false)
    private float yAdjustF2;
    @Shadow(remap=false)
    private NoiseGen noiseGen;
    @Unique
    private NoiseGenNew noisethreader$noiseGenNew;

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void noisethreader$betterCavesCaveCarver_init(CaveCarverBuilder builder, CallbackInfo ci) {
        this.noisethreader$noiseGenNew = new NoiseGenNew(this.settings.getWorld(), this.settings.isFastNoise(), this.settings.getNoiseSettings(), this.settings.getNumGens(), this.settings.getyCompression(), this.settings.getXzCompression());
        this.noiseGen = null;
    }

    @Overwrite(remap=false)
    public void carveColumn(ChunkPrimer primer, BlockPos colPos, int topY, NoiseColumn noises, IBlockState liquidBlock, boolean flooded) {
    }

    @Override
    @Unique
    public void noisethreader$carveColumnNew(ChunkPrimer primer, BlockPos colPos, int topY, NoiseColumnNew noises, IBlockState liquidBlock, boolean flooded) {
        if (this.bottomY >= 0 && this.bottomY <= 255 && topY >= 0 && topY <= 255) {
            int localX = BetterCavesUtils.getLocal((int)colPos.func_177958_n());
            int localZ = BetterCavesUtils.getLocal((int)colPos.func_177952_p());
            if (localX >= 0 && localX <= 15 && localZ >= 0 && localZ <= 15) {
                int transitionBoundary = topY - this.surfaceCutoff;
                if (transitionBoundary < 1) {
                    transitionBoundary = 1;
                }
                float[] thresholds = this.noisethreader$generateThresholdsArray(topY, this.bottomY, transitionBoundary);
                if (this.enableYAdjust) {
                    this.noisethreader$preprocessCaveNoiseColArray(noises, topY, this.bottomY, thresholds, this.settings.getNumGens());
                }
                for (int y = topY; y >= this.bottomY && (y > this.settings.getLiquidAltitude() || liquidBlock != null); --y) {
                    boolean digBlock = true;
                    for (double noise : noises.get(y).getNoiseValuesArray()) {
                        if (!(noise < (double)thresholds[y])) continue;
                        digBlock = false;
                        break;
                    }
                    if (this.settings.isEnableDebugVisualizer()) {
                        BlockPos blockPos = new BlockPos(localX, y, localZ);
                        CarverUtils.debugDigBlock((ChunkPrimer)primer, (BlockPos)blockPos, (IBlockState)this.settings.getDebugBlock(), (boolean)digBlock);
                        continue;
                    }
                    if (!digBlock) continue;
                    IBlockState airBlockState = flooded && y < this.world.func_181545_F() ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P();
                    BlockPos blockPos = new BlockPos(localX, y, localZ);
                    CarverUtils.digBlock((World)this.settings.getWorld(), (ChunkPrimer)primer, (BlockPos)blockPos, (IBlockState)airBlockState, (IBlockState)liquidBlock, (int)this.settings.getLiquidAltitude(), (boolean)this.settings.isReplaceFloatingGravel());
                }
            }
        }
    }

    @Overwrite(remap=false)
    private void preprocessCaveNoiseCol(NoiseColumn noises, int topY, int bottomY, Map<Integer, Float> thresholds, int numGens) {
    }

    @Unique
    private void noisethreader$preprocessCaveNoiseColArray(NoiseColumnNew noises, int topY, int bottomY, float[] thresholds, int numGens) {
        for (int realY = topY; realY >= bottomY; --realY) {
            NoiseTupleNew noiseBlock = noises.get(realY);
            boolean valid = true;
            for (double noise : noiseBlock.getNoiseValuesArray()) {
                if (!(noise < (double)thresholds[realY])) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            float f1 = this.yAdjustF1;
            float f2 = this.yAdjustF2;
            if (realY < topY) {
                NoiseTupleNew tupleAbove = noises.get(realY + 1);
                for (int i = 0; i < numGens; ++i) {
                    tupleAbove.set(i, (double)(1.0f - f1) * tupleAbove.get(i) + (double)f1 * noiseBlock.get(i));
                }
            }
            if (realY >= topY - 1) continue;
            NoiseTupleNew tupleTwoAbove = noises.get(realY + 2);
            for (int i = 0; i < numGens; ++i) {
                tupleTwoAbove.set(i, (double)(1.0f - f2) * tupleTwoAbove.get(i) + (double)f2 * noiseBlock.get(i));
            }
        }
    }

    @Overwrite(remap=false)
    private Map<Integer, Float> generateThresholds(int topY, int bottomY, int transitionBoundary) {
        return null;
    }

    @Unique
    private float[] noisethreader$generateThresholdsArray(int topY, int bottomY, int transitionBoundary) {
        float[] thresholds = new float[topY + 1];
        for (int realY = bottomY; realY <= topY; ++realY) {
            float noiseThreshold = this.settings.getNoiseThreshold();
            if (realY >= transitionBoundary) {
                noiseThreshold *= 1.0f + 0.3f * ((float)(realY - transitionBoundary) / (float)(topY - transitionBoundary));
            }
            thresholds[realY] = noiseThreshold;
        }
        return thresholds;
    }

    @Overwrite(remap=false)
    public NoiseGen getNoiseGen() {
        return null;
    }

    @Override
    @Unique
    public NoiseGenNew noisethreader$getNoiseGenNew() {
        return this.noisethreader$noiseGenNew;
    }
}

