/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.box;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.box.BoxCorner;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class AlignedBox {
    public float minX;
    public float minY;
    public float minZ;
    public float maxX;
    public float maxY;
    public float maxZ;

    public AlignedBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public AlignedBox(AxisAlignedBB box) {
        this((float)box.field_72340_a, (float)box.field_72338_b, (float)box.field_72339_c, (float)box.field_72336_d, (float)box.field_72337_e, (float)box.field_72334_f);
    }

    public AlignedBox() {
        this(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public AlignedBox(AlignedBox cube) {
        this(cube.minX, cube.minY, cube.minZ, cube.maxX, cube.maxY, cube.maxZ);
    }

    public void add(float x, float y, float z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
    }

    public void sub(float x, float y, float z) {
        this.minX -= x;
        this.minY -= y;
        this.minZ -= z;
        this.maxX -= x;
        this.maxY -= y;
        this.maxZ -= z;
    }

    public void add(Vector3d vec) {
        this.add((float)vec.x, (float)vec.y, (float)vec.z);
    }

    public void sub(Vector3d vec) {
        this.sub((float)vec.x, (float)vec.y, (float)vec.z);
    }

    public void add(Vec3i vec) {
        this.add(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public void sub(Vec3i vec) {
        this.sub(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public void scale(float scale) {
        this.minX *= scale;
        this.minY *= scale;
        this.minZ *= scale;
        this.maxX *= scale;
        this.maxY *= scale;
        this.maxZ *= scale;
    }

    public Vector3d getSize() {
        return new Vector3d((double)(this.maxX - this.minX), (double)(this.maxY - this.minY), (double)(this.maxZ - this.minZ));
    }

    public Vector3d getCenter() {
        return new Vector3d((double)(this.maxX + this.minX) * 0.5, (double)(this.maxY + this.minY) * 0.5, (double)(this.maxZ + this.minZ) * 0.5);
    }

    public String toString() {
        return "cube[" + this.minX + ", " + this.minY + ", " + this.minZ + " -> " + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }

    public Vector3f getCorner(BoxCorner corner) {
        return new Vector3f(this.getValueOfFacing(corner.x), this.getValueOfFacing(corner.y), this.getValueOfFacing(corner.z));
    }

    public AxisAlignedBB getBB() {
        return new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
    }

    public AxisAlignedBB getBB(BlockPos pos) {
        return new AxisAlignedBB((double)(this.minX + (float)pos.func_177958_n()), (double)(this.minY + (float)pos.func_177956_o()), (double)(this.minZ + (float)pos.func_177952_p()), (double)(this.maxX + (float)pos.func_177958_n()), (double)(this.maxY + (float)pos.func_177956_o()), (double)(this.maxZ + (float)pos.func_177952_p()));
    }

    public void rotate(Rotation rotation, Vector3f center) {
        Vector3f low = new Vector3f(this.minX, this.minY, this.minZ);
        Vector3f high = new Vector3f(this.maxX, this.maxY, this.maxZ);
        low.sub((Tuple3f)center);
        high.sub((Tuple3f)center);
        rotation.getMatrix().transform((Tuple3f)low);
        rotation.getMatrix().transform((Tuple3f)high);
        low.add((Tuple3f)center);
        high.add((Tuple3f)center);
        this.set(low.x, low.y, low.z, high.x, high.y, high.z);
    }

    public void rotate(EnumFacing facing, Vector3f center) {
        Matrix3f matrix = new Matrix3f();
        if (facing.func_176740_k() == EnumFacing.Axis.X) {
            facing = facing.func_176734_d();
        }
        matrix.rotY((float)Math.toRadians(facing.func_185119_l()));
        this.rotate(matrix, center);
    }

    public void rotate(Matrix3f matrix, Vector3f center) {
        Vector3f low = new Vector3f(this.minX, this.minY, this.minZ);
        Vector3f high = new Vector3f(this.maxX, this.maxY, this.maxZ);
        low.sub((Tuple3f)center);
        high.sub((Tuple3f)center);
        matrix.transform((Tuple3f)low);
        matrix.transform((Tuple3f)high);
        low.add((Tuple3f)center);
        high.add((Tuple3f)center);
        this.set(low.x, low.y, low.z, high.x, high.y, high.z);
    }

    public void set(float x, float y, float z, float x2, float y2, float z2) {
        this.minX = Math.min(x, x2);
        this.minY = Math.min(y, y2);
        this.minZ = Math.min(z, z2);
        this.maxX = Math.max(x, x2);
        this.maxY = Math.max(y, y2);
        this.maxZ = Math.max(z, z2);
    }

    public BlockPos getOffset() {
        return new BlockPos((double)this.minX, (double)this.minY, (double)this.minZ);
    }

    public float getValueOfFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return this.maxX;
            }
            case WEST: {
                return this.minX;
            }
            case UP: {
                return this.maxY;
            }
            case DOWN: {
                return this.minY;
            }
            case SOUTH: {
                return this.maxZ;
            }
            case NORTH: {
                return this.minZ;
            }
        }
        return 0.0f;
    }

    public float getSize(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.maxX - this.minX;
            }
            case Y: {
                return this.maxY - this.minY;
            }
            case Z: {
                return this.maxZ - this.minZ;
            }
        }
        return 0.0f;
    }

    public void setMin(EnumFacing.Axis axis, float value) {
        switch (axis) {
            case X: {
                this.minX = value;
                break;
            }
            case Y: {
                this.minY = value;
                break;
            }
            case Z: {
                this.minZ = value;
            }
        }
    }

    public float getMin(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.minX;
            }
            case Y: {
                return this.minY;
            }
            case Z: {
                return this.minZ;
            }
        }
        return 0.0f;
    }

    public void setMax(EnumFacing.Axis axis, float value) {
        switch (axis) {
            case X: {
                this.maxX = value;
                break;
            }
            case Y: {
                this.maxY = value;
                break;
            }
            case Z: {
                this.maxZ = value;
            }
        }
    }

    public float getMax(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.maxX;
            }
            case Y: {
                return this.maxY;
            }
            case Z: {
                return this.maxZ;
            }
        }
        return 0.0f;
    }

    public void shrink(EnumFacing.Axis axis, float value) {
        this.setMin(axis, this.getMin(axis) + (value /= 2.0f));
        this.setMax(axis, this.getMax(axis) - value);
    }
}

