/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.kiwi.Kiwi;
import snownee.kiwi.network.PacketMod;

public final class NetworkChannel {
    public static final NetworkChannel INSTANCE = new NetworkChannel();
    private final Object2IntMap<Class<? extends PacketMod>> mapping = new Object2IntArrayMap();
    private final Int2ObjectMap<Class<? extends PacketMod>> mappingReverse = new Int2ObjectArrayMap();
    private int nextIndex = 0;
    private final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("kiwi");

    private NetworkChannel() {
        this.channel.register((Object)this);
    }

    @SubscribeEvent
    public void onServerPacketIncoming(FMLNetworkEvent.ServerCustomPacketEvent event) {
        this.handleOnServer(this.decodeData(event.getPacket().payload()), ((NetHandlerPlayServer)event.getHandler()).field_147369_b);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientPacketIncoming(FMLNetworkEvent.ClientCustomPacketEvent event) {
        this.handleOnClient(this.decodeData(event.getPacket().payload()), Minecraft.func_71410_x().field_71439_g);
    }

    public void sendToAll(PacketMod packet) {
        this.channel.sendToAll(new FMLProxyPacket(new PacketBuffer(this.unpack(packet)), "kiwi"));
    }

    public void sendToAllTracking(PacketMod packet, int dim, BlockPos pos) {
        this.channel.sendToAllTracking(new FMLProxyPacket(new PacketBuffer(this.unpack(packet)), "kiwi"), new NetworkRegistry.TargetPoint(dim, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 4.0));
    }

    public void sendToAllAround(PacketMod packet, int dim, BlockPos pos) {
        this.sendToAllAround(packet, dim, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 16.0);
    }

    public void sendToAllAround(PacketMod packet, int dim, double x, double y, double z, double range) {
        this.channel.sendToAllAround(new FMLProxyPacket(new PacketBuffer(this.unpack(packet)), "kiwi"), new NetworkRegistry.TargetPoint(dim, x, y, z, range));
    }

    public void sendToDimension(PacketMod packet, int dim) {
        this.channel.sendToDimension(new FMLProxyPacket(new PacketBuffer(this.unpack(packet)), "kiwi"), dim);
    }

    public void sendToPlayer(PacketMod packet, EntityPlayerMP player) {
        this.channel.sendTo(new FMLProxyPacket(new PacketBuffer(this.unpack(packet)), "kiwi"), player);
    }

    public void sendToServer(PacketMod packet) {
        this.channel.sendToServer(new FMLProxyPacket(new PacketBuffer(this.unpack(packet)), "kiwi"));
    }

    public void register(Class<? extends PacketMod> klass) {
        this.mapping.put(klass, this.nextIndex);
        this.mappingReverse.put(this.nextIndex, klass);
        ++this.nextIndex;
    }

    private int getPacketIndex(Class<? extends PacketMod> klass) {
        return this.mapping.getInt(klass);
    }

    private PacketMod getByIndex(int index) {
        try {
            return (PacketMod)((Class)this.mappingReverse.get(index)).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    private PacketMod decodeData(ByteBuf buffer) {
        int index = buffer.readInt();
        PacketMod packet = this.getByIndex(index);
        if (packet == null) {
            Kiwi.logger.error("Receiving malformed packet");
            return null;
        }
        packet.readDataFrom(buffer);
        return packet;
    }

    @SideOnly(value=Side.CLIENT)
    private void handleOnClient(PacketMod packet, EntityPlayerSP player) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            try {
                packet.handleClient(player);
            }
            catch (Exception e) {
                Kiwi.logger.catching((Throwable)e);
            }
        });
    }

    private void handleOnServer(PacketMod packet, EntityPlayerMP player) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
            try {
                packet.handleServer(player);
            }
            catch (Exception e) {
                Kiwi.logger.catching((Throwable)e);
            }
        });
    }

    private ByteBuf unpack(PacketMod packet) {
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeInt(this.getPacketIndex(packet.getClass()));
        try {
            packet.writeDataTo(buffer);
        }
        catch (Exception e) {
            Kiwi.logger.catching((Throwable)e);
        }
        return buffer;
    }
}

