/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.client.screen.PressableButton;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.OrderData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.ApiData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.PlanService;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.BHOrderScreen;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.ProcessStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.SelectPlanTypeStep;
import java.util.function.Consumer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.config.GuiSlider;

public class SelectPackageStep
extends ProcessStep {
    private GuiSlider slider;
    private final PlanService planService;
    private int packageIndex;
    private final String perfectPlan = I18n.func_135052_a((String)"step.select_package.plan", (Object[])new Object[0]);
    private final String moveSlider = I18n.func_135052_a((String)"step.select_package.slider", (Object[])new Object[0]);

    public SelectPackageStep(OrderData orderData) {
        super(orderData);
        this.planService = orderData.isPremium ? (PlanService)ApiData.PLANS.getLeft() : (PlanService)ApiData.PLANS.getRight();
        this.packageIndex = this.getPackagePlanIndexFromRecommendations();
    }

    @Override
    public void init(BHOrderScreen screen, Consumer<GuiButton> children) {
        super.init(screen, children);
        int y = MathHelper.func_76125_a((int)(screen.field_146295_m / 2 - 10), (int)120, (int)(screen.field_146295_m - 50));
        this.slider = new GuiSlider(1, screen.field_146294_l / 2 - 100, y, 200, 20, "", "", 0.0, (double)(this.planService.plans.size() - 1), (double)this.packageIndex, false, false, slider -> {
            this.packageIndex = slider.getValueInt();
        });
        children.accept(new PressableButton(2, screen.field_146294_l / 2 - 50, y + 30, 100, 20, I18n.func_135052_a((String)"step.select_package.order_plan", (Object[])new Object[0]), b -> {
            this.orderData.packageId = this.getCurrentPlan().id;
            String url = this.getOrderUrl();
            ModRef.LOGGER.info("Setting up order link " + url);
            ModRef.openWebLink(url);
            screen.field_146297_k.func_147108_a(screen.parent);
        }));
        children.accept((GuiButton)this.slider);
    }

    @Override
    public void render(BHOrderScreen screen, FontRenderer font, int mouseX, int mouseY, float partialTicks) {
        PlanService.PackagePlan currentPlan = this.getCurrentPlan();
        font.func_175065_a(this.perfectPlan, (float)(screen.field_146294_l - font.func_78256_a(this.perfectPlan)) / 2.0f, (float)(this.slider.field_146129_i - 77), 0xFFFFFF, false);
        String plan = currentPlan.name;
        font.func_175065_a(plan, (float)(screen.field_146294_l - font.func_78256_a(plan)) / 2.0f, (float)(this.slider.field_146129_i - 50), 0xFFFFFF, false);
        String price = I18n.func_135052_a((String)"step.select_package.price", (Object[])new Object[]{Float.valueOf(currentPlan.price)});
        font.func_175065_a(price, (float)(screen.field_146294_l - font.func_78256_a(price)) / 2.0f, (float)(this.slider.field_146129_i - 40), 0xFFFFFF, false);
        font.func_175065_a(this.moveSlider, (float)(screen.field_146294_l - font.func_78256_a(this.moveSlider)) / 2.0f, (float)(this.slider.field_146129_i - 15), 0xFFFFFF, false);
    }

    private String getOrderUrl() {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("https://bisecthosting.com/modredirect.php?pid=");
        urlBuilder.append(this.orderData.packageId);
        urlBuilder.append("&configoption[");
        urlBuilder.append(this.orderData.isPremium ? 29 : 32);
        urlBuilder.append("]=");
        urlBuilder.append(this.orderData.getJarId());
        urlBuilder.append("&source=mod");
        if (!GlobalConfigs.partnerId.getValue().isEmpty()) {
            urlBuilder.append("&aid=");
            urlBuilder.append(GlobalConfigs.partnerId.getValue());
        }
        return urlBuilder.toString();
    }

    private PlanService.PackagePlan getCurrentPlan() {
        return this.planService.plans.get(this.packageIndex);
    }

    private int getPackagePlanIndexFromRecommendations() {
        int recommendedRam = ApiData.RAM_RECOMMENDATIONS.get(this.orderData.getJarId()).getRamForPlayers(this.orderData.playerCount);
        int planIndex = 0;
        boolean planFound = false;
        for (PlanService.PackagePlan plan : this.planService.plans) {
            if (plan.ram / 1024 >= recommendedRam) {
                planFound = true;
                break;
            }
            ++planIndex;
        }
        if (!planFound) {
            planIndex = 0;
        }
        return planIndex;
    }

    @Override
    public void onClose(BHOrderScreen screen) {
        screen.setStep(new SelectPlanTypeStep(this.orderData));
    }
}

