/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner;

import com.bisecthosting.mods.bhmenu.ModRoot;
import com.bisecthosting.mods.bhmenu.config.components.text.TextConfigEditBox;
import com.bisecthosting.mods.bhmenu.config.components.toggle.BooleanConfigButton;
import com.bisecthosting.mods.bhmenu.config.lists.ModuleConfigList;
import com.bisecthosting.mods.bhmenu.config.props.BooleanProperty;
import com.bisecthosting.mods.bhmenu.config.props.StringProperty;
import com.bisecthosting.mods.bhmenu.config.values.BooleanHolder;
import com.bisecthosting.mods.bhmenu.config.values.StringHolder;
import com.bisecthosting.mods.bhmenu.modules.BaseModule;
import com.google.common.base.Joiner;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerCreatorBanner
extends BaseModule {
    public static final Logger LOGGER = LogManager.getLogger();
    public StringProperty title;
    public StringProperty description;
    public BooleanProperty useLanguageFiles;

    public ServerCreatorBanner() {
        super("server_creator_banner");
    }

    public static ServerCreatorBanner get() {
        return ModRoot.get().modules.serverCreatorBanner;
    }

    @Override
    public void buildConfigs(ConfigCategory config) {
        Property titleConfig = (Property)config.computeIfAbsent((Object)"title", key -> {
            Property cfg = new Property(key, "Need a server?", Property.Type.STRING);
            cfg.setComment("The title to display at the top of the entry.");
            return cfg;
        });
        this.title = new StringProperty(titleConfig);
        Property descriptionConfig = (Property)config.computeIfAbsent((Object)"description", key -> {
            Property cfg = new Property(key, "Click me to get your own server!", Property.Type.STRING);
            cfg.setComment("The description to display below the title.");
            return cfg;
        });
        this.description = new StringProperty(descriptionConfig);
        Property useLanguageFilesConfig = (Property)config.computeIfAbsent((Object)"use_language_files", key -> {
            Property cfg = new Property(key, Boolean.toString(false), Property.Type.BOOLEAN);
            cfg.setComment(Joiner.on((char)'\n').join((Object[])new String[]{"Set this to true to use specific language translation keys.", "This requires a custom mod that adds resource files, such as OpenLoader.", "Use 'server_entry.title' key for the Title;", "Use 'server_entry.description' key for the Description."}));
            return cfg;
        });
        this.useLanguageFiles = new BooleanProperty(useLanguageFilesConfig);
    }

    @Override
    public boolean hasPackConfigs() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void populatePackConfigs(ModuleConfigList configs, Consumer<ModuleConfigList.Entry> entries) {
        String text = I18n.func_135052_a((String)"modules.server_creator_banner.config.title", (Object[])new Object[0]);
        entries.accept(new ModuleConfigList.Entry(configs, this.title.getConfig().getComment(), text, new TextConfigEditBox(0, new StringHolder(this.title), Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 20, text)));
        text = I18n.func_135052_a((String)"modules.server_creator_banner.config.description", (Object[])new Object[0]);
        entries.accept(new ModuleConfigList.Entry(configs, this.description.getConfig().getComment(), text, new TextConfigEditBox(1, new StringHolder(this.description), Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 20, text)));
        text = I18n.func_135052_a((String)"modules.server_creator_banner.config.use_language_files", (Object[])new Object[0]);
        entries.accept(new ModuleConfigList.Entry(configs, this.useLanguageFiles.getConfig().getComment(), text, new BooleanConfigButton(2, new BooleanHolder(this.useLanguageFiles), 0, 0, 0, 20)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void populateUserConfigs(ModuleConfigList configs, Consumer<ModuleConfigList.Entry> entries) {
    }

    public String getTitle() {
        return this.useLanguageFiles.getValue() != false ? I18n.func_135052_a((String)"server_entry.title", (Object[])new Object[0]) : this.title.getValue();
    }

    public String getDescription() {
        return this.useLanguageFiles.getValue() != false ? I18n.func_135052_a((String)"server_entry.description", (Object[])new Object[0]) : this.description.getValue();
    }
}

