/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.client.screen.PressableButton;
import com.bisecthosting.mods.bhmenu.client.screen.TickBoxButton;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.data.ServerListData;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServerLoadingScreen;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServerSelectionList;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenAddServer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.ServerPinger;
import net.minecraft.client.resources.I18n;

public class PublicServersScreen
extends GuiScreen {
    private static final Supplier<String> JOIN_SERVER_TEXT = () -> I18n.func_135052_a((String)"selectServer.select", (Object[])new Object[0]);
    private static final Supplier<String> ADD_SERVER_TEXT = () -> I18n.func_135052_a((String)"selectServer.add", (Object[])new Object[0]);
    private static final Supplier<String> BACK_TEXT = () -> I18n.func_135052_a((String)"gui.back", (Object[])new Object[0]);
    private static final Supplier<String> REFRESH_TEXT = () -> I18n.func_135052_a((String)"selectServer.refresh", (Object[])new Object[0]);
    private static final Supplier<String> TITLE_TEXT = () -> I18n.func_135052_a((String)"modules.public_server_list.title", (Object[])new Object[0]);
    private static final Supplier<String> HOW_TO_TEXT = () -> I18n.func_135052_a((String)"modules.public_server_list.how_to", (Object[])new Object[0]);
    private static final Supplier<String> NAME_FILTER_TEXT = () -> I18n.func_135052_a((String)"modules.public_server_list.filter.name", (Object[])new Object[0]);
    private static final Supplier<String> PING_SORT_TEXT = () -> I18n.func_135052_a((String)"modules.public_server_list.sort.ping", (Object[])new Object[0]);
    private static final Supplier<String> PLAYER_COUNT_SORT_TEXT = () -> I18n.func_135052_a((String)"modules.public_server_list.sort.player_count", (Object[])new Object[0]);
    private static final String HOW_TO_URL = "https://www.bisecthosting.com/clients/index.php?rp=/knowledgebase/348/How-to-add-a-modpack-server-to-the-public-server-list.html";
    private final ServerPinger pinger = new ServerPinger();
    private PublicServerSelectionList serverSelectionList;
    private ServerListData servers;
    private GuiButton addButton;
    private GuiButton joinButton;
    private GuiButton howTobutton;
    private GuiTextField searchBar;
    private TickBoxButton pingSort;
    private TickBoxButton playerCountSort;
    public static final float SPLIT = 0.4f;
    private List<String> tooltip;
    private boolean openedLink;
    public final GuiMultiplayer multiplayerScreen;
    private boolean hasInit;

    public PublicServersScreen(GuiMultiplayer multiplayerScreen, List<ServerData> servers) {
        this.multiplayerScreen = multiplayerScreen;
        this.servers = new ServerListData(servers);
    }

    public void func_73866_w_() {
        int splitWidth = (int)((float)this.field_146294_l * 0.4f);
        if (this.hasInit) {
            this.serverSelectionList.func_148122_a(this.field_146294_l - splitWidth, this.field_146295_m, 32, this.field_146295_m - 8);
            this.serverSelectionList.field_148152_e = splitWidth;
            this.serverSelectionList.field_148151_d = this.field_146294_l;
        } else {
            this.hasInit = true;
            this.serverSelectionList = new PublicServerSelectionList(this, this.field_146297_k, this.field_146294_l - splitWidth, this.field_146295_m, 32, this.field_146295_m - 8, 36);
            this.serverSelectionList.field_148152_e = splitWidth;
            this.serverSelectionList.field_148151_d = this.field_146294_l;
            this.serverSelectionList.updateOnlineServers(this.servers);
        }
        String oldSearchBarText = "";
        if (this.searchBar != null) {
            oldSearchBarText = this.searchBar.func_146179_b();
        }
        this.searchBar = new GuiTextField(0, this.field_146289_q, 10, 52, splitWidth - 20, 20);
        this.searchBar.func_146180_a(oldSearchBarText);
        this.searchBar.func_175207_a(new GuiPageButtonList.GuiResponder(){

            public void func_175321_a(int i, boolean b) {
                PublicServersScreen.this.updateSelectionNameFilter();
            }

            public void func_175320_a(int i, float v) {
                PublicServersScreen.this.updateSelectionNameFilter();
            }

            public void func_175319_a(int i, String s) {
                PublicServersScreen.this.updateSelectionNameFilter();
            }
        });
        this.pingSort = new TickBoxButton(1, splitWidth - 40, 90, this.pingSort, this.serverSelectionList::togglePingSort);
        this.func_189646_b((GuiButton)this.pingSort);
        this.playerCountSort = new TickBoxButton(2, splitWidth - 40, 124, this.playerCountSort, this.serverSelectionList::togglePlayerCountSort);
        this.func_189646_b((GuiButton)this.playerCountSort);
        int buttonWidth = Math.min(100, splitWidth / 2 - 4);
        this.func_189646_b(new PressableButton(3, splitWidth / 2 - buttonWidth - 2, this.field_146295_m - 28, buttonWidth, 20, REFRESH_TEXT.get(), b -> this.field_146297_k.func_147108_a((GuiScreen)new PublicServerLoadingScreen((GuiScreen)this.multiplayerScreen))));
        this.func_189646_b(new PressableButton(4, splitWidth / 2 + 2, this.field_146295_m - 28, buttonWidth, 20, BACK_TEXT.get(), b -> this.field_146297_k.func_147108_a((GuiScreen)this.multiplayerScreen)));
        this.joinButton = this.func_189646_b(new PressableButton(5, splitWidth / 2 - buttonWidth - 2, this.field_146295_m - 52, buttonWidth, 20, JOIN_SERVER_TEXT.get(), b -> this.joinSelectedServer()));
        this.joinButton.field_146124_l = false;
        this.addButton = this.func_189646_b(new PressableButton(6, splitWidth / 2 + 2, this.field_146295_m - 52, buttonWidth, 20, ADD_SERVER_TEXT.get(), b -> this.addSelectedServer()));
        this.addButton.field_146124_l = false;
        this.howTobutton = this.func_189646_b(new PressableButton(7, splitWidth / 2 - buttonWidth - 2, this.field_146295_m - 76, buttonWidth * 2 + 4, 20, HOW_TO_TEXT.get(), b -> this.openHowToPage()));
    }

    private void updateSelectionNameFilter() {
        this.serverSelectionList.setNameFilter(this.searchBar.func_146179_b());
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.serverSelectionList.func_178039_p();
    }

    public void func_73876_c() {
        this.pinger.func_147223_a();
        this.searchBar.func_146178_a();
        this.serverSelectionList.tick();
        if (this.openedLink) {
            this.openedLink = false;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float delta) {
        int splitWidth = (int)((float)this.field_146294_l * 0.4f);
        this.tooltip = null;
        this.func_146276_q_();
        this.serverSelectionList.func_148128_a(mouseX, mouseY, delta);
        this.searchBar.func_146194_f();
        super.func_73863_a(mouseX, mouseY, delta);
        float fontHeight = this.field_146289_q.field_78288_b;
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)TITLE_TEXT.get(), (Object[])new Object[0]), this.field_146294_l / 2, 10, -1);
        if (this.tooltip != null) {
            this.func_146283_a(this.tooltip, mouseX, mouseY);
        }
        this.func_73732_a(this.field_146289_q, NAME_FILTER_TEXT.get(), splitWidth / 2, 32, -1);
        this.func_73731_b(this.field_146289_q, PING_SORT_TEXT.get(), 20, 90 + (int)((20.0f - fontHeight) / 2.0f), -1);
        this.func_73731_b(this.field_146289_q, PLAYER_COUNT_SORT_TEXT.get(), 20, 124 + (int)((20.0f - fontHeight) / 2.0f), -1);
    }

    public void joinSelectedServer() {
        PublicServerSelectionList.Entry entry = this.serverSelectionList.getSelectedEntry();
        if (entry instanceof PublicServerSelectionList.ServerEntry) {
            this.join((PublicServerSelectionList.ServerEntry)entry);
        }
    }

    public void join(PublicServerSelectionList.ServerEntry entry) {
        this.serverSelectionList.setLastJoined(entry);
        this.join(entry.getServerData());
    }

    private void join(ServerData server) {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiConnecting((GuiScreen)this, this.field_146297_k, server));
    }

    public void addSelectedServer() {
        PublicServerSelectionList.Entry entry = this.serverSelectionList.getSelectedEntry();
        if (entry instanceof PublicServerSelectionList.ServerEntry) {
            PublicServerSelectionList.ServerEntry serverEntry = (PublicServerSelectionList.ServerEntry)entry;
            ServerData data = serverEntry.getServerData();
            this.multiplayerScreen.field_146811_z = new ServerData(data.field_78847_a, data.field_78845_b, false);
            this.multiplayerScreen.field_146811_z.func_152583_a(data);
            this.multiplayerScreen.field_146806_v = true;
            this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenAddServer((GuiScreen)this.multiplayerScreen, this.multiplayerScreen.field_146811_z));
        }
    }

    public void openHowToPage() {
        ModRef.LOGGER.info("Opening knowledgebase https://www.bisecthosting.com/clients/index.php?rp=/knowledgebase/348/How-to-add-a-modpack-server-to-the-public-server-list.html");
        ModRef.openWebLink(HOW_TO_URL);
        this.openedLink = true;
    }

    public void setSelected(PublicServerSelectionList.ServerEntry entry) {
        this.serverSelectionList.setSelected(entry);
        this.onSelectedChange();
    }

    protected void onSelectedChange() {
        this.joinButton.field_146124_l = false;
        this.addButton.field_146124_l = false;
        PublicServerSelectionList.Entry entry = this.serverSelectionList.getSelectedEntry();
        if (entry instanceof PublicServerSelectionList.ServerEntry) {
            this.joinButton.field_146124_l = true;
            this.addButton.field_146124_l = true;
        }
    }

    public void func_146281_b() {
        this.pinger.func_147226_b();
        this.serverSelectionList.stopPingingServer();
    }

    public void setTooltip(List<String> tooltip) {
        this.tooltip = tooltip;
    }

    public ServerPinger getPinger() {
        return this.pinger;
    }

    public ServerListData getServers() {
        return this.servers;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.serverSelectionList.func_148179_a(mouseX, mouseY, mouseButton);
        this.searchBar.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            if (!this.searchBar.func_146179_b().isEmpty()) {
                this.searchBar.func_146180_a("");
                return;
            }
            this.field_146297_k.func_147108_a((GuiScreen)this.multiplayerScreen);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        }
        this.searchBar.func_146201_a(typedChar, keyCode);
    }
}

