/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.publicserverlist;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.client.screen.CustomButton;
import com.bisecthosting.mods.bhmenu.config.components.text.IntegerConfigEditBox;
import com.bisecthosting.mods.bhmenu.config.components.toggle.BooleanConfigButton;
import com.bisecthosting.mods.bhmenu.config.lists.ModuleConfigList;
import com.bisecthosting.mods.bhmenu.config.props.BooleanProperty;
import com.bisecthosting.mods.bhmenu.config.props.IntegerProperty;
import com.bisecthosting.mods.bhmenu.config.values.BooleanHolder;
import com.bisecthosting.mods.bhmenu.config.values.IntegerHolder;
import com.bisecthosting.mods.bhmenu.modules.BaseModule;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServerLoadingScreen;
import com.google.common.base.Joiner;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PublicServerList
extends BaseModule {
    private static final ResourceLocation OPEN_SCREEN_TEX = ModRef.res("textures/publicserverlist/gui/open_screen_button.png");
    private static final Supplier<String> OPEN_SCREEN_TOOLTIP = () -> I18n.func_135052_a((String)"modules.public_server_list.open_screen.tooltip", (Object[])new Object[0]);
    private static final Supplier<String> OPEN_SCREEN_TEXT = () -> I18n.func_135052_a((String)"modules.public_server_list.open_screen.text", (Object[])new Object[0]);
    public static final Logger LOGGER = LogManager.getLogger();
    public IntegerProperty buttonX;
    public IntegerProperty buttonY;
    public IntegerProperty buttonWidth;
    public BooleanProperty vanillaButton;

    public PublicServerList() {
        super("public_server_list");
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void addPublicServerWidget(GuiScreenEvent.InitGuiEvent.Post event) {
        if (this.isEnabled() && event.getGui() instanceof GuiMultiplayer) {
            final GuiMultiplayer screen = (GuiMultiplayer)event.getGui();
            int buttonX = screen.field_146294_l / 2 + 160;
            if (this.buttonX.getValue() > -1) {
                buttonX = this.buttonX.getValue();
            }
            int buttonWidth = Math.min(100, screen.field_146294_l - buttonX - 4);
            if (this.buttonWidth.getValue() > 0) {
                buttonWidth = this.buttonWidth.getValue();
            }
            int buttonY = screen.field_146295_m - 52;
            if (this.buttonY.getValue() > -1) {
                buttonY = this.buttonY.getValue();
            }
            Object button = this.vanillaButton.getValue() != false ? new GuiButton(9276419, buttonX, buttonY, buttonWidth, 20, OPEN_SCREEN_TEXT.get()){

                public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    super.func_191745_a(mc, mouseX, mouseY, partialTicks);
                }

                public boolean func_146116_c(Minecraft p_146116_1_, int p_146116_2_, int p_146116_3_) {
                    if (super.func_146116_c(p_146116_1_, p_146116_2_, p_146116_3_)) {
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)new PublicServerLoadingScreen((GuiScreen)screen));
                        return true;
                    }
                    return false;
                }
            } : new CustomButton(9276419, buttonX, buttonY, buttonWidth, 20, OPEN_SCREEN_TEXT.get(), b -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new PublicServerLoadingScreen((GuiScreen)screen))){

                @Override
                public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    super.func_191745_a(mc, mouseX, mouseY, partialTicks);
                }
            };
            event.getButtonList().add(button);
        }
    }

    @Override
    public void buildConfigs(ConfigCategory config) {
        Property buttonXConfig = (Property)config.computeIfAbsent((Object)"button_x", key -> {
            Property cfg = new Property(key, "-1", Property.Type.INTEGER);
            cfg.setComment(Joiner.on((char)'\n').join((Object[])new String[]{"The position of the button from the left of the screen.", "Set to -1 to default."}));
            return cfg;
        });
        this.buttonX = new IntegerProperty(buttonXConfig);
        Property buttonYConfig = (Property)config.computeIfAbsent((Object)"button_y", key -> {
            Property cfg = new Property(key, "-1", Property.Type.INTEGER);
            cfg.setComment(Joiner.on((char)'\n').join((Object[])new String[]{"The position of the button from the top of the screen.", "Set to -1 to default."}));
            return cfg;
        });
        this.buttonY = new IntegerProperty(buttonYConfig);
        Property buttonWidthConfig = (Property)config.computeIfAbsent((Object)"button_width", key -> {
            Property cfg = new Property(key, "0", Property.Type.INTEGER);
            cfg.setComment(Joiner.on((char)'\n').join((Object[])new String[]{"The width of the button.", "Set to 0 to default."}));
            return cfg;
        });
        this.buttonWidth = new IntegerProperty(buttonWidthConfig);
        Property vanillaButtonConfig = (Property)config.computeIfAbsent((Object)"vanilla_button", key -> {
            Property cfg = new Property(key, Boolean.toString(false), Property.Type.BOOLEAN);
            cfg.setComment(Joiner.on((char)'\n').join((Object[])new String[]{"Turn the Public Server List button into a vanilla styled one.", "Causes default vanilla graphics and might help with compatibility with other mods."}));
            return cfg;
        });
        this.vanillaButton = new BooleanProperty(vanillaButtonConfig);
    }

    @Override
    public boolean hasPackConfigs() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void populatePackConfigs(ModuleConfigList configs, Consumer<ModuleConfigList.Entry> entries) {
        String text = I18n.func_135052_a((String)"modules.public_server_list.config.button_x", (Object[])new Object[0]);
        entries.accept(new ModuleConfigList.Entry(configs, this.buttonX.getConfig().getComment(), text, new IntegerConfigEditBox(0, new IntegerHolder(this.buttonX), Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 20, text)));
        text = I18n.func_135052_a((String)"modules.public_server_list.config.button_y", (Object[])new Object[0]);
        entries.accept(new ModuleConfigList.Entry(configs, this.buttonY.getConfig().getComment(), text, new IntegerConfigEditBox(1, new IntegerHolder(this.buttonY), Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 20, text)));
        text = I18n.func_135052_a((String)"modules.public_server_list.config.button_width", (Object[])new Object[0]);
        entries.accept(new ModuleConfigList.Entry(configs, this.buttonWidth.getConfig().getComment(), text, new IntegerConfigEditBox(2, new IntegerHolder(this.buttonWidth), Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 20, text)));
        text = I18n.func_135052_a((String)"modules.public_server_list.config.vanilla_button", (Object[])new Object[0]);
        entries.accept(new ModuleConfigList.Entry(configs, this.vanillaButton.getConfig().getComment(), text, new BooleanConfigButton(3, new BooleanHolder(this.vanillaButton), 0, 0, 0, 20)));
    }
}

